/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.rss;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.manifoldcf.agents.common.XMLContext;
import org.apache.manifoldcf.agents.common.XMLFileContext;
import org.apache.manifoldcf.agents.common.XMLStream;
import org.apache.manifoldcf.agents.common.XMLStringContext;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.TempFileCharacterInput;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.rss.DataCache;
import org.apache.manifoldcf.crawler.connectors.rss.Robots;
import org.apache.manifoldcf.crawler.connectors.rss.ThrottledFetcher;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.IFingerprintActivity;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.interfaces.IVersionActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.ui.util.Encoder;
import org.xml.sax.Attributes;

public class RSSConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: RSSConnector.java 994959 2010-09-08 10:04:42Z kwright $";
    public static final String robotsUsageParameter = "Robots usage";
    public static final String emailParameter = "Email address";
    public static final String bandwidthParameter = "KB per second";
    public static final String maxOpenParameter = "Max server connections";
    public static final String maxFetchesParameter = "Max fetches per minute";
    public static final String throttleGroupParameter = "Throttle group";
    public static final String proxyHostParameter = "Proxy host";
    public static final String proxyPortParameter = "Proxy port";
    public static final String proxyAuthDomainParameter = "Proxy authentication domain";
    public static final String proxyAuthUsernameParameter = "Proxy authentication user name";
    public static final String proxyAuthPasswordParameter = "Proxy authentication password";
    protected static final int ROBOTS_NONE = 0;
    protected static final int ROBOTS_DATA = 1;
    protected static final int ROBOTS_ALL = 2;
    public static final int DECHROMED_NONE = 0;
    public static final int DECHROMED_DESCRIPTION = 1;
    public static final int DECHROMED_CONTENT = 2;
    public static final int CHROMED_USE = 0;
    public static final int CHROMED_SKIP = 1;
    protected int robotsUsage = 2;
    protected String userAgent = null;
    protected String from = null;
    protected long minimumMillisecondsPerFetchPerServer = -1L;
    protected int maxOpenConnectionsPerServer = 0;
    protected double minimumMillisecondsPerBytePerServer = 0.0;
    protected String throttleGroupName = null;
    protected String proxyHost = null;
    protected int proxyPort = -1;
    protected String proxyAuthDomain = null;
    protected String proxyAuthUsername = null;
    protected String proxyAuthPassword = null;
    protected ThrottledFetcher fetcher = null;
    protected Robots robots = null;
    protected static Map fetcherMap = new HashMap();
    protected static Map robotsMap = new HashMap();
    protected boolean isInitialized = false;
    protected static DataCache cache = new DataCache();
    protected static final Map understoodProtocols = new HashMap();
    public static final String ACTIVITY_FETCH = "fetch";
    public static final String ACTIVITY_ROBOTSPARSE = "robots parse";
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    protected static HashMap monthMap;
    protected static final HashMap milTzMap;

    protected void getSession() throws ManifoldCFException {
        if (!this.isInitialized) {
            String emailAddress = this.params.getParameter(emailParameter);
            if (emailAddress == null) {
                throw new ManifoldCFException("Missing email address");
            }
            this.userAgent = "ApacheManifoldCFRSSFeedReader; " + (emailAddress == null ? "" : emailAddress) + ")";
            this.from = emailAddress;
            String robotsUsageString = this.params.getParameter(robotsUsageParameter);
            this.robotsUsage = 2;
            if (robotsUsageString == null || robotsUsageString.length() == 0 || robotsUsageString.equals("all")) {
                this.robotsUsage = 2;
            } else if (robotsUsageString.equals("none")) {
                this.robotsUsage = 0;
            } else if (robotsUsageString.equals("data")) {
                this.robotsUsage = 1;
            }
            this.proxyHost = this.params.getParameter(proxyHostParameter);
            String proxyPortString = this.params.getParameter(proxyPortParameter);
            this.proxyAuthDomain = this.params.getParameter(proxyAuthDomainParameter);
            this.proxyAuthUsername = this.params.getParameter(proxyAuthUsernameParameter);
            this.proxyAuthPassword = this.params.getObfuscatedParameter(proxyAuthPasswordParameter);
            this.proxyPort = -1;
            if (proxyPortString != null && proxyPortString.length() > 0) {
                try {
                    this.proxyPort = Integer.parseInt(proxyPortString);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
            this.minimumMillisecondsPerBytePerServer = 0.0;
            this.maxOpenConnectionsPerServer = 10;
            this.minimumMillisecondsPerFetchPerServer = 0L;
            String x = this.params.getParameter(bandwidthParameter);
            if (x != null && x.length() > 0) {
                try {
                    int maxKBytesPerSecondPerServer = Integer.parseInt(x);
                    if (maxKBytesPerSecondPerServer > 0) {
                        this.minimumMillisecondsPerBytePerServer = 1.0 / (double)maxKBytesPerSecondPerServer;
                    }
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            }
            if ((x = this.params.getParameter(maxOpenParameter)) != null && x.length() > 0) {
                try {
                    this.maxOpenConnectionsPerServer = Integer.parseInt(x);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            }
            if ((x = this.params.getParameter(maxFetchesParameter)) != null && x.length() > 0) {
                try {
                    int maxFetches = Integer.parseInt(x);
                    if (maxFetches == 0) {
                        maxFetches = 1;
                    }
                    this.minimumMillisecondsPerFetchPerServer = 60000L / (long)maxFetches;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            }
            this.isInitialized = true;
        }
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH, ACTIVITY_ROBOTSPARSE};
    }

    public int getConnectorModel() {
        return 0;
    }

    public String getJSPFolder() {
        return "rss";
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.throttleGroupName = this.params.getParameter(throttleGroupParameter);
        if (this.throttleGroupName == null) {
            this.throttleGroupName = "";
        }
        this.fetcher = this.getFetcher();
        this.robots = this.getRobots(this.fetcher);
        this.fetcher.noteConnectionEstablished();
        this.robots.noteConnectionEstablished();
    }

    public void poll() throws ManifoldCFException {
        this.fetcher.poll();
        this.robots.poll();
    }

    public String check() throws ManifoldCFException {
        this.getSession();
        return super.check();
    }

    public void disconnect() throws ManifoldCFException {
        this.isInitialized = false;
        this.robots.noteConnectionReleased();
        this.fetcher.noteConnectionReleased();
        this.userAgent = null;
        this.from = null;
        this.minimumMillisecondsPerFetchPerServer = -1L;
        this.maxOpenConnectionsPerServer = 0;
        this.minimumMillisecondsPerBytePerServer = 0.0;
        this.throttleGroupName = null;
        this.proxyHost = null;
        this.proxyPort = -1;
        this.proxyAuthDomain = null;
        this.proxyAuthUsername = null;
        this.proxyAuthPassword = null;
        super.disconnect();
    }

    public String[] getBinNames(String documentIdentifier) {
        try {
            URI uri = new URI(documentIdentifier);
            return new String[]{uri.getHost()};
        }
        catch (URISyntaxException e) {
            return new String[]{""};
        }
    }

    public void addSeedDocuments(ISeedingActivity activities, DocumentSpecification spec, long startTime, long endTime) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        Filter f = new Filter(spec, true);
        Iterator iter = f.getSeeds();
        while (iter.hasNext()) {
            String canonicalURL = (String)iter.next();
            activities.addSeedDocument(canonicalURL);
        }
    }

    protected static String makeDocumentIdentifier(CanonicalizationPolicies policies, String parentIdentifier, String rawURL) throws ManifoldCFException {
        try {
            URI url;
            CanonicalizationPolicy p = policies.findMatch(rawURL);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < rawURL.length()) {
                char x;
                if ((x = rawURL.charAt(i++)) < ' ' || x >= '\u0080') continue;
                sb.append(x);
            }
            rawURL = sb.toString();
            if (parentIdentifier != null) {
                URI parentURL = new URI(parentIdentifier);
                url = parentURL.resolve(rawURL);
            } else {
                url = new URI(rawURL);
            }
            String protocol = url.getScheme();
            String host = url.getHost();
            if (protocol == null || host == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it has no protocol or host"));
                }
                return null;
            }
            if (understoodProtocols.get(protocol) == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it has an unsupported protocol '" + protocol + "'"));
                }
                return null;
            }
            String id = RSSConnector.doCanonicalization(p, url);
            if (id == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it could not be canonicalized"));
                }
                return null;
            }
            i = 0;
            while (i < id.length()) {
                char x;
                if ((x = id.charAt(i++)) >= ' ' && x <= '\u007f') continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it has illegal characters in it"));
                }
                return null;
            }
            return id;
        }
        catch (URISyntaxException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it is badly formed: " + e.getMessage()));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because there was an argument error: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
        catch (NullPointerException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it is missing fields: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    protected static String doCanonicalization(CanonicalizationPolicy p, URI url) throws ManifoldCFException, URISyntaxException {
        String rval;
        String pathString;
        int index;
        String queryString = url.getRawQuery();
        if (queryString != null) {
            if (p == null || p.canReorder()) {
                HashMap<String, ArrayList<String>> argumentMap = new HashMap<String, ArrayList<String>>();
                index = 0;
                while (index < queryString.length()) {
                    String argument;
                    int valueIndex;
                    int newIndex = queryString.indexOf("&", index);
                    if (newIndex == -1) {
                        newIndex = queryString.length();
                    }
                    String key = (valueIndex = (argument = queryString.substring(index, newIndex)).indexOf("=")) == -1 ? argument : argument.substring(0, valueIndex);
                    boolean includeArgument = true;
                    if ((p == null || p.canRemovePhpSession()) && key.equals("PHPSESSID")) {
                        includeArgument = false;
                    }
                    if ((p == null || p.canRemoveBvSession()) && key.indexOf("BVSession@@@@") != -1) {
                        includeArgument = false;
                    }
                    if (includeArgument) {
                        ArrayList<String> list = (ArrayList<String>)argumentMap.get(key);
                        if (list == null) {
                            list = new ArrayList<String>();
                            argumentMap.put(key, list);
                        }
                        list.add(argument);
                    }
                    if (newIndex < queryString.length()) {
                        index = newIndex + 1;
                        continue;
                    }
                    index = newIndex;
                }
                Object[] sortArray = new String[argumentMap.size()];
                int i = 0;
                Iterator iter = argumentMap.keySet().iterator();
                while (iter.hasNext()) {
                    sortArray[i++] = (String)iter.next();
                }
                Arrays.sort(sortArray);
                StringBuffer newString = new StringBuffer();
                boolean isFirst = true;
                i = 0;
                while (i < sortArray.length) {
                    Object key = sortArray[i++];
                    ArrayList list = (ArrayList)argumentMap.get(key);
                    int j = 0;
                    while (j < list.size()) {
                        if (!isFirst) {
                            newString.append("&");
                        } else {
                            isFirst = false;
                        }
                        newString.append((String)list.get(j++));
                    }
                }
                queryString = newString.toString();
            } else {
                StringBuffer newString = new StringBuffer();
                index = 0;
                boolean isFirst = true;
                while (index < queryString.length()) {
                    String argument;
                    int valueIndex;
                    int newIndex = queryString.indexOf("&", index);
                    if (newIndex == -1) {
                        newIndex = queryString.length();
                    }
                    String key = (valueIndex = (argument = queryString.substring(index, newIndex)).indexOf("=")) == -1 ? argument : argument.substring(0, valueIndex);
                    boolean includeArgument = true;
                    if ((p == null || p.canRemovePhpSession()) && key.equals("PHPSESSID")) {
                        includeArgument = false;
                    }
                    if ((p == null || p.canRemoveBvSession()) && key.indexOf("BVSession@@@@") != -1) {
                        includeArgument = false;
                    }
                    if (includeArgument) {
                        if (!isFirst) {
                            newString.append("&");
                        } else {
                            isFirst = false;
                        }
                        newString.append(argument);
                    }
                    if (newIndex < queryString.length()) {
                        index = newIndex + 1;
                        continue;
                    }
                    index = newIndex;
                }
                queryString = newString.toString();
            }
        }
        if ((pathString = url.getPath()) != null) {
            index = pathString.indexOf(";jsessionid=");
            if ((p == null || p.canRemoveJavaSession()) && index != -1) {
                pathString = pathString.substring(0, index);
            }
            if ((p == null || p.canRemoveAspSession()) && pathString.startsWith("/s(") && (index = pathString.indexOf(")")) != -1) {
                pathString = pathString.substring(index + 1);
            }
        }
        if ((rval = (url = new URI(url.getScheme(), null, url.getHost(), url.getPort(), pathString, null, null)).toASCIIString()) != null && queryString != null && queryString.length() > 0) {
            rval = rval + "?" + queryString;
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String[] getDocumentVersions(String[] documentIdentifiers, String[] oldVersions, IVersionActivity activities, DocumentSpecification spec, int jobType, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        connectionLimit = 200;
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("RSS: In getDocumentVersions for " + Integer.toString(documentIdentifiers.length) + " documents"));
        }
        f = new Filter(spec, false);
        acls = f.getAcls();
        Arrays.sort(acls);
        namesAndValues = f.getMetadata();
        metadata = new String[namesAndValues.size()];
        k = 0;
        fixedListStrings = new String[2];
        while (k < metadata.length) {
            nv = (NameValue)namesAndValues.get(k);
            name = nv.getName();
            value = nv.getValue();
            fixedListStrings[0] = name;
            fixedListStrings[1] = value;
            newsb = new StringBuffer();
            RSSConnector.packFixedList(newsb, fixedListStrings, '=');
            metadata[k++] = newsb.toString();
        }
        Arrays.sort(metadata);
        Logging.connectors.debug((Object)"RSS: Done setting up metadata version strings");
        feedTimeout = f.getFeedTimeoutValue();
        rval = new String[documentIdentifiers.length];
        block32: for (i = 0; i < documentIdentifiers.length; ++i) {
            urlValue = documentIdentifiers[i];
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: Getting version string for '" + urlValue + "'"));
            }
            dechromedData = activities.retrieveParentDataAsFiles(urlValue, "data");
            try {
                if (dechromedData.length > 0) {
                    ingestURL = f.mapDocumentURL(urlValue);
                    if (ingestURL != null) {
                        try {
                            is = dechromedData[0].getUtf8Stream();
                            try {
                                sb = new StringBuffer();
                                checkSum = RSSConnector.cache.addData(activities, urlValue, is);
                                pubDates = activities.retrieveParentData(urlValue, "pubdate");
                                sources = activities.retrieveParentData(urlValue, "source");
                                titles = activities.retrieveParentData(urlValue, "title");
                                categories = activities.retrieveParentData(urlValue, "category");
                                Arrays.sort(pubDates);
                                Arrays.sort(sources);
                                Arrays.sort(titles);
                                Arrays.sort(categories);
                                if (sources.length == 0 && Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("RSS: Warning; URL '" + ingestURL + "' doesn't seem to have any RSS feed source!"));
                                }
                                sb.append('+');
                                RSSConnector.packList(sb, (String[])acls, '+');
                                if (acls.length > 0) {
                                    sb.append('+');
                                    RSSConnector.pack(sb, "DEAD_AUTHORITY", '+');
                                } else {
                                    sb.append('-');
                                }
                                RSSConnector.packList(sb, (String[])metadata, '+');
                                RSSConnector.pack(sb, ingestURL, '+');
                                RSSConnector.packList(sb, (String[])pubDates, '+');
                                RSSConnector.packList(sb, (String[])titles, '+');
                                RSSConnector.packList(sb, (String[])sources, '+');
                                RSSConnector.packList(sb, (String[])categories, '+');
                                sb.append(new Long(checkSum).toString());
                                rval[i] = sb.toString();
                                continue;
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new ManifoldCFException("Unsupported encoding: " + e.getMessage(), (Throwable)e);
                        }
                        catch (SocketTimeoutException e) {
                            throw new ManifoldCFException("IO exception reading data from string: " + e.getMessage(), (Throwable)e);
                        }
                        catch (InterruptedIOException e) {
                            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                        }
                        catch (IOException e) {
                            throw new ManifoldCFException("IO exception reading data from string: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!Logging.connectors.isDebugEnabled()) continue;
                    Logging.connectors.debug((Object)("RSS: Skipping carry-down document '" + urlValue + "' because it is unmappable or is a seed."));
                    continue;
                }
                oldVersionString = oldVersions[i];
                lastETagValue = null;
                lastModifiedValue = null;
                if (Logging.connectors.isDebugEnabled() && (lastETagValue != null || lastModifiedValue != null)) {
                    Logging.connectors.debug((Object)("RSS: Document '" + urlValue + "' was found to have a previous ETag value of '" + (lastETagValue == null ? "null" : lastETagValue) + "' and a previous Last-Modified value of '" + (lastModifiedValue == null ? "null" : lastModifiedValue) + "'"));
                }
                try {
                    url = new URL(urlValue);
                    protocol = url.getProtocol();
                    port = url.getPort();
                    hostName = url.getHost();
                    pathPart = url.getFile();
                    if (this.robotsUsage >= 1 && !this.robots.isFetchAllowed(protocol, port, hostName, url.getPath(), this.userAgent, this.from, this.minimumMillisecondsPerBytePerServer, this.maxOpenConnectionsPerServer, this.minimumMillisecondsPerFetchPerServer, this.proxyHost, this.proxyPort, this.proxyAuthDomain, this.proxyAuthUsername, this.proxyAuthPassword, activities, connectionLimit)) {
                        activities.recordActivity(null, "fetch", null, urlValue, Integer.toString(-2), "Robots exclusion", null);
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("RSS: Skipping url '" + urlValue + "' because robots.txt says to"));
                        }
                        rval[i] = null;
                        continue;
                    }
                    connection = this.fetcher.createConnection(hostName, this.minimumMillisecondsPerBytePerServer, this.maxOpenConnectionsPerServer, this.minimumMillisecondsPerFetchPerServer, connectionLimit, feedTimeout);
                    try {
                        connection.beginFetch("Data");
                        try {
                            status = connection.executeFetch(protocol, port, pathPart, this.userAgent, this.from, this.proxyHost, this.proxyPort, this.proxyAuthDomain, this.proxyAuthUsername, this.proxyAuthPassword, lastETagValue, lastModifiedValue);
                            switch (status) {
                                case 3: {
                                    rval[i] = oldVersionString;
                                    ** break;
lbl110:
                                    // 1 sources

                                    continue block32;
                                }
                                case 0: {
                                    try {
                                        if (Logging.connectors.isDebugEnabled()) {
                                            Logging.connectors.debug((Object)("RSS: Successfully fetched " + urlValue));
                                        }
                                        if ((contentType = connection.getResponseHeader("Content-Type")) != null) {
                                            contentTypes = contentType.split(",");
                                            contentType = contentTypes.length > 0 ? contentTypes[contentTypes.length - 1].trim() : null;
                                        }
                                        isXML = contentType != null && (contentType.startsWith("text/xml") != false || contentType.startsWith("application/rss+xml") != false || contentType.startsWith("application/xml") != false || contentType.startsWith("application/atom+xml") != false || contentType.startsWith("application/xhtml+xml") != false || contentType.startsWith("text/XML") != false || contentType.startsWith("application/rdf+xml") != false || contentType.startsWith("text/application") != false || contentType.startsWith("XML") != false);
                                        ingestURL = null;
                                        if (!isXML) {
                                            if (f.getChromedContentMode() == 1) {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("RSS: Removing url '" + urlValue + "' because it no longer has dechromed content available"));
                                                }
                                                rval[i] = null;
                                                ** break;
lbl126:
                                                // 1 sources

                                                continue block32;
                                            }
                                            if (!this.isContentInteresting((IFingerprintActivity)activities, contentType)) {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("RSS: Removing url '" + urlValue + "' because it had the wrong content type: " + (contentType == null ? "null" : "'" + contentType + "'")));
                                                }
                                                rval[i] = null;
                                                ** break;
lbl132:
                                                // 1 sources

                                                continue block32;
                                            }
                                            ingestURL = f.mapDocumentURL(urlValue);
                                        } else {
                                            if (Logging.connectors.isDebugEnabled()) {
                                                Logging.connectors.debug((Object)("RSS: The url '" + urlValue + "' is a feed"));
                                            }
                                            if (!f.isSeed(urlValue)) {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("RSS: Removing feed url '" + urlValue + "' because it is not a seed."));
                                                }
                                                rval[i] = null;
                                                ** break;
lbl142:
                                                // 1 sources

                                                continue block32;
                                            }
                                        }
                                        is = connection.getResponseBodyStream();
                                        try {
                                            checkSum = RSSConnector.cache.addData(activities, urlValue, is);
                                            sb = new StringBuffer();
                                            if (ingestURL != null) {
                                                pubDates = activities.retrieveParentData(urlValue, "pubdate");
                                                sources = activities.retrieveParentData(urlValue, "source");
                                                titles = activities.retrieveParentData(urlValue, "title");
                                                categories = activities.retrieveParentData(urlValue, "category");
                                                Arrays.sort(pubDates);
                                                Arrays.sort(sources);
                                                Arrays.sort(titles);
                                                Arrays.sort(categories);
                                                if (sources.length == 0 && Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("RSS: Warning; URL '" + ingestURL + "' doesn't seem to have any RSS feed source!"));
                                                }
                                                sb.append('+');
                                                RSSConnector.packList(sb, (String[])acls, '+');
                                                if (acls.length > 0) {
                                                    sb.append('+');
                                                    RSSConnector.pack(sb, "DEAD_AUTHORITY", '+');
                                                } else {
                                                    sb.append('-');
                                                }
                                                RSSConnector.packList(sb, (String[])metadata, '+');
                                                RSSConnector.pack(sb, ingestURL, '+');
                                                RSSConnector.packList(sb, (String[])pubDates, '+');
                                                RSSConnector.packList(sb, (String[])titles, '+');
                                                RSSConnector.packList(sb, (String[])sources, '+');
                                                RSSConnector.packList(sb, (String[])categories, '+');
                                            } else {
                                                sb.append('-');
                                                etag = connection.getResponseHeader("ETag");
                                                if (etag == null) {
                                                    RSSConnector.pack(sb, "", '+');
                                                } else {
                                                    RSSConnector.pack(sb, etag, '+');
                                                }
                                                lastModified = connection.getResponseHeader("Last-Modified");
                                                if (lastModified == null) {
                                                    RSSConnector.pack(sb, "", '+');
                                                } else {
                                                    RSSConnector.pack(sb, lastModified, '+');
                                                }
                                            }
                                            sb.append(new Long(checkSum).toString());
                                            rval[i] = sb.toString();
                                            continue block32;
                                        }
                                        finally {
                                            is.close();
                                        }
                                    }
                                    catch (SocketTimeoutException e) {
                                        Logging.connectors.warn((Object)("RSS: Socket timeout exception fetching document contents '" + urlValue + "' - skipping: " + e.getMessage()), (Throwable)e);
                                        rval[i] = null;
                                        ** break;
lbl198:
                                        // 1 sources

                                        continue block32;
                                    }
                                    catch (ConnectTimeoutException e) {
                                        Logging.connectors.warn((Object)("RSS: Connecto timeout exception fetching document contents '" + urlValue + "' - skipping: " + e.getMessage()), (Throwable)e);
                                        rval[i] = null;
                                        ** break;
lbl203:
                                        // 1 sources

                                        continue block32;
                                    }
                                    catch (InterruptedIOException e) {
                                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                                    }
                                    catch (IOException e) {
                                        Logging.connectors.warn((Object)("RSS: IO exception fetching document contents '" + urlValue + "' - skipping: " + e.getMessage()), (Throwable)e);
                                        rval[i] = null;
                                        ** break;
lbl210:
                                        // 1 sources

                                        continue block32;
                                    }
                                }
                                default: {
                                    rval[i] = "";
                                    continue block32;
                                }
                            }
                        }
                        finally {
                            connection.doneFetch(activities);
                        }
                    }
                    finally {
                        connection.close();
                    }
                }
                catch (MalformedURLException e) {
                    Logging.connectors.debug((Object)("RSS: URL '" + urlValue + "' is malformed; skipping"), (Throwable)e);
                    rval[i] = null;
                }
                continue;
            }
            finally {
                j = 0;
                while (j < dechromedData.length) {
                    if ((ci = dechromedData[j++]) == null) continue;
                    ci.discard();
                }
            }
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, String[] versions, IProcessActivity activities, DocumentSpecification spec, boolean[] scanOnly, int jobType) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        Filter f = null;
        String[] fixedList = new String[2];
        int i = 0;
        while (i < documentIdentifiers.length) {
            String urlValue = documentIdentifiers[i];
            String version = versions[i];
            if (version.length() == 0) {
                ++i;
                activities.deleteDocument(urlValue);
                continue;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: Processing '" + urlValue + "'"));
            }
            if (version.startsWith("-")) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Interpreting document '" + urlValue + "' as a feed"));
                }
                if (f == null) {
                    f = new Filter(spec, false);
                }
                this.handleRSSFeedSAX(urlValue, activities, f);
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Extraction of feed '" + urlValue + "' complete"));
                }
                activities.recordDocument(urlValue, version);
            } else if (!scanOnly[i] && version.startsWith("+")) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Interpreting '" + urlValue + "' as a document"));
                }
                ArrayList acls = new ArrayList();
                StringBuffer denyAclBuffer = new StringBuffer();
                int startPos = RSSConnector.unpackList(acls, version, 1, '+');
                if (startPos < version.length() && version.charAt(startPos++) == '+') {
                    startPos = RSSConnector.unpack(denyAclBuffer, version, startPos, '+');
                }
                ArrayList metadata = new ArrayList();
                startPos = RSSConnector.unpackList(metadata, version, startPos, '+');
                StringBuffer ingestUrlBuffer = new StringBuffer();
                startPos = RSSConnector.unpack(ingestUrlBuffer, version, startPos, '+');
                String ingestURL = ingestUrlBuffer.toString();
                ArrayList pubDates = new ArrayList();
                startPos = RSSConnector.unpackList(pubDates, version, startPos, '+');
                ArrayList titles = new ArrayList();
                startPos = RSSConnector.unpackList(titles, version, startPos, '+');
                ArrayList sources = new ArrayList();
                startPos = RSSConnector.unpackList(sources, version, startPos, '+');
                ArrayList categories = new ArrayList();
                startPos = RSSConnector.unpackList(categories, version, startPos, '+');
                if (ingestURL.length() > 0) {
                    InputStream is;
                    long dataSize = cache.getDataLength(urlValue);
                    RepositoryDocument rd = new RepositoryDocument();
                    String[] aclArray = new String[acls.size()];
                    for (int j = 0; j < aclArray.length; ++j) {
                        aclArray[j] = (String)acls.get(j);
                    }
                    rd.setACL(aclArray);
                    if (denyAclBuffer.length() > 0) {
                        String[] denyAclArray = new String[]{denyAclBuffer.toString()};
                        rd.setDenyACL(denyAclArray);
                    }
                    HashMap<String, HashMap<String, String>> metaHash = new HashMap<String, HashMap<String, String>>();
                    int k = 0;
                    while (k < metadata.size()) {
                        String metadataItem = (String)metadata.get(k++);
                        RSSConnector.unpackFixedList(fixedList, metadataItem, 0, '=');
                        HashMap<String, String> hashValue = (HashMap<String, String>)metaHash.get(fixedList[0]);
                        if (hashValue == null) {
                            hashValue = new HashMap<String, String>();
                            metaHash.put(fixedList[0], hashValue);
                        }
                        hashValue.put(fixedList[1], fixedList[1]);
                    }
                    for (String key : metaHash.keySet()) {
                        HashMap metaList = (HashMap)metaHash.get(key);
                        String[] values = new String[metaList.size()];
                        Iterator iter = metaList.keySet().iterator();
                        k = 0;
                        while (iter.hasNext()) {
                            values[k] = (String)iter.next();
                            ++k;
                        }
                        rd.addField(key, values);
                    }
                    String[] titleValues = new String[titles.size()];
                    for (k = 0; k < titleValues.length; ++k) {
                        titleValues[k] = (String)titles.get(k);
                    }
                    if (k > 0) {
                        rd.addField("title", titleValues);
                    }
                    String[] sourceValues = new String[sources.size()];
                    for (k = 0; k < sourceValues.length; ++k) {
                        sourceValues[k] = (String)sources.get(k);
                    }
                    if (k > 0) {
                        rd.addField("source", sourceValues);
                    }
                    String[] categoryValues = new String[categories.size()];
                    for (k = 0; k < categoryValues.length; ++k) {
                        categoryValues[k] = (String)categories.get(k);
                    }
                    if (k > 0) {
                        rd.addField("category", categoryValues);
                    }
                    Long minimumOrigTime = null;
                    String[] pubDateValues = new String[pubDates.size()];
                    k = 0;
                    while (k < pubDates.size()) {
                        String pubDate = (String)pubDates.get(k);
                        pubDateValues[k++] = pubDate;
                        try {
                            Long pubDateLong = new Long(pubDate);
                            if (minimumOrigTime != null && pubDateLong >= minimumOrigTime) continue;
                            minimumOrigTime = pubDateLong;
                        }
                        catch (NumberFormatException e) {}
                    }
                    if (k > 0) {
                        rd.addField("pubdate", pubDateValues);
                    }
                    if (minimumOrigTime != null) {
                        activities.setDocumentOriginationTime(urlValue, minimumOrigTime);
                    }
                    if ((is = cache.getData(urlValue)) != null) {
                        try {
                            rd.setBinary(is, dataSize);
                            activities.ingestDocument(urlValue, version, ingestURL, rd);
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (SocketTimeoutException e) {
                                throw new ManifoldCFException("IO error closing stream: " + e.getMessage(), (Throwable)e);
                            }
                            catch (InterruptedIOException e) {
                                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                            }
                            catch (IOException e) {
                                throw new ManifoldCFException("IO error closing stream: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            } else if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: Skipping document '" + urlValue + "' because it cannot have interesting links"));
            }
            ++i;
        }
    }

    public void releaseDocumentVersions(String[] documentIdentifiers, String[] versions) throws ManifoldCFException {
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            String version = versions[i];
            if (version == null) continue;
            String urlValue = documentIdentifiers[i];
            cache.deleteData(urlValue);
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, ArrayList tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add("Email");
        tabsArray.add("Robots");
        tabsArray.add("Bandwidth");
        tabsArray.add("Proxy");
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig()\n{\n  if (editconnection.email.value != \"\" && editconnection.email.value.indexOf(\"@\") == -1)\n  {\n    alert(\"Need a valid email address\");\n    editconnection.email.focus();\n    return false;\n  }\n  if (editconnection.bandwidth.value != \"\" && !isInteger(editconnection.bandwidth.value))\n  {\n    alert(\"Enter a valid number, or blank for no limit\");\n    editconnection.bandwidth.focus();\n    return false;\n  }\n  if (editconnection.connections.value == \"\" || !isInteger(editconnection.connections.value))\n  {\n    alert(\"Enter a valid number for the max number of open connections per server\");\n    editconnection.connections.focus();\n    return false;\n  }\n  if (editconnection.fetches.value != \"\" && !isInteger(editconnection.fetches.value))\n  {\n    alert(\"Enter a valid number, or blank for no limit\");\n    editconnection.fetches.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction checkConfigForSave()\n{\n  if (editconnection.email.value == \"\")\n  {\n    alert(\"Email address required, to be included in all request headers\");\n    SelectTab(\"Email\");\n    editconnection.email.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String proxyAuthPassword;
        String proxyAuthUsername;
        String proxyAuthDomain;
        String proxyPort;
        String proxyHost;
        String throttleGroup;
        String fetches;
        String connections;
        String bandwidth;
        String robotsUsage;
        String email = parameters.getParameter(emailParameter);
        if (email == null) {
            email = "";
        }
        if ((robotsUsage = parameters.getParameter(robotsUsageParameter)) == null) {
            robotsUsage = "all";
        }
        if ((bandwidth = parameters.getParameter(bandwidthParameter)) == null) {
            bandwidth = "64";
        }
        if ((connections = parameters.getParameter(maxOpenParameter)) == null) {
            connections = "2";
        }
        if ((fetches = parameters.getParameter(maxFetchesParameter)) == null) {
            fetches = "12";
        }
        if ((throttleGroup = parameters.getParameter(throttleGroupParameter)) == null) {
            throttleGroup = "";
        }
        if ((proxyHost = parameters.getParameter(proxyHostParameter)) == null) {
            proxyHost = "";
        }
        if ((proxyPort = parameters.getParameter(proxyPortParameter)) == null) {
            proxyPort = "";
        }
        if ((proxyAuthDomain = parameters.getParameter(proxyAuthDomainParameter)) == null) {
            proxyAuthDomain = "";
        }
        if ((proxyAuthUsername = parameters.getParameter(proxyAuthUsernameParameter)) == null) {
            proxyAuthUsername = "";
        }
        if ((proxyAuthPassword = parameters.getObfuscatedParameter(proxyAuthPasswordParameter)) == null) {
            proxyAuthPassword = "";
        }
        if (tabName.equals("Email")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Email address to contact:</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"email\" value=\"" + Encoder.attributeEscape((String)email) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"email\" value=\"" + Encoder.attributeEscape((String)email) + "\"/>\n");
        }
        if (tabName.equals("Robots")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Robots.txt usage:</nobr></td>\n    <td class=\"value\">\n      <select name=\"robotsusage\" size=\"3\">\n        <option value=\"none\" " + (robotsUsage.equals("none") ? "selected=\"selected\"" : "") + ">Don't look at robots.txt</option>\n" + "        <option value=\"data\" " + (robotsUsage.equals("data") ? "selected=\"selected\"" : "") + ">Obey robots.txt for data fetches only</option>\n" + "        <option value=\"all\" " + (robotsUsage.equals("all") ? "selected=\"selected\"" : "") + ">Obey robots.txt for all fetches</option>\n" + "      </select>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"robotsusage\" value=\"" + robotsUsage + "\"/>\n");
        }
        if (tabName.equals("Bandwidth")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Max KBytes per second per server:</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"6\" name=\"bandwidth\" value=\"" + Encoder.attributeEscape((String)bandwidth) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Max connections per server:</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"4\" name=\"connections\" value=\"" + Encoder.attributeEscape((String)connections) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Max fetches per minute per server:</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"4\" name=\"fetches\" value=\"" + Encoder.attributeEscape((String)fetches) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Throttle group name:</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"throttlegroup\" value=\"" + Encoder.attributeEscape((String)throttleGroup) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"bandwidth\" value=\"" + Encoder.attributeEscape((String)bandwidth) + "\"/>\n" + "<input type=\"hidden\" name=\"connections\" value=\"" + Encoder.attributeEscape((String)connections) + "\"/>\n" + "<input type=\"hidden\" name=\"fetches\" value=\"" + Encoder.attributeEscape((String)fetches) + "\"/>\n" + "<input type=\"hidden\" name=\"throttlegroup\" value=\"" + Encoder.attributeEscape((String)throttleGroup) + "\"/>\n");
        }
        if (tabName.equals("Proxy")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Proxy host:</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"40\" name=\"proxyhost\" value=\"" + Encoder.attributeEscape((String)proxyHost) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Proxy port:</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"proxyport\" value=\"" + Encoder.attributeEscape((String)proxyPort) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Proxy authentication domain:</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"proxyauthdomain\" value=\"" + Encoder.attributeEscape((String)proxyAuthDomain) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Proxy authentication user name:</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"proxyauthusername\" value=\"" + Encoder.attributeEscape((String)proxyAuthUsername) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Proxy authentication password:</nobr></td>\n" + "    <td class=\"value\"><input type=\"password\" size=\"16\" name=\"proxyauthpassword\" value=\"" + Encoder.attributeEscape((String)proxyAuthPassword) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"proxyhost\" value=\"" + Encoder.attributeEscape((String)proxyHost) + "\"/>\n" + "<input type=\"hidden\" name=\"proxyport\" value=\"" + Encoder.attributeEscape((String)proxyPort) + "\"/>\n" + "<input type=\"hidden\" name=\"proxyauthusername\" value=\"" + Encoder.attributeEscape((String)proxyAuthUsername) + "\"/>\n" + "<input type=\"hidden\" name=\"proxyauthdomain\" value=\"" + Encoder.attributeEscape((String)proxyAuthDomain) + "\"/>\n" + "<input type=\"hidden\" name=\"proxyauthpassword\" value=\"" + Encoder.attributeEscape((String)proxyAuthPassword) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String proxyAuthPassword;
        String proxyAuthUsername;
        String proxyAuthDomain;
        String proxyPort;
        String proxyHost;
        String throttleGroup;
        String fetches;
        String connections;
        String bandwidth;
        String robotsUsage;
        String email = variableContext.getParameter("email");
        if (email != null) {
            parameters.setParameter(emailParameter, email);
        }
        if ((robotsUsage = variableContext.getParameter("robotsusage")) != null) {
            parameters.setParameter(robotsUsageParameter, robotsUsage);
        }
        if ((bandwidth = variableContext.getParameter("bandwidth")) != null) {
            parameters.setParameter(bandwidthParameter, bandwidth);
        }
        if ((connections = variableContext.getParameter("connections")) != null) {
            parameters.setParameter(maxOpenParameter, connections);
        }
        if ((fetches = variableContext.getParameter("fetches")) != null) {
            parameters.setParameter(maxFetchesParameter, fetches);
        }
        if ((throttleGroup = variableContext.getParameter("throttlegroup")) != null) {
            parameters.setParameter(throttleGroupParameter, throttleGroup);
        }
        if ((proxyHost = variableContext.getParameter("proxyhost")) != null) {
            parameters.setParameter(proxyHostParameter, proxyHost);
        }
        if ((proxyPort = variableContext.getParameter("proxyport")) != null) {
            parameters.setParameter(proxyPortParameter, proxyPort);
        }
        if ((proxyAuthDomain = variableContext.getParameter("proxyauthdomain")) != null) {
            parameters.setParameter(proxyAuthDomainParameter, proxyAuthDomain);
        }
        if ((proxyAuthUsername = variableContext.getParameter("proxyauthusername")) != null) {
            parameters.setParameter(proxyAuthUsernameParameter, proxyAuthUsername);
        }
        if ((proxyAuthPassword = variableContext.getParameter("proxyauthpassword")) != null) {
            parameters.setObfuscatedParameter(proxyAuthPasswordParameter, proxyAuthPassword);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>Parameters:</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=<" + Integer.toString(kmanager.getContents().length) + " certificate(s)></nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, DocumentSpecification ds, ArrayList tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add("URLs");
        tabsArray.add("Canonicalization");
        tabsArray.add("Mappings");
        tabsArray.add("Time Values");
        tabsArray.add("Security");
        tabsArray.add("Metadata");
        tabsArray.add("Dechromed Content");
        out.print("<script type=\"text/javascript\">\n<!--\nfunction SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n\nfunction AddRegexp(anchorvalue)\n{\n  if (editjob.rssmatch.value == \"\")\n  {\n    alert(\"Match must have a regexp value\");\n    editjob.rssmatch.focus();\n    return;\n  }\n\n  SpecOp(\"rssop\",\"Add\",anchorvalue);\n}\n\nfunction RemoveRegexp(index, anchorvalue)\n{\n  editjob.rssindex.value = index;\n  SpecOp(\"rssop\",\"Delete\",anchorvalue);\n}\n\nfunction SpecAddToken(anchorvalue)\n{\n  if (editjob.spectoken.value == \"\")\n  {\n    alert(\"Type in an access token\");\n    editjob.spectoken.focus();\n    return;\n  }\n  SpecOp(\"accessop\",\"Add\",anchorvalue);\n}\n\nfunction SpecAddMetadata(anchorvalue)\n{\n  if (editjob.specmetaname.value == \"\")\n  {\n    alert(\"Type in metadata name\");\n    editjob.specmetaname.focus();\n    return;\n  }\n  if (editjob.specmetavalue.value == \"\")\n  {\n    alert(\"Type in metadata value\");\n    editjob.specmetavalue.focus();\n    return;\n  }\n  SpecOp(\"metadataop\",\"Add\",anchorvalue);\n}\n\nfunction URLRegexpDelete(index, anchorvalue)\n{\n  editjob.urlregexpnumber.value = index;\n  SpecOp(\"urlregexpop\",\"Delete\",anchorvalue);\n}\n\nfunction URLRegexpAdd(anchorvalue)\n{\n  SpecOp(\"urlregexpop\",\"Add\",anchorvalue);\n}\n\nfunction checkSpecification()\n{\n  if (editjob.feedtimeout.value == \"\" || !isInteger(editjob.feedtimeout.value))\n  {\n    alert(\"A timeout value, in seconds, is required\");\n    editjob.feedtimeout.focus();\n    return false;\n  }\n  if (editjob.feedrefetch.value == \"\" || !isInteger(editjob.feedrefetch.value))\n  {\n    alert(\"A refetch interval, in minutes, is required\");\n    editjob.feedrefetch.focus();\n    return false;\n  }\n  if (editjob.minfeedrefetch.value == \"\" || !isInteger(editjob.minfeedrefetch.value))\n  {\n    alert(\"A minimum refetch interval, in minutes, is required\");\n    editjob.minfeedrefetch.focus();\n    return false;\n  }\n  if (editjob.badfeedrefetch.value != \"\" && !isInteger(editjob.badfeedrefetch.value))\n  {\n    alert(\"A bad feed refetch interval, in minutes, is required\");\n    editjob.badfeedrefetch.focus();\n    return false;\n  }\n\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, DocumentSpecification ds, String tabName) throws ManifoldCFException, IOException {
        String metadataDescription;
        String accessDescription;
        int k;
        SpecificationNode sn;
        String allowBVSessionRemoval;
        String allowPHPSessionRemoval;
        String allowASPSessionRemoval;
        String allowJavaSessionRemoval;
        String allowReorder;
        String description;
        String regexpString;
        SpecificationNode specNode;
        int l;
        int q;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> regexp = new ArrayList<String>();
        ArrayList<String> matchStrings = new ArrayList<String>();
        int feedTimeoutValue = 60;
        int feedRefetchValue = 60;
        int minFeedRefetchValue = 15;
        Integer badFeedRefetchValue = null;
        int i = 0;
        while (i < ds.getChildCount()) {
            String value;
            SpecificationNode sn2;
            if ((sn2 = ds.getChild(i++)).getType().equals("feed")) {
                String rssURL = sn2.getAttributeValue("url");
                if (rssURL == null) continue;
                sb.append(rssURL).append("\n");
                continue;
            }
            if (sn2.getType().equals("map")) {
                String match = sn2.getAttributeValue("match");
                String map = sn2.getAttributeValue("map");
                if (match == null) continue;
                regexp.add(match);
                if (map == null) {
                    map = "";
                }
                matchStrings.add(map);
                continue;
            }
            if (sn2.getType().equals("feedtimeout")) {
                value = sn2.getAttributeValue("value");
                feedTimeoutValue = Integer.parseInt(value);
                continue;
            }
            if (sn2.getType().equals("feedrescan")) {
                value = sn2.getAttributeValue("value");
                feedRefetchValue = Integer.parseInt(value);
                continue;
            }
            if (sn2.getType().equals("minfeedrescan")) {
                value = sn2.getAttributeValue("value");
                minFeedRefetchValue = Integer.parseInt(value);
                continue;
            }
            if (!sn2.getType().equals("badfeedrescan")) continue;
            value = sn2.getAttributeValue("value");
            badFeedRefetchValue = new Integer(value);
        }
        if (tabName.equals("URLs")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"value\" colspan=\"2\">\n      <textarea rows=\"25\" cols=\"80\" name=\"rssurls\">" + Encoder.bodyEscape((String)sb.toString()) + "</textarea>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"rssurls\" value=\"" + Encoder.attributeEscape((String)sb.toString()) + "\"/>\n");
        }
        if (tabName.equals("Canonicalization")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"boxcell\" colspan=\"2\">\n      <input type=\"hidden\" name=\"urlregexpop\" value=\"Continue\"/>\n      <input type=\"hidden\" name=\"urlregexpnumber\" value=\"\"/>\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>URL regular expression</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Description</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Reorder?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove JSP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove ASP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove PHP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove BV sessions?</nobr></td>\n        </tr>\n");
            q = 0;
            l = 0;
            while (q < ds.getChildCount()) {
                if (!(specNode = ds.getChild(q++)).getType().equals("urlspec")) continue;
                regexpString = specNode.getAttributeValue("regexp");
                description = specNode.getAttributeValue("description");
                if (description == null) {
                    description = "";
                }
                if ((allowReorder = specNode.getAttributeValue("reorder")) == null || allowReorder.length() == 0) {
                    allowReorder = "no";
                }
                if ((allowJavaSessionRemoval = specNode.getAttributeValue("javasessionremoval")) == null || allowJavaSessionRemoval.length() == 0) {
                    allowJavaSessionRemoval = "no";
                }
                if ((allowASPSessionRemoval = specNode.getAttributeValue("aspsessionremoval")) == null || allowASPSessionRemoval.length() == 0) {
                    allowASPSessionRemoval = "no";
                }
                if ((allowPHPSessionRemoval = specNode.getAttributeValue("phpsessionremoval")) == null || allowPHPSessionRemoval.length() == 0) {
                    allowPHPSessionRemoval = "no";
                }
                if ((allowBVSessionRemoval = specNode.getAttributeValue("bvsessionremoval")) == null || allowBVSessionRemoval.length() == 0) {
                    allowBVSessionRemoval = "no";
                }
                out.print("        <tr class=\"" + (l % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <a name=\"" + "urlregexp_" + Integer.toString(l) + "\">\n" + "              <input type=\"button\" value=\"Delete\" alt=\"" + "Delete url regexp " + Encoder.attributeEscape((String)regexpString) + "\" onclick='javascript:URLRegexpDelete(" + Integer.toString(l) + ",\"urlregexp_" + Integer.toString(l) + "\");'/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <input type=\"hidden\" name=\"" + "urlregexp_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)regexpString) + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpdesc_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)description) + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpreorder_" + Integer.toString(l) + "\" value=\"" + allowReorder + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpjava_" + Integer.toString(l) + "\" value=\"" + allowJavaSessionRemoval + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpasp_" + Integer.toString(l) + "\" value=\"" + allowASPSessionRemoval + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpphp_" + Integer.toString(l) + "\" value=\"" + allowPHPSessionRemoval + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpbv_" + Integer.toString(l) + "\" value=\"" + allowBVSessionRemoval + "\"/>\n" + "            <nobr>" + Encoder.bodyEscape((String)regexpString) + "</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">" + Encoder.bodyEscape((String)description) + "</td>\n" + "          <td class=\"formcolumncell\">" + allowReorder + "</td>\n" + "          <td class=\"formcolumncell\">" + allowJavaSessionRemoval + "</td>\n" + "          <td class=\"formcolumncell\">" + allowASPSessionRemoval + "</td>\n" + "          <td class=\"formcolumncell\">" + allowPHPSessionRemoval + "</td>\n" + "          <td class=\"formcolumncell\">" + allowBVSessionRemoval + "</td>\n" + "        </tr>\n");
                ++l;
            }
            if (l == 0) {
                out.print("        <tr class=\"formrow\"><td colspan=\"8\" class=\"formcolumnmessage\"><nobr>No canonicalization specified - all URLs will be reordered and have all sessions removed</nobr></td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td colspan=\"8\" class=\"formseparator\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"urlregexp_" + Integer.toString(l) + "\">\n" + "              <input type=\"button\" value=\"Add\" alt=\"Add url regexp\" onclick='javascript:URLRegexpAdd(\"urlregexp_" + Integer.toString(l + 1) + "\");'/>\n" + "              <input type=\"hidden\" name=\"urlregexpcount\" value=\"" + Integer.toString(l) + "\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\"><input type=\"text\" name=\"urlregexp\" size=\"30\" value=\"\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"text\" name=\"urlregexpdesc\" size=\"30\" value=\"\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"urlregexpreorder\" value=\"yes\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"urlregexpjava\" value=\"yes\" checked=\"true\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"urlregexpasp\" value=\"yes\" checked=\"true\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"urlregexpphp\" value=\"yes\" checked=\"true\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"urlregexpbv\" value=\"yes\" checked=\"true\"/></td>\n" + "        </tr>\n" + "      </table>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            q = 0;
            l = 0;
            while (q < ds.getChildCount()) {
                if (!(specNode = ds.getChild(q++)).getType().equals("urlspec")) continue;
                regexpString = specNode.getAttributeValue("regexp");
                description = specNode.getAttributeValue("description");
                if (description == null) {
                    description = "";
                }
                if ((allowReorder = specNode.getAttributeValue("reorder")) == null || allowReorder.length() == 0) {
                    allowReorder = "no";
                }
                if ((allowJavaSessionRemoval = specNode.getAttributeValue("javasessionremoval")) == null || allowJavaSessionRemoval.length() == 0) {
                    allowJavaSessionRemoval = "no";
                }
                if ((allowASPSessionRemoval = specNode.getAttributeValue("aspsessionremoval")) == null || allowASPSessionRemoval.length() == 0) {
                    allowASPSessionRemoval = "no";
                }
                if ((allowPHPSessionRemoval = specNode.getAttributeValue("phpsessionremoval")) == null || allowPHPSessionRemoval.length() == 0) {
                    allowPHPSessionRemoval = "no";
                }
                if ((allowBVSessionRemoval = specNode.getAttributeValue("bvsessionremoval")) == null || allowBVSessionRemoval.length() == 0) {
                    allowBVSessionRemoval = "no";
                }
                out.print("<input type=\"hidden\" name=\"urlregexp_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)regexpString) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpdesc_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)description) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpreorder_" + Integer.toString(l) + "\" value=\"" + allowReorder + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpjava_" + Integer.toString(l) + "\" value=\"" + allowJavaSessionRemoval + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpasp_" + Integer.toString(l) + "\" value=\"" + allowASPSessionRemoval + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpphp_" + Integer.toString(l) + "\" value=\"" + allowPHPSessionRemoval + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpbv_" + Integer.toString(l) + "\" value=\"" + allowBVSessionRemoval + "\"/>\n");
                ++l;
            }
            out.print("<input type=\"hidden\" name=\"urlregexpcount\" value=\"" + Integer.toString(l) + "\"/>\n");
        }
        if (tabName.equals("Mappings")) {
            out.print("<input type=\"hidden\" name=\"rssop\" value=\"\"/>\n<input type=\"hidden\" name=\"rssindex\" value=\"\"/>\n<input type=\"hidden\" name=\"rssmapcount\" value=\"" + Integer.toString(regexp.size()) + "\"/>\n" + "\n" + "<table class=\"displaytable\">\n" + "  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
            for (i = 0; i < regexp.size(); ++i) {
                String prefix = "rssregexp_" + Integer.toString(i) + "_";
                out.print("  <tr>\n    <td class=\"value\">\n      <a name=\"regexp_" + Integer.toString(i) + "\">\n" + "        <input type=\"button\" value=\"Remove\" onclick='javascript:RemoveRegexp(" + Integer.toString(i) + ",\"regexp_" + Integer.toString(i) + "\")' alt=\"" + "Remove regexp #" + Integer.toString(i) + "\"/>\n" + "      </a>\n" + "    </td>\n" + "    <td class=\"value\"><input type=\"hidden\" name=\"" + prefix + "match" + "\" value=\"" + Encoder.attributeEscape((String)((String)regexp.get(i))) + "\"/>" + Encoder.bodyEscape((String)((String)regexp.get(i))) + "</td>\n" + "    <td class=\"value\">==></td>\n" + "    <td class=\"value\">\n");
                String match = (String)matchStrings.get(i);
                out.print("      <input type=\"hidden\" name=\"" + prefix + "map" + "\" value=\"" + Encoder.attributeEscape((String)match) + "\"/>\n");
                if (match.length() == 0) {
                    out.print("      &lt;as is&gt;\n");
                } else {
                    out.print("      " + Encoder.bodyEscape((String)match) + "\n");
                }
                out.print("    </td>\n  </tr>\n");
            }
            out.print("  <tr>\n    <td class=\"value\"><a name=\"regexp_" + Integer.toString(i) + "\"><input type=\"button\" value=\"Add\" onclick='javascript:AddRegexp(\"regexp_" + Integer.toString(i + 1) + "\")' alt=\"Add regexp\"/></a></td>\n" + "    <td class=\"value\"><input type=\"text\" name=\"rssmatch\" size=\"16\" value=\"\"/></td>\n" + "    <td class=\"value\">==></td>\n" + "    <td class=\"value\"><input type=\"text\" name=\"rssmap\" size=\"16\" value=\"\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"rssmapcount\" value=\"" + Integer.toString(regexp.size()) + "\"/>\n");
            for (i = 0; i < regexp.size(); ++i) {
                String prefix = "rssregexp_" + Integer.toString(i) + "_";
                String match = (String)matchStrings.get(i);
                out.print("<input type=\"hidden\" name=\"" + prefix + "match" + "\" value=\"" + Encoder.attributeEscape((String)((String)regexp.get(i))) + "\"/>\n" + "<input type=\"hidden\" name=\"" + prefix + "map" + "\" value=\"" + Encoder.attributeEscape((String)match) + "\"/>\n");
            }
        }
        if (tabName.equals("Time Values")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Feed connect timeout (seconds):</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"feedtimeout\" value=\"" + Encoder.attributeEscape((String)Integer.toString(feedTimeoutValue)) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Default feed refetch time (minutes)</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"feedrefetch\" value=\"" + Encoder.attributeEscape((String)Integer.toString(feedRefetchValue)) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Minimum feed refetch time (minutes)</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"minfeedrefetch\" value=\"" + Encoder.attributeEscape((String)Integer.toString(minFeedRefetchValue)) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Bad feed refetch time (minutes)</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input type=\"hidden\" name=\"badfeedrefetch_present\" value=\"true\"/>\n" + "      <input type=\"text\" size=\"5\" name=\"badfeedrefetch\" value=\"" + (badFeedRefetchValue == null ? "" : Encoder.attributeEscape((String)badFeedRefetchValue.toString())) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"feedtimeout\" value=\"" + Encoder.attributeEscape((String)Integer.toString(feedTimeoutValue)) + "\"/>\n" + "<input type=\"hidden\" name=\"feedrefetch\" value=\"" + Encoder.attributeEscape((String)Integer.toString(feedRefetchValue)) + "\"/>\n" + "<input type=\"hidden\" name=\"minfeedrefetch\" value=\"" + Encoder.attributeEscape((String)Integer.toString(minFeedRefetchValue)) + "\"/>\n" + "<input type=\"hidden\" name=\"badfeedrefetch_present\" value=\"true\"/>\n" + "<input type=\"hidden\" name=\"badfeedrefetch\" value=\"" + (badFeedRefetchValue == null ? "" : Encoder.attributeEscape((String)badFeedRefetchValue.toString())) + "\"/>\n");
        }
        String dechromedMode = "none";
        String chromedMode = "use";
        i = 0;
        while (i < ds.getChildCount()) {
            if ((sn = ds.getChild(i++)).getType().equals("dechromedmode")) {
                dechromedMode = sn.getAttributeValue("mode");
                continue;
            }
            if (!sn.getType().equals("chromedmode")) continue;
            chromedMode = sn.getAttributeValue("mode");
        }
        if (tabName.equals("Dechromed Content")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"1\"><hr/></td></tr>\n  <tr>\n    <td class=\"value\"><nobr><input type=\"radio\" name=\"dechromedmode\" value=\"none\" " + (dechromedMode.equals("none") ? "checked=\"true\"" : "") + "/>&nbsp;No dechromed content</nobr></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"value\"><nobr><input type=\"radio\" name=\"dechromedmode\" value=\"description\" " + (dechromedMode.equals("description") ? "checked=\"true\"" : "") + "/>&nbsp;Dechromed content, if present, in 'description' field</nobr></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"value\"><nobr><input type=\"radio\" name=\"dechromedmode\" value=\"content\" " + (dechromedMode.equals("content") ? "checked=\"true\"" : "") + "/>&nbsp;Dechromed content, if present, in 'content' field</nobr></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"separator\"><hr/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"value\"><nobr><input type=\"radio\" name=\"chromedmode\" value=\"none\" " + (chromedMode.equals("use") ? "checked=\"true\"" : "") + "/>&nbsp;Use chromed content if no dechromed content found</nobr></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"value\"><nobr><input type=\"radio\" name=\"chromedmode\" value=\"skip\" " + (chromedMode.equals("skip") ? "checked=\"true\"" : "") + "/>&nbsp;Never use chromed content</nobr></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"dechromedmode\" value=\"" + Encoder.attributeEscape((String)dechromedMode) + "\"/>\n" + "<input type=\"hidden\" name=\"chromedmode\" value=\"" + Encoder.attributeEscape((String)chromedMode) + "\"/>\n");
        }
        i = 0;
        if (tabName.equals("Security")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                accessDescription = "_" + Integer.toString(k);
                String accessOpName = "accessop" + accessDescription;
                String token = sn.getAttributeValue("token");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n" + "      <input type=\"hidden\" name=\"" + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n" + "      <a name=\"" + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Delete\" onClick='Javascript:SpecOp(\"" + accessOpName + "\",\"Delete\",\"token_" + Integer.toString(k) + "\")' alt=\"" + "Delete token #" + Integer.toString(k) + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      " + Encoder.bodyEscape((String)token) + "\n" + "    </td>\n" + "  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">No access tokens present</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"tokencount\" value=\"" + Integer.toString(k) + "\"/>\n" + "      <input type=\"hidden\" name=\"accessop\" value=\"\"/>\n" + "      <a name=\"" + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Add\" onClick='Javascript:SpecAddToken(\"token_" + Integer.toString(k + 1) + "\")' alt=\"Add access token\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"30\" name=\"spectoken\" value=\"\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                accessDescription = "_" + Integer.toString(k);
                String token = sn.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
        if (tabName.equals("Metadata")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("metadata")) continue;
                metadataDescription = "_" + Integer.toString(k);
                String metadataOpName = "metadataop" + metadataDescription;
                String name = sn.getAttributeValue("name");
                String value = sn.getAttributeValue("value");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + metadataOpName + "\" value=\"\"/>\n" + "      <input type=\"hidden\" name=\"" + "specmetaname" + metadataDescription + "\" value=\"" + Encoder.attributeEscape((String)name) + "\"/>\n" + "      <input type=\"hidden\" name=\"" + "specmetavalue" + metadataDescription + "\" value=\"" + Encoder.attributeEscape((String)value) + "\"/>\n" + "      <a name=\"" + "metadata_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Delete\" onClick='Javascript:SpecOp(\"" + metadataOpName + "\",\"Delete\",\"metadata_" + Integer.toString(k) + "\")' alt=\"" + "Delete metadata #" + Integer.toString(k) + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      " + Encoder.bodyEscape((String)name) + "\n" + "    </td>\n" + "    <td class=\"value\">=</td>\n" + "    <td class=\"value\">\n" + "      " + Encoder.bodyEscape((String)value) + "\n" + "    </td>\n" + "  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"4\">No metadata present</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"metadatacount\" value=\"" + Integer.toString(k) + "\"/>\n" + "      <input type=\"hidden\" name=\"metadataop\" value=\"\"/>\n" + "      <a name=\"" + "metadata_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Add\" onClick='Javascript:SpecAddMetadata(\"metadata_" + Integer.toString(k + 1) + "\")' alt=\"Add metadata\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"30\" name=\"specmetaname\" value=\"\"/>\n" + "    </td>\n" + "    <td class=\"value\">=</td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"80\" name=\"specmetavalue\" value=\"\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("metadata")) continue;
                metadataDescription = "_" + Integer.toString(k);
                String name = sn.getAttributeValue("name");
                String value = sn.getAttributeValue("value");
                out.print("<input type=\"hidden\" name=\"specmetaname" + metadataDescription + "\" value=\"" + Encoder.attributeEscape((String)name) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "specmetavalue" + metadataDescription + "\" value=\"" + Encoder.attributeEscape((String)value) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"metadatacount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processSpecificationPost(IPostParameters variableContext, DocumentSpecification ds) throws ManifoldCFException {
        String op;
        SpecificationNode node;
        SpecificationNode sn;
        String rssop;
        String chromedMode;
        String dechromedMode;
        SpecificationNode node2;
        SpecificationNode sn2;
        String badFeedRefetchValuePresent;
        String minFeedRefetchValue;
        String feedRefetchValue;
        String feedTimeoutValue;
        SpecificationNode sn3;
        String urlRegexpCount;
        String rssURLSequence;
        SpecificationNode node3;
        SpecificationNode sn4;
        String value = variableContext.getParameter("rssmapcount");
        if (value != null) {
            int mapsize = Integer.parseInt(value);
            int j = 0;
            while (j < ds.getChildCount()) {
                sn4 = ds.getChild(j);
                if (sn4.getType().equals("map")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            for (j = 0; j < mapsize; ++j) {
                String prefix = "rssregexp_" + Integer.toString(j) + "_";
                String match = variableContext.getParameter(prefix + "match");
                String map = variableContext.getParameter(prefix + "map");
                if (map == null) {
                    map = "";
                }
                node3 = new SpecificationNode("map");
                node3.setAttribute("match", match);
                node3.setAttribute("map", map);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node3);
            }
        }
        if ((rssURLSequence = variableContext.getParameter("rssurls")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                sn4 = ds.getChild(i);
                if (sn4.getType().equals("feed")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            try {
                StringReader str = new StringReader(rssURLSequence);
                try {
                    BufferedReader is = new BufferedReader(str);
                    try {
                        String nextString;
                        while ((nextString = is.readLine()) != null) {
                            if (nextString.length() == 0) continue;
                            node3 = new SpecificationNode("feed");
                            node3.setAttribute("url", nextString);
                            ds.addChild(ds.getChildCount(), (ConfigurationNode)node3);
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                finally {
                    ((Reader)str).close();
                }
            }
            catch (IOException e) {
                throw new ManifoldCFException("IO error", (Throwable)e);
            }
        }
        if ((urlRegexpCount = variableContext.getParameter("urlregexpcount")) != null && urlRegexpCount.length() > 0) {
            SpecificationNode newSn;
            String bvSession;
            String phpSession;
            String aspSession;
            String javaSession;
            String reorder;
            String regexpDescription;
            String regexp;
            int regexpCount = Integer.parseInt(urlRegexpCount);
            int j = 0;
            while (j < ds.getChildCount()) {
                sn3 = ds.getChild(j);
                if (sn3.getType().equals("urlspec")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            String operation = variableContext.getParameter("urlregexpop");
            if (operation == null) {
                operation = "Continue";
            }
            int opIndex = -1;
            if (operation.equals("Delete")) {
                opIndex = Integer.parseInt(variableContext.getParameter("urlregexpnumber"));
            }
            for (j = 0; j < regexpCount; ++j) {
                if (operation.equals("Delete") && j == opIndex) continue;
                regexp = variableContext.getParameter("urlregexp_" + Integer.toString(j));
                regexpDescription = variableContext.getParameter("urlregexpdesc_" + Integer.toString(j));
                reorder = variableContext.getParameter("urlregexpreorder_" + Integer.toString(j));
                javaSession = variableContext.getParameter("urlregexpjava_" + Integer.toString(j));
                aspSession = variableContext.getParameter("urlregexpasp_" + Integer.toString(j));
                phpSession = variableContext.getParameter("urlregexpphp_" + Integer.toString(j));
                bvSession = variableContext.getParameter("urlregexpbv_" + Integer.toString(j));
                newSn = new SpecificationNode("urlspec");
                newSn.setAttribute("regexp", regexp);
                if (regexpDescription != null && regexpDescription.length() > 0) {
                    newSn.setAttribute("description", regexpDescription);
                }
                if (reorder != null && reorder.length() > 0) {
                    newSn.setAttribute("reorder", reorder);
                }
                if (javaSession != null && javaSession.length() > 0) {
                    newSn.setAttribute("javasessionremoval", javaSession);
                }
                if (aspSession != null && aspSession.length() > 0) {
                    newSn.setAttribute("aspsessionremoval", aspSession);
                }
                if (phpSession != null && phpSession.length() > 0) {
                    newSn.setAttribute("phpsessionremoval", phpSession);
                }
                if (bvSession != null && bvSession.length() > 0) {
                    newSn.setAttribute("bvsessionremoval", bvSession);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newSn);
            }
            if (operation.equals("Add")) {
                regexp = variableContext.getParameter("urlregexp");
                regexpDescription = variableContext.getParameter("urlregexpdesc");
                reorder = variableContext.getParameter("urlregexpreorder");
                javaSession = variableContext.getParameter("urlregexpjava");
                aspSession = variableContext.getParameter("urlregexpasp");
                phpSession = variableContext.getParameter("urlregexpphp");
                bvSession = variableContext.getParameter("urlregexpbv");
                newSn = new SpecificationNode("urlspec");
                newSn.setAttribute("regexp", regexp);
                if (regexpDescription != null && regexpDescription.length() > 0) {
                    newSn.setAttribute("description", regexpDescription);
                }
                if (reorder != null && reorder.length() > 0) {
                    newSn.setAttribute("reorder", reorder);
                }
                if (javaSession != null && javaSession.length() > 0) {
                    newSn.setAttribute("javasessionremoval", javaSession);
                }
                if (aspSession != null && aspSession.length() > 0) {
                    newSn.setAttribute("aspsessionremoval", aspSession);
                }
                if (phpSession != null && phpSession.length() > 0) {
                    newSn.setAttribute("phpsessionremoval", phpSession);
                }
                if (bvSession != null && bvSession.length() > 0) {
                    newSn.setAttribute("bvsessionremoval", bvSession);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newSn);
            }
        }
        if ((feedTimeoutValue = variableContext.getParameter("feedtimeout")) != null && feedTimeoutValue.length() > 0) {
            int j = 0;
            while (j < ds.getChildCount()) {
                sn3 = ds.getChild(j);
                if (sn3.getType().equals("feedtimeout")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            SpecificationNode node4 = new SpecificationNode("feedtimeout");
            node4.setAttribute("value", feedTimeoutValue);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node4);
        }
        if ((feedRefetchValue = variableContext.getParameter("feedrefetch")) != null && feedRefetchValue.length() > 0) {
            int j = 0;
            while (j < ds.getChildCount()) {
                SpecificationNode sn5 = ds.getChild(j);
                if (sn5.getType().equals("feedrescan")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            SpecificationNode node5 = new SpecificationNode("feedrescan");
            node5.setAttribute("value", feedRefetchValue);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node5);
        }
        if ((minFeedRefetchValue = variableContext.getParameter("minfeedrefetch")) != null && minFeedRefetchValue.length() > 0) {
            int j = 0;
            while (j < ds.getChildCount()) {
                SpecificationNode sn6 = ds.getChild(j);
                if (sn6.getType().equals("minfeedrescan")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            SpecificationNode node6 = new SpecificationNode("minfeedrescan");
            node6.setAttribute("value", minFeedRefetchValue);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node6);
        }
        if ((badFeedRefetchValuePresent = variableContext.getParameter("badfeedrefetch_present")) != null && badFeedRefetchValuePresent.length() > 0) {
            String badFeedRefetchValue = variableContext.getParameter("badfeedrefetch");
            int k = 0;
            while (k < ds.getChildCount()) {
                sn2 = ds.getChild(k);
                if (sn2.getType().equals("badfeedrescan")) {
                    ds.removeChild(k);
                    continue;
                }
                ++k;
            }
            if (badFeedRefetchValue != null && badFeedRefetchValue.length() > 0) {
                node2 = new SpecificationNode("badfeedrescan");
                node2.setAttribute("value", badFeedRefetchValue);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
            }
        }
        if ((dechromedMode = variableContext.getParameter("dechromedmode")) != null && dechromedMode.length() > 0) {
            int j = 0;
            while (j < ds.getChildCount()) {
                sn2 = ds.getChild(j);
                if (sn2.getType().equals("dechromedmode")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            node2 = new SpecificationNode("dechromedmode");
            node2.setAttribute("mode", dechromedMode);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
        }
        if ((chromedMode = variableContext.getParameter("chromedmode")) != null && chromedMode.length() > 0) {
            int j = 0;
            while (j < ds.getChildCount()) {
                SpecificationNode sn7 = ds.getChild(j);
                if (sn7.getType().equals("chromedmode")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            SpecificationNode node7 = new SpecificationNode("chromedmode");
            node7.setAttribute("mode", chromedMode);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node7);
        }
        if ((rssop = variableContext.getParameter("rssop")) != null && rssop.equals("Add")) {
            String match = variableContext.getParameter("rssmatch");
            String map = variableContext.getParameter("rssmap");
            SpecificationNode node8 = new SpecificationNode("map");
            node8.setAttribute("match", match);
            node8.setAttribute("map", map);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node8);
        } else if (rssop != null && rssop.equals("Delete")) {
            int index = Integer.parseInt(variableContext.getParameter("rssindex"));
            for (int j = 0; j < ds.getChildCount(); ++j) {
                sn = ds.getChild(j);
                if (!sn.getType().equals("map")) continue;
                if (index == 0) {
                    ds.removeChild(j);
                    break;
                }
                --index;
            }
        }
        String xc = variableContext.getParameter("tokencount");
        if (xc != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter("spectoken" + accessDescription);
                node = new SpecificationNode("access");
                node.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter("accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter("spectoken");
                SpecificationNode node9 = new SpecificationNode("access");
                node9.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node9);
            }
        }
        if ((xc = variableContext.getParameter("metadatacount")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn8 = ds.getChild(i);
                if (sn8.getType().equals("metadata")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int metadataCount = Integer.parseInt(xc);
            i = 0;
            while (i < metadataCount) {
                String metadataDescription = "_" + Integer.toString(i);
                String metadataOpName = "metadataop" + metadataDescription;
                xc = variableContext.getParameter(metadataOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String metaNameSpec = variableContext.getParameter("specmetaname" + metadataDescription);
                String metaValueSpec = variableContext.getParameter("specmetavalue" + metadataDescription);
                SpecificationNode node10 = new SpecificationNode("metadata");
                node10.setAttribute("name", metaNameSpec);
                node10.setAttribute("value", metaValueSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node10);
                ++i;
            }
            op = variableContext.getParameter("metadataop");
            if (op != null && op.equals("Add")) {
                String metaNameSpec = variableContext.getParameter("specmetaname");
                String metaValueSpec = variableContext.getParameter("specmetavalue");
                node = new SpecificationNode("metadata");
                node.setAttribute("name", metaNameSpec);
                node.setAttribute("value", metaValueSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, DocumentSpecification ds) throws ManifoldCFException, IOException {
        SpecificationNode sn;
        SpecificationNode sn2;
        out.print("<table class=\"displaytable\">\n");
        int i = 0;
        boolean seenAny = false;
        while (i < ds.getChildCount()) {
            SpecificationNode sn3;
            if (!(sn3 = ds.getChild(i++)).getType().equals("feed")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>RSS urls:</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)sn3.getAttributeValue("url")) + "</nobr><br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>No RSS urls specified</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        i = 0;
        int l = 0;
        seenAny = false;
        while (i < ds.getChildCount()) {
            String allowBVSessionRemoval;
            String allowPHPSessionRemoval;
            String allowASPSessionRemoval;
            String allowJavaSessionRemoval;
            String allowReorder;
            if (!(sn2 = ds.getChild(i++)).getType().equals("urlspec")) continue;
            if (l == 0) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>URL canonicalization:</nobr></td>\n    <td class=\"value\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>URL regexp</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Description</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Reorder?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove JSP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove ASP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove PHP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove BV sessions?</nobr></td>\n        </tr>\n");
            }
            String regexpString = sn2.getAttributeValue("regexp");
            String description = sn2.getAttributeValue("description");
            if (description == null) {
                description = "";
            }
            if ((allowReorder = sn2.getAttributeValue("reorder")) == null || allowReorder.length() == 0) {
                allowReorder = "no";
            }
            if ((allowJavaSessionRemoval = sn2.getAttributeValue("javasessionremoval")) == null || allowJavaSessionRemoval.length() == 0) {
                allowJavaSessionRemoval = "no";
            }
            if ((allowASPSessionRemoval = sn2.getAttributeValue("aspsessionremoval")) == null || allowASPSessionRemoval.length() == 0) {
                allowASPSessionRemoval = "no";
            }
            if ((allowPHPSessionRemoval = sn2.getAttributeValue("phpsessionremoval")) == null || allowPHPSessionRemoval.length() == 0) {
                allowPHPSessionRemoval = "no";
            }
            if ((allowBVSessionRemoval = sn2.getAttributeValue("bvsessionremoval")) == null || allowBVSessionRemoval.length() == 0) {
                allowBVSessionRemoval = "no";
            }
            out.print("        <tr class=\"" + (l % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)regexpString) + "</nobr></td>\n" + "          <td class=\"formcolumncell\">" + Encoder.bodyEscape((String)description) + "</td>\n" + "          <td class=\"formcolumncell\"><nobr>" + allowReorder + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + allowJavaSessionRemoval + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + allowASPSessionRemoval + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + allowPHPSessionRemoval + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + allowBVSessionRemoval + "</nobr></td>\n" + "        </tr>\n");
            ++l;
        }
        if (l > 0) {
            out.print("      </table>\n    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>No url canonicalization specified; will reorder all urls and remove all sessions</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        i = 0;
        seenAny = false;
        while (i < ds.getChildCount()) {
            if (!(sn2 = ds.getChild(i++)).getType().equals("map")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>URL mappings:</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String match = sn2.getAttributeValue("match");
            String map = sn2.getAttributeValue("map");
            out.print("      <nobr>" + Encoder.bodyEscape((String)match) + "</nobr>\n");
            if (map != null && map.length() > 0) {
                out.print("      &nbsp;--&gt;&nbsp;<nobr>" + Encoder.bodyEscape((String)map) + "</nobr>\n");
            }
            out.print("      <br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>No mappings specified; will accept all urls</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        String feedTimeoutValue = "60";
        String feedRefetchValue = "60";
        String minFeedRefetchValue = "15";
        String badFeedRefetchValue = null;
        String dechromedMode = "none";
        String chromedMode = "use";
        i = 0;
        while (i < ds.getChildCount()) {
            if ((sn = ds.getChild(i++)).getType().equals("feedtimeout")) {
                feedTimeoutValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("feedrescan")) {
                feedRefetchValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("minfeedrescan")) {
                minFeedRefetchValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("badfeedrescan")) {
                badFeedRefetchValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("dechromedmode")) {
                dechromedMode = sn.getAttributeValue("mode");
                continue;
            }
            if (!sn.getType().equals("chromedmode")) continue;
            chromedMode = sn.getAttributeValue("mode");
        }
        out.print("  <tr>\n    <td class=\"description\"><nobr>Feed connection timeout (seconds):</nobr></td>\n    <td class=\"value\">" + Encoder.bodyEscape((String)feedTimeoutValue) + "</td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Default feed rescan interval (minutes):</nobr></td>\n" + "    <td class=\"value\">" + Encoder.bodyEscape((String)feedRefetchValue) + "</td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Minimum feed rescan interval (minutes):</nobr></td>\n" + "    <td class=\"value\">" + Encoder.bodyEscape((String)minFeedRefetchValue) + "</td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Bad feed rescan interval (minutes):</nobr></td>\n" + "    <td class=\"value\">" + (badFeedRefetchValue == null ? "(Default feed rescan value)" : Encoder.bodyEscape((String)badFeedRefetchValue)) + "</td>\n" + "  </tr>\n" + "      \n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n" + "\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Dechromed content source:</nobr></td>\n" + "    <td class=\"value\">" + Encoder.bodyEscape((String)dechromedMode) + "</td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Chromed content:</nobr></td>\n" + "    <td class=\"value\">" + Encoder.bodyEscape((String)chromedMode) + "</td>\n" + "  </tr>\n" + "\n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        seenAny = false;
        i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr><td class=\"description\"><nobr>Access tokens:</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue("token");
            out.print("      " + Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>No access tokens specified</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        seenAny = false;
        i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals("metadata")) continue;
            if (!seenAny) {
                out.print("  <tr><td class=\"description\"><nobr>Metadata:</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String name = sn.getAttributeValue("name");
            String value = sn.getAttributeValue("value");
            out.print("      " + Encoder.bodyEscape((String)name) + "&nbsp;=&nbsp;" + Encoder.bodyEscape((String)value) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>No metadata specified</nobr></td></tr>\n");
        }
        out.print("</table>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRSSFeedSAX(String documentIdentifier, IProcessActivity activities, Filter filter) throws ManifoldCFException, ServiceInterruption {
        block18: {
            try {
                InputStream is = cache.getData(documentIdentifier);
                if (is == null) {
                    Logging.connectors.error((Object)("RSS: Document '" + documentIdentifier + "' should be in cache but isn't"));
                    return;
                }
                XMLStream x = new XMLStream();
                OuterContextClass c = new OuterContextClass(x, documentIdentifier, activities, filter);
                x.setContext((XMLContext)c);
                try {
                    x.parse(is);
                }
                catch (ManifoldCFException e) {
                    if (e.getMessage().indexOf("pars") >= 0) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("RSS: XML document '" + documentIdentifier + "' was unparseable (" + e.getMessage() + "), skipping"));
                        }
                        c.setDefaultRescanTimeIfNeeded();
                        x.cleanup();
                        is.close();
                        return;
                    }
                    throw e;
                }
                c.checkIfValidFeed();
                c.setDefaultRescanTimeIfNeeded();
                break block18;
                {
                    finally {
                        x.cleanup();
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (SocketTimeoutException e) {
                throw new ManifoldCFException("Socket timeout error: " + e.getMessage(), (Throwable)e);
            }
            catch (ConnectTimeoutException e) {
                throw new ManifoldCFException("Socket connect timeout error: " + e.getMessage(), (Throwable)e);
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (IOException e) {
                throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static Long parseZuluDate(String dateValue) {
        String day;
        int index = (dateValue = dateValue.trim()).indexOf("-");
        if (index == -1) {
            return null;
        }
        String year = dateValue.substring(0, index);
        if ((index = (dateValue = dateValue.substring(index + 1)).indexOf("-")) == -1) {
            return null;
        }
        String month = dateValue.substring(0, index);
        dateValue = dateValue.substring(index + 1);
        index = dateValue.indexOf("T");
        String hour = "0";
        String minute = "0";
        String second = "0";
        String timezone = "GMT";
        if (index != -1) {
            day = dateValue.substring(0, index);
            if ((index = (dateValue = dateValue.substring(index + 1)).indexOf(":")) == -1) {
                return null;
            }
            hour = dateValue.substring(0, index);
            if ((index = (dateValue = dateValue.substring(index + 1)).indexOf(":")) != -1) {
                minute = dateValue.substring(0, index);
                if ((dateValue = dateValue.substring(index + 1)).endsWith("Z")) {
                    index = dateValue.indexOf("Z");
                    if (index == -1) {
                        return null;
                    }
                } else {
                    index = dateValue.indexOf("+");
                    if (index == -1) {
                        index = dateValue.indexOf("-");
                    }
                    if (index == -1) {
                        return null;
                    }
                    timezone = "GMT" + dateValue.substring(index);
                }
                second = dateValue.substring(0, index);
            } else {
                minute = dateValue;
            }
        } else {
            day = dateValue;
        }
        TimeZone tz = TimeZone.getTimeZone(timezone);
        GregorianCalendar c = new GregorianCalendar(tz);
        try {
            int value = Integer.parseInt(year);
            c.set(1, value);
            value = Integer.parseInt(month);
            c.set(2, value - 1);
            value = Integer.parseInt(day);
            c.set(5, value);
            value = Integer.parseInt(hour);
            c.set(11, value);
            value = Integer.parseInt(minute);
            c.set(12, value);
            int index2 = second.indexOf(".");
            if (index2 != -1) {
                second = second.substring(0, index2);
            }
            value = Integer.parseInt(second);
            c.set(13, value);
            c.set(14, 0);
            return new Long(c.getTimeInMillis());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected static Long parseChinaDate(String dateValue) {
        String day;
        int index = (dateValue = dateValue.trim()).indexOf("/");
        if (index == -1) {
            return null;
        }
        String year = dateValue.substring(0, index);
        if ((index = (dateValue = dateValue.substring(index + 1)).indexOf("/")) == -1) {
            return null;
        }
        String month = dateValue.substring(0, index);
        dateValue = dateValue.substring(index + 1);
        index = dateValue.indexOf(" ");
        String hour = null;
        String minute = null;
        String second = null;
        if (index == -1) {
            day = dateValue;
        } else {
            day = dateValue.substring(0, index);
            if ((index = (dateValue = dateValue.substring(index + 1)).indexOf(":")) == -1) {
                return null;
            }
            hour = dateValue.substring(0, index);
            if ((index = (dateValue = dateValue.substring(index + 1)).indexOf(":")) != -1) {
                minute = dateValue.substring(0, index);
                second = dateValue = dateValue.substring(index + 1);
            } else {
                minute = dateValue;
            }
        }
        TimeZone tz = TimeZone.getTimeZone("GMT");
        GregorianCalendar c = new GregorianCalendar(tz);
        try {
            int value = Integer.parseInt(year);
            if (value < 1900) {
                value += 1900;
            }
            c.set(1, value);
            value = Integer.parseInt(month);
            c.set(2, value - 1);
            value = Integer.parseInt(day);
            c.set(5, value);
            value = hour != null ? Integer.parseInt(hour) : 0;
            c.set(11, value);
            value = minute != null ? Integer.parseInt(minute) : 0;
            c.set(12, value);
            value = second != null ? Integer.parseInt(second) : 0;
            c.set(13, value);
            c.set(14, 0);
            return new Long(c.getTimeInMillis());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected static Long parseRSSDate(String dateValue) {
        String year;
        int commaIndex = (dateValue = dateValue.trim()).indexOf(",");
        String usable = commaIndex == -1 ? dateValue : dateValue.substring(commaIndex + 1).trim();
        int index = usable.indexOf(" ");
        if (index == -1) {
            return null;
        }
        String day = usable.substring(0, index);
        if ((index = (usable = usable.substring(index + 1).trim()).indexOf(" ")) == -1) {
            return null;
        }
        String month = usable.substring(0, index).toLowerCase();
        usable = usable.substring(index + 1).trim();
        String hour = null;
        String minute = null;
        String second = null;
        String timezone = null;
        index = usable.indexOf(" ");
        if (index != -1) {
            year = usable.substring(0, index);
            if ((index = (usable = usable.substring(index + 1).trim()).indexOf(":")) == -1) {
                return null;
            }
            hour = usable.substring(0, index);
            if ((index = (usable = usable.substring(index + 1).trim()).indexOf(":")) != -1) {
                minute = usable.substring(0, index);
                if ((index = (usable = usable.substring(index + 1).trim()).indexOf(" ")) == -1) {
                    second = usable;
                } else {
                    second = usable.substring(0, index);
                    timezone = usable.substring(index + 1).trim();
                }
            } else {
                index = usable.indexOf(" ");
                if (index == -1) {
                    minute = usable;
                } else {
                    minute = usable.substring(0, index);
                    timezone = usable.substring(index + 1).trim();
                }
            }
        } else {
            year = usable;
        }
        if (timezone != null && timezone.length() > 0) {
            if (timezone.startsWith("+") || timezone.startsWith("-")) {
                if (timezone.indexOf(":") == -1 && timezone.length() > 3) {
                    timezone = timezone.substring(0, timezone.length() - 2) + ":" + timezone.substring(timezone.length() - 2);
                }
                timezone = "GMT" + timezone;
            } else if (milTzMap.get(timezone) != null) {
                timezone = (String)milTzMap.get(timezone);
            }
        } else {
            timezone = "GMT";
        }
        TimeZone tz = TimeZone.getTimeZone(timezone);
        GregorianCalendar c = new GregorianCalendar(tz);
        try {
            int value = Integer.parseInt(year);
            if (value < 1900) {
                value += 1900;
            }
            c.set(1, value);
            Integer x = (Integer)monthMap.get(month);
            if (x == null) {
                return null;
            }
            c.set(2, x - 1);
            value = Integer.parseInt(day);
            c.set(5, value);
            value = hour != null ? Integer.parseInt(hour) : 0;
            c.set(11, value);
            value = minute != null ? Integer.parseInt(minute) : 0;
            c.set(12, value);
            value = second != null ? Integer.parseInt(second) : 0;
            c.set(13, value);
            c.set(14, 0);
            return new Long(c.getTimeInMillis());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    protected boolean isContentInteresting(IFingerprintActivity activities, String contentType) throws ServiceInterruption, ManifoldCFException {
        if (contentType == null) {
            return false;
        }
        int pos = contentType.indexOf(";");
        if (pos != -1) {
            contentType = contentType.substring(0, pos);
        }
        contentType = contentType.trim();
        return activities.checkMimeTypeIndexable(contentType);
    }

    protected static void pack(StringBuffer output, String value, char delimiter) {
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '\\' || x == delimiter) {
                output.append('\\');
            }
            output.append(x);
        }
        output.append(delimiter);
    }

    protected static int unpack(StringBuffer sb, String value, int startPosition, char delimiter) {
        while (startPosition < value.length()) {
            char x;
            if ((x = value.charAt(startPosition++)) == '\\') {
                if (startPosition < value.length()) {
                    x = value.charAt(startPosition++);
                }
            } else if (x == delimiter) break;
            sb.append(x);
        }
        return startPosition;
    }

    protected static void packFixedList(StringBuffer output, String[] values, char delimiter) {
        int i = 0;
        while (i < values.length) {
            RSSConnector.pack(output, values[i++], delimiter);
        }
    }

    protected static int unpackFixedList(String[] output, String value, int startPosition, char delimiter) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < output.length) {
            sb.setLength(0);
            startPosition = RSSConnector.unpack(sb, value, startPosition, delimiter);
            output[i++] = sb.toString();
        }
        return startPosition;
    }

    protected static void packList(StringBuffer output, ArrayList values, char delimiter) {
        RSSConnector.pack(output, Integer.toString(values.size()), delimiter);
        int i = 0;
        while (i < values.size()) {
            RSSConnector.pack(output, values.get(i++).toString(), delimiter);
        }
    }

    protected static void packList(StringBuffer output, String[] values, char delimiter) {
        RSSConnector.pack(output, Integer.toString(values.length), delimiter);
        int i = 0;
        while (i < values.length) {
            RSSConnector.pack(output, values[i++], delimiter);
        }
    }

    protected static int unpackList(ArrayList output, String value, int startPosition, char delimiter) {
        StringBuffer sb = new StringBuffer();
        startPosition = RSSConnector.unpack(sb, value, startPosition, delimiter);
        try {
            int count = Integer.parseInt(sb.toString());
            for (int i = 0; i < count; ++i) {
                sb.setLength(0);
                startPosition = RSSConnector.unpack(sb, value, startPosition, delimiter);
                output.add(sb.toString());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return startPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThrottledFetcher getFetcher() {
        Map map = fetcherMap;
        synchronized (map) {
            ThrottledFetcher tf = (ThrottledFetcher)fetcherMap.get(this.throttleGroupName);
            if (tf == null) {
                tf = new ThrottledFetcher();
                fetcherMap.put(this.throttleGroupName, tf);
            }
            return tf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Robots getRobots(ThrottledFetcher fetcher) {
        Map map = robotsMap;
        synchronized (map) {
            Robots r = (Robots)robotsMap.get(this.throttleGroupName);
            if (r == null) {
                r = new Robots(fetcher);
                robotsMap.put(this.throttleGroupName, r);
            }
            return r;
        }
    }

    static {
        understoodProtocols.put("http", "http");
        understoodProtocols.put("https", "https");
        monthMap = new HashMap();
        monthMap.put("jan", new Integer(1));
        monthMap.put("feb", new Integer(2));
        monthMap.put("mar", new Integer(3));
        monthMap.put("apr", new Integer(4));
        monthMap.put("may", new Integer(5));
        monthMap.put("jun", new Integer(6));
        monthMap.put("jul", new Integer(7));
        monthMap.put("aug", new Integer(8));
        monthMap.put("sep", new Integer(9));
        monthMap.put("oct", new Integer(10));
        monthMap.put("nov", new Integer(11));
        monthMap.put("dec", new Integer(12));
        milTzMap = new HashMap();
        milTzMap.put("Z", "GMT");
        milTzMap.put("UT", "GMT");
        milTzMap.put("A", "GMT-01:00");
        milTzMap.put("M", "GMT-12:00");
        milTzMap.put("N", "GMT+01:00");
        milTzMap.put("Y", "GMT+12:00");
    }

    protected static class Filter {
        protected MappingRules mappings = new MappingRules();
        protected HashMap seeds = null;
        protected Integer defaultRescanInterval = null;
        protected Integer minimumRescanInterval = null;
        protected Integer badFeedRescanInterval = null;
        protected int dechromedContentMode = 0;
        protected int chromedContentMode = 0;
        protected int feedTimeoutValue = 60000;
        protected ArrayList metadata = new ArrayList();
        protected HashMap acls = new HashMap();
        protected CanonicalizationPolicies canonicalizationPolicies = new CanonicalizationPolicies();

        public Filter(DocumentSpecification spec, boolean warnOnBadSeed) throws ManifoldCFException {
            SpecificationNode n;
            int initialSize = spec.getChildCount();
            if (initialSize == 0) {
                initialSize = 1;
            }
            this.seeds = new HashMap(initialSize * 3 >> 1);
            int i = 0;
            while (i < spec.getChildCount()) {
                String reorder;
                if ((n = spec.getChild(i++)).getType().equals("map")) {
                    Pattern p;
                    String match = n.getAttributeValue("match");
                    String map = n.getAttributeValue("map");
                    if (match == null || match.length() <= 0) continue;
                    try {
                        p = Pattern.compile(match);
                    }
                    catch (PatternSyntaxException e) {
                        throw new ManifoldCFException("Regular expression '" + match + "' is illegal: " + e.getMessage(), (Throwable)e);
                    }
                    if (map == null) {
                        map = "";
                    }
                    this.mappings.add(new MappingRule(p, map));
                    continue;
                }
                if (!n.getType().equals("urlspec")) continue;
                String urlRegexp = n.getAttributeValue("regexp");
                if (urlRegexp == null) {
                    urlRegexp = "";
                }
                boolean reorderValue = (reorder = n.getAttributeValue("reorder")) == null ? false : reorder.equals("yes");
                String javaSession = n.getAttributeValue("javasessionremoval");
                boolean javaSessionValue = javaSession == null ? false : javaSession.equals("yes");
                String aspSession = n.getAttributeValue("aspsessionremoval");
                boolean aspSessionValue = aspSession == null ? false : aspSession.equals("yes");
                String phpSession = n.getAttributeValue("phpsessionremoval");
                boolean phpSessionValue = phpSession == null ? false : phpSession.equals("yes");
                String bvSession = n.getAttributeValue("bvsessionremoval");
                boolean bvSessionValue = bvSession == null ? false : bvSession.equals("yes");
                try {
                    this.canonicalizationPolicies.addRule(new CanonicalizationPolicy(Pattern.compile(urlRegexp), reorderValue, javaSessionValue, aspSessionValue, phpSessionValue, bvSessionValue));
                }
                catch (PatternSyntaxException e) {
                    throw new ManifoldCFException("Canonicalization regular expression '" + urlRegexp + "' is illegal: " + e.getMessage(), (Throwable)e);
                }
            }
            i = 0;
            while (i < spec.getChildCount()) {
                String mode;
                String interval;
                if ((n = spec.getChild(i++)).getType().equals("feed")) {
                    String rssURL = n.getAttributeValue("url");
                    if (rssURL == null || rssURL.length() <= 0) continue;
                    String canonicalURL = RSSConnector.makeDocumentIdentifier(this.canonicalizationPolicies, null, rssURL);
                    if (canonicalURL != null) {
                        this.seeds.put(canonicalURL, canonicalURL);
                        continue;
                    }
                    if (!warnOnBadSeed) continue;
                    Logging.connectors.warn((Object)("RSS: Illegal seed feed '" + rssURL + "'"));
                    continue;
                }
                if (n.getType().equals("metadata")) {
                    String name = n.getAttributeValue("name");
                    String value = n.getAttributeValue("value");
                    if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
                    this.metadata.add(new NameValue(name, value));
                    continue;
                }
                if (n.getType().equals("access")) {
                    String token = n.getAttributeValue("token");
                    this.acls.put(token, token);
                    continue;
                }
                if (n.getType().equals("feedrescan")) {
                    interval = n.getAttributeValue("value");
                    if (interval == null || interval.length() <= 0) continue;
                    try {
                        this.defaultRescanInterval = new Integer(interval);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (n.getType().equals("minfeedrescan")) {
                    interval = n.getAttributeValue("value");
                    if (interval == null || interval.length() <= 0) continue;
                    try {
                        this.minimumRescanInterval = new Integer(interval);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (n.getType().equals("badfeedrescan")) {
                    interval = n.getAttributeValue("value");
                    if (interval == null || interval.length() <= 0) continue;
                    try {
                        this.badFeedRescanInterval = new Integer(interval);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (n.getType().equals("feedtimeout")) {
                    String value = n.getAttributeValue("value");
                    if (value == null || value.length() <= 0) continue;
                    try {
                        this.feedTimeoutValue = Integer.parseInt(value) * 1000;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (n.getType().equals("dechromedmode")) {
                    mode = n.getAttributeValue("mode");
                    if (mode == null || mode.length() <= 0) continue;
                    if (mode.equals("none")) {
                        this.dechromedContentMode = 0;
                        continue;
                    }
                    if (mode.equals("description")) {
                        this.dechromedContentMode = 1;
                        continue;
                    }
                    if (!mode.equals("content")) continue;
                    this.dechromedContentMode = 2;
                    continue;
                }
                if (!n.getType().equals("chromedmode") || (mode = n.getAttributeValue("mode")) == null || mode.length() <= 0) continue;
                if (mode.equals("use")) {
                    this.chromedContentMode = 0;
                    continue;
                }
                if (!mode.equals("skip")) continue;
                this.chromedContentMode = 1;
            }
        }

        public boolean isSeed(String canonicalUrl) {
            return this.seeds.get(canonicalUrl) != null;
        }

        public Iterator getSeeds() {
            return this.seeds.keySet().iterator();
        }

        public ArrayList getMetadata() {
            return this.metadata;
        }

        public String[] getAcls() {
            String[] rval = new String[this.acls.size()];
            Iterator iter = this.acls.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                rval[i++] = (String)iter.next();
            }
            return rval;
        }

        public int getFeedTimeoutValue() {
            return this.feedTimeoutValue;
        }

        public int getDechromedContentMode() {
            return this.dechromedContentMode;
        }

        public int getChromedContentMode() {
            return this.chromedContentMode;
        }

        public Long getDefaultRescanTime(long currentTime) {
            if (this.defaultRescanInterval == null) {
                return null;
            }
            return new Long((long)this.defaultRescanInterval.intValue() * 60000L + currentTime);
        }

        public Long getMinimumRescanTime(long currentTime) {
            if (this.minimumRescanInterval == null) {
                return null;
            }
            return new Long((long)this.minimumRescanInterval.intValue() * 60000L + currentTime);
        }

        public Long getBadFeedRescanTime(long currentTime) {
            if (this.badFeedRescanInterval == null) {
                return null;
            }
            return new Long((long)this.badFeedRescanInterval.intValue() * 60000L + currentTime);
        }

        public boolean isLegalURL(String url) {
            if (this.seeds.get(url) != null) {
                return true;
            }
            return this.mappings.isMatch(url);
        }

        public String mapDocumentURL(String url) throws ManifoldCFException {
            if (this.seeds.get(url) != null) {
                return null;
            }
            return this.mappings.map(url);
        }

        public CanonicalizationPolicies getCanonicalizationPolicies() {
            return this.canonicalizationPolicies;
        }
    }

    protected static class MappingRules {
        protected ArrayList mappings = new ArrayList();

        public void add(MappingRule rule) {
            this.mappings.add(rule);
        }

        public boolean isMatch(String url) {
            if (this.mappings.size() == 0) {
                return true;
            }
            for (int i = 0; i < this.mappings.size(); ++i) {
                MappingRule p = (MappingRule)this.mappings.get(i);
                if (!p.checkMatch(url)) continue;
                return true;
            }
            return false;
        }

        public String map(String url) throws ManifoldCFException {
            if (this.mappings.size() == 0) {
                return url;
            }
            for (int i = 0; i < this.mappings.size(); ++i) {
                MappingRule p = (MappingRule)this.mappings.get(i);
                String rval = p.map(url);
                if (rval == null) continue;
                return rval;
            }
            return null;
        }
    }

    protected static class MappingRule {
        protected Pattern matchPattern;
        protected String evalExpression;

        public MappingRule(Pattern matchPattern, String evalExpression) {
            this.matchPattern = matchPattern;
            this.evalExpression = evalExpression;
        }

        public boolean checkMatch(String url) {
            Matcher matcher = this.matchPattern.matcher(url);
            return matcher.matches();
        }

        public String map(String url) throws ManifoldCFException {
            EvaluatorToken t;
            Matcher matcher = this.matchPattern.matcher(url);
            if (!matcher.matches()) {
                return null;
            }
            if (this.evalExpression == null || this.evalExpression.length() == 0) {
                return url;
            }
            StringBuffer sb = new StringBuffer();
            EvaluatorTokenStream et = new EvaluatorTokenStream(this.evalExpression);
            block11: while ((t = et.peek()) != null) {
                switch (t.getType()) {
                    case 2: {
                        et.advance();
                        continue block11;
                    }
                    case 0: {
                        et.advance();
                        String groupValue = matcher.group(t.getGroupNumber());
                        switch (t.getGroupStyle()) {
                            case 0: {
                                sb.append(groupValue);
                                continue block11;
                            }
                            case 1: {
                                sb.append(groupValue.toLowerCase());
                                continue block11;
                            }
                            case 2: {
                                sb.append(groupValue.toUpperCase());
                                continue block11;
                            }
                            case 3: {
                                if (groupValue.length() <= 0) continue block11;
                                sb.append(groupValue.substring(0, 1).toUpperCase());
                                sb.append(groupValue.substring(1).toLowerCase());
                                continue block11;
                            }
                        }
                        throw new ManifoldCFException("Illegal group style");
                    }
                    case 1: {
                        et.advance();
                        sb.append(t.getTextValue());
                        continue block11;
                    }
                }
                throw new ManifoldCFException("Illegal token type");
            }
            return sb.toString();
        }
    }

    protected static class CanonicalizationPolicies {
        protected ArrayList rules = new ArrayList();

        public void addRule(CanonicalizationPolicy rule) {
            this.rules.add(rule);
        }

        public CanonicalizationPolicy findMatch(String url) {
            int i = 0;
            while (i < this.rules.size()) {
                CanonicalizationPolicy rule;
                if (!(rule = (CanonicalizationPolicy)this.rules.get(i++)).checkMatch(url)) continue;
                return rule;
            }
            return null;
        }
    }

    protected static class CanonicalizationPolicy {
        protected Pattern matchPattern;
        protected boolean reorder;
        protected boolean removeJavaSession;
        protected boolean removeAspSession;
        protected boolean removePhpSession;
        protected boolean removeBVSession;

        public CanonicalizationPolicy(Pattern matchPattern, boolean reorder, boolean removeJavaSession, boolean removeAspSession, boolean removePhpSession, boolean removeBVSession) {
            this.matchPattern = matchPattern;
            this.reorder = reorder;
            this.removeJavaSession = removeJavaSession;
            this.removeAspSession = removeAspSession;
            this.removePhpSession = removePhpSession;
            this.removeBVSession = removeBVSession;
        }

        public boolean checkMatch(String url) {
            Matcher matcher = this.matchPattern.matcher(url);
            return matcher.find();
        }

        public boolean canReorder() {
            return this.reorder;
        }

        public boolean canRemoveJavaSession() {
            return this.removeJavaSession;
        }

        public boolean canRemoveAspSession() {
            return this.removeAspSession;
        }

        public boolean canRemovePhpSession() {
            return this.removePhpSession;
        }

        public boolean canRemoveBvSession() {
            return this.removeBVSession;
        }
    }

    protected static class EvaluatorTokenStream {
        protected String text;
        protected int pos;
        protected EvaluatorToken token = null;

        public EvaluatorTokenStream(String text) {
            this.text = text;
            this.pos = 0;
        }

        public EvaluatorToken peek() throws ManifoldCFException {
            if (this.token == null) {
                this.token = this.nextToken();
            }
            return this.token;
        }

        public void advance() {
            this.token = null;
        }

        protected EvaluatorToken nextToken() throws ManifoldCFException {
            char x;
            while (true) {
                if (this.pos == this.text.length()) {
                    return null;
                }
                x = this.text.charAt(this.pos);
                if (x > ' ') break;
                ++this.pos;
            }
            if (x == '\"') {
                ++this.pos;
                StringBuffer sb = new StringBuffer();
                while (this.pos != this.text.length()) {
                    x = this.text.charAt(this.pos);
                    ++this.pos;
                    if (x == '\"') break;
                    if (x == '\\') {
                        if (this.pos == this.text.length()) break;
                        x = this.text.charAt(this.pos++);
                    }
                    sb.append(x);
                }
                return new EvaluatorToken(sb.toString());
            }
            if (x == ',') {
                ++this.pos;
                return new EvaluatorToken();
            }
            StringBuffer sb = new StringBuffer();
            while (this.pos != this.text.length() && (x = this.text.charAt(this.pos)) >= '0' && x <= '9') {
                sb.append(x);
                ++this.pos;
            }
            String numberValue = sb.toString();
            int groupNumber = 0;
            if (numberValue.length() > 0) {
                groupNumber = new Integer(numberValue);
            }
            int modifierPos = this.pos;
            while (!(this.pos == this.text.length() || (x = this.text.charAt(this.pos)) == ',' || x >= '0' && x <= '9' || x <= ' ' && x >= '\u0000')) {
                ++this.pos;
            }
            int style = 0;
            if (modifierPos != this.pos) {
                String modifier = this.text.substring(modifierPos, this.pos);
                if (modifier.startsWith("u")) {
                    style = 2;
                } else if (modifier.startsWith("l")) {
                    style = 1;
                } else if (modifier.startsWith("m")) {
                    style = 3;
                } else {
                    throw new ManifoldCFException("Unknown style: " + modifier);
                }
            }
            return new EvaluatorToken(groupNumber, style);
        }
    }

    protected static class EvaluatorToken {
        public static final int TYPE_GROUP = 0;
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_COMMA = 2;
        public static final int GROUPSTYLE_NONE = 0;
        public static final int GROUPSTYLE_LOWER = 1;
        public static final int GROUPSTYLE_UPPER = 2;
        public static final int GROUPSTYLE_MIXED = 3;
        protected int type;
        protected int groupNumber = -1;
        protected int groupStyle = 0;
        protected String textValue = null;

        public EvaluatorToken() {
            this.type = 2;
        }

        public EvaluatorToken(int groupNumber, int groupStyle) {
            this.type = 0;
            this.groupNumber = groupNumber;
            this.groupStyle = groupStyle;
        }

        public EvaluatorToken(String text) {
            this.type = 1;
            this.textValue = text;
        }

        public int getType() {
            return this.type;
        }

        public int getGroupNumber() {
            return this.groupNumber;
        }

        public int getGroupStyle() {
            return this.groupStyle;
        }

        public String getTextValue() {
            return this.textValue;
        }
    }

    protected static class NameValue {
        protected String name;
        protected String value;

        public NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    protected class FeedItemContextClass
    extends XMLContext {
        protected int dechromedContentMode;
        protected String linkField;
        protected String pubDateField;
        protected String titleField;
        protected ArrayList categoryField;
        protected File contentsFile;

        public FeedItemContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, int dechromedContentMode) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.linkField = null;
            this.pubDateField = null;
            this.titleField = null;
            this.categoryField = new ArrayList();
            this.contentsFile = null;
            this.dechromedContentMode = dechromedContentMode;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("link")) {
                this.linkField = atts.getValue("href");
                return super.beginTag(namespaceURI, localName, qName, atts);
            }
            if (qName.equals("published") || qName.equals("updated")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("title")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("category")) {
                String category = atts.getValue("term");
                if (category != null && category.length() > 0) {
                    this.categoryField.add(category);
                }
                return super.beginTag(namespaceURI, localName, qName, atts);
            }
            switch (this.dechromedContentMode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!qName.equals("subtitle")) break;
                    try {
                        File tempFile = File.createTempFile("_rssdata_", "tmp");
                        return new XMLFileContext(this.theStream, namespaceURI, localName, qName, atts, tempFile);
                    }
                    catch (SocketTimeoutException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                }
                case 2: {
                    if (!qName.equals("content")) break;
                    try {
                        File tempFile = File.createTempFile("_rssdata_", "tmp");
                        return new XMLFileContext(this.theStream, namespaceURI, localName, qName, atts, tempFile);
                    }
                    catch (SocketTimeoutException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("published") || theTag.equals("updated")) {
                this.pubDateField = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("title")) {
                this.titleField = ((XMLStringContext)theContext).getValue();
            } else {
                switch (this.dechromedContentMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (!theTag.equals("description")) break;
                        this.tagCleanup();
                        this.contentsFile = ((XMLFileContext)theContext).getCompletedFile();
                        return;
                    }
                    case 2: {
                        if (!theTag.equals("content")) break;
                        this.tagCleanup();
                        this.contentsFile = ((XMLFileContext)theContext).getCompletedFile();
                        return;
                    }
                }
                super.endTag();
            }
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentsFile != null) {
                this.contentsFile.delete();
                this.contentsFile = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String documentIdentifier, IProcessActivity activities, Filter filter) throws ManifoldCFException {
            if (this.linkField != null && this.linkField.length() > 0) {
                Long origDate = null;
                if (this.pubDateField != null && this.pubDateField.length() > 0) {
                    origDate = RSSConnector.parseZuluDate(this.pubDateField);
                }
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    String newIdentifier = RSSConnector.makeDocumentIdentifier(filter.getCanonicalizationPolicies(), documentIdentifier, rawURL);
                    if (newIdentifier != null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("RSS: In Atom document '" + documentIdentifier + "', found a link to '" + newIdentifier + "', which has origination date " + (origDate == null ? "null" : origDate.toString())));
                        }
                        if (filter.isLegalURL(newIdentifier)) {
                            int q;
                            Object[][] dataValues;
                            String[] dataNames;
                            if (this.contentsFile == null) {
                                dataNames = new String[]{"pubdate", "title", "source", "category"};
                                dataValues = new String[dataNames.length][];
                                if (origDate != null) {
                                    dataValues[0] = new String[]{origDate.toString()};
                                }
                                if (this.titleField != null) {
                                    dataValues[1] = new String[]{this.titleField};
                                }
                                dataValues[2] = new String[]{documentIdentifier};
                                dataValues[3] = new String[this.categoryField.size()];
                                for (q = 0; q < this.categoryField.size(); ++q) {
                                    dataValues[3][q] = (String)this.categoryField.get(q);
                                }
                                activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                continue;
                            }
                            dataNames = new String[]{"pubdate", "title", "source", "category", "data"};
                            dataValues = new Object[dataNames.length][];
                            if (origDate != null) {
                                dataValues[0] = new String[]{origDate.toString()};
                            }
                            if (this.titleField != null) {
                                dataValues[1] = new String[]{this.titleField};
                            }
                            dataValues[2] = new String[]{documentIdentifier};
                            dataValues[3] = new String[this.categoryField.size()];
                            for (q = 0; q < this.categoryField.size(); ++q) {
                                dataValues[3][q] = (String)this.categoryField.get(q);
                            }
                            TempFileCharacterInput ci = new TempFileCharacterInput(this.contentsFile);
                            try {
                                this.contentsFile = null;
                                dataValues[4] = new Object[]{ci};
                                activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                continue;
                            }
                            finally {
                                ci.discard();
                                continue;
                            }
                        }
                        if (!Logging.connectors.isDebugEnabled()) continue;
                        Logging.connectors.debug((Object)("RSS: Identifier '" + newIdentifier + "' is excluded"));
                        continue;
                    }
                    if (!Logging.connectors.isDebugEnabled()) continue;
                    Logging.connectors.debug((Object)("RSS: In Atom document '" + documentIdentifier + "', found an unincluded URL '" + rawURL + "'"));
                }
            }
        }
    }

    protected class FeedContextClass
    extends XMLContext {
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected String ttlValue;

        public FeedContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.ttlValue = null;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("ttl")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("entry")) {
                return new FeedItemContextClass(this.theStream, namespaceURI, localName, qName, atts, this.filter.getDechromedContentMode());
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("entry")) {
                FeedItemContextClass itemContext = (FeedItemContextClass)theContext;
                itemContext.process(this.documentIdentifier, this.activities, this.filter);
            } else {
                super.endTag();
            }
        }

        protected boolean process() throws ManifoldCFException {
            Long minimumTime;
            long currentTime = System.currentTimeMillis();
            Long rescanTime = this.filter.getDefaultRescanTime(currentTime);
            if (this.ttlValue != null) {
                try {
                    int minutes = Integer.parseInt(this.ttlValue);
                    long nextTime = currentTime + (long)minutes * 60000L;
                    rescanTime = new Long(nextTime);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("RSS: In Atom document '" + this.documentIdentifier + "', found a ttl value of " + this.ttlValue + "; setting refetch time accordingly"));
                    }
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("RSS: Atom document '" + this.documentIdentifier + "' has illegal ttl value '" + this.ttlValue + "'"));
                }
            }
            if (rescanTime != null && (minimumTime = this.filter.getMinimumRescanTime(currentTime)) != null && rescanTime < minimumTime) {
                rescanTime = minimumTime;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: In Atom document '" + this.documentIdentifier + "' setting rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
            }
            this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
            return true;
        }
    }

    protected class RDFItemContextClass
    extends XMLContext {
        protected int dechromedContentMode;
        protected String linkField;
        protected String pubDateField;
        protected String titleField;
        protected File contentsFile;

        public RDFItemContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, int dechromedContentMode) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.linkField = null;
            this.pubDateField = null;
            this.titleField = null;
            this.contentsFile = null;
            this.dechromedContentMode = dechromedContentMode;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("link")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("dc:date")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("title")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            switch (this.dechromedContentMode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!qName.equals("description")) break;
                    try {
                        File tempFile = File.createTempFile("_rssdata_", "tmp");
                        return new XMLFileContext(this.theStream, namespaceURI, localName, qName, atts, tempFile);
                    }
                    catch (SocketTimeoutException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                }
                case 2: {
                    if (!qName.equals("dc:content")) break;
                    try {
                        File tempFile = File.createTempFile("_rssdata_", "tmp");
                        return new XMLFileContext(this.theStream, namespaceURI, localName, qName, atts, tempFile);
                    }
                    catch (SocketTimeoutException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("link")) {
                this.linkField = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("dc:date")) {
                this.pubDateField = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("title")) {
                this.titleField = ((XMLStringContext)theContext).getValue();
            } else {
                switch (this.dechromedContentMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (!theTag.equals("description")) break;
                        this.tagCleanup();
                        this.contentsFile = ((XMLFileContext)theContext).getCompletedFile();
                        return;
                    }
                    case 2: {
                        if (!theTag.equals("dc:content")) break;
                        this.tagCleanup();
                        this.contentsFile = ((XMLFileContext)theContext).getCompletedFile();
                        return;
                    }
                }
                super.endTag();
            }
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentsFile != null) {
                this.contentsFile.delete();
                this.contentsFile = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String documentIdentifier, IProcessActivity activities, Filter filter) throws ManifoldCFException {
            if (this.linkField != null && this.linkField.length() > 0) {
                Long origDate = null;
                if (this.pubDateField != null && this.pubDateField.length() > 0) {
                    origDate = RSSConnector.parseZuluDate(this.pubDateField);
                }
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    String newIdentifier = RSSConnector.makeDocumentIdentifier(filter.getCanonicalizationPolicies(), documentIdentifier, rawURL);
                    if (newIdentifier != null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("RSS: In RDF document '" + documentIdentifier + "', found a link to '" + newIdentifier + "', which has origination date " + (origDate == null ? "null" : origDate.toString())));
                        }
                        if (filter.isLegalURL(newIdentifier)) {
                            Object[][] dataValues;
                            String[] dataNames;
                            if (this.contentsFile == null) {
                                dataNames = new String[]{"pubdate", "title", "source"};
                                dataValues = new String[dataNames.length][];
                                if (origDate != null) {
                                    dataValues[0] = new String[]{origDate.toString()};
                                }
                                if (this.titleField != null) {
                                    dataValues[1] = new String[]{this.titleField};
                                }
                                dataValues[2] = new String[]{documentIdentifier};
                                activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                continue;
                            }
                            dataNames = new String[]{"pubdate", "title", "source", "data"};
                            dataValues = new Object[dataNames.length][];
                            if (origDate != null) {
                                dataValues[0] = new String[]{origDate.toString()};
                            }
                            if (this.titleField != null) {
                                dataValues[1] = new String[]{this.titleField};
                            }
                            dataValues[2] = new String[]{documentIdentifier};
                            TempFileCharacterInput ci = new TempFileCharacterInput(this.contentsFile);
                            try {
                                this.contentsFile = null;
                                dataValues[3] = new Object[]{ci};
                                activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                continue;
                            }
                            finally {
                                ci.discard();
                                continue;
                            }
                        }
                        if (!Logging.connectors.isDebugEnabled()) continue;
                        Logging.connectors.debug((Object)("RSS: Identifier '" + newIdentifier + "' is excluded"));
                        continue;
                    }
                    if (!Logging.connectors.isDebugEnabled()) continue;
                    Logging.connectors.debug((Object)("RSS: In RSS document '" + documentIdentifier + "', found an unincluded URL '" + rawURL + "'"));
                }
            }
        }
    }

    protected class RDFContextClass
    extends XMLContext {
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected String ttlValue;

        public RDFContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.ttlValue = null;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("ttl")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("item")) {
                return new RDFItemContextClass(this.theStream, namespaceURI, localName, qName, atts, this.filter.getDechromedContentMode());
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("item")) {
                RDFItemContextClass itemContext = (RDFItemContextClass)theContext;
                itemContext.process(this.documentIdentifier, this.activities, this.filter);
            } else {
                super.endTag();
            }
        }

        protected boolean process() throws ManifoldCFException {
            Long minimumTime;
            long currentTime = System.currentTimeMillis();
            Long rescanTime = this.filter.getDefaultRescanTime(currentTime);
            if (this.ttlValue != null) {
                try {
                    int minutes = Integer.parseInt(this.ttlValue);
                    long nextTime = currentTime + (long)minutes * 60000L;
                    rescanTime = new Long(nextTime);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("RSS: In RDF document '" + this.documentIdentifier + "', found a ttl value of " + this.ttlValue + "; setting refetch time accordingly"));
                    }
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("RSS: RDF document '" + this.documentIdentifier + "' has illegal ttl value '" + this.ttlValue + "'"));
                }
            }
            if (rescanTime != null && (minimumTime = this.filter.getMinimumRescanTime(currentTime)) != null && rescanTime < minimumTime) {
                rescanTime = minimumTime;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: In RDF document '" + this.documentIdentifier + "' setting rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
            }
            this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
            return true;
        }
    }

    protected class RSSItemContextClass
    extends XMLContext {
        protected int dechromedContentMode;
        protected String guidField;
        protected String linkField;
        protected String pubDateField;
        protected String titleField;
        protected ArrayList categoryField;
        protected File contentsFile;

        public RSSItemContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, int dechromedContentMode) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.guidField = null;
            this.linkField = null;
            this.pubDateField = null;
            this.titleField = null;
            this.categoryField = new ArrayList();
            this.contentsFile = null;
            this.dechromedContentMode = dechromedContentMode;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("link")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("guid")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("pubDate")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("title")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("category")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            switch (this.dechromedContentMode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!qName.equals("description")) break;
                    try {
                        File tempFile = File.createTempFile("_rssdata_", "tmp");
                        return new XMLFileContext(this.theStream, namespaceURI, localName, qName, atts, tempFile);
                    }
                    catch (SocketTimeoutException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                }
                case 2: {
                    if (!qName.equals("content")) break;
                    try {
                        File tempFile = File.createTempFile("_rssdata_", "tmp");
                        return new XMLFileContext(this.theStream, namespaceURI, localName, qName, atts, tempFile);
                    }
                    catch (SocketTimeoutException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("link")) {
                this.linkField = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("guid")) {
                this.guidField = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("pubDate")) {
                this.pubDateField = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("title")) {
                this.titleField = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("category")) {
                this.categoryField.add(((XMLStringContext)theContext).getValue());
            } else {
                switch (this.dechromedContentMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (!theTag.equals("description")) break;
                        this.tagCleanup();
                        this.contentsFile = ((XMLFileContext)theContext).getCompletedFile();
                        return;
                    }
                    case 2: {
                        if (!theTag.equals("content")) break;
                        this.tagCleanup();
                        this.contentsFile = ((XMLFileContext)theContext).getCompletedFile();
                        return;
                    }
                }
                super.endTag();
            }
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentsFile != null) {
                this.contentsFile.delete();
                this.contentsFile = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String documentIdentifier, IProcessActivity activities, Filter filter) throws ManifoldCFException {
            if (this.linkField == null || this.linkField.length() == 0) {
                this.linkField = this.guidField;
            }
            if (this.linkField != null && this.linkField.length() > 0) {
                Long origDate = null;
                if (this.pubDateField != null && this.pubDateField.length() > 0 && (origDate = RSSConnector.parseRSSDate(this.pubDateField)) == null) {
                    origDate = RSSConnector.parseChinaDate(this.pubDateField);
                }
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    String newIdentifier = RSSConnector.makeDocumentIdentifier(filter.getCanonicalizationPolicies(), documentIdentifier, rawURL);
                    if (newIdentifier != null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("RSS: In RSS document '" + documentIdentifier + "', found a link to '" + newIdentifier + "', which has origination date " + (origDate == null ? "null" : origDate.toString())));
                        }
                        if (filter.isLegalURL(newIdentifier)) {
                            int q;
                            Object[][] dataValues;
                            String[] dataNames;
                            if (this.contentsFile == null) {
                                dataNames = new String[]{"pubdate", "title", "source", "category"};
                                dataValues = new String[dataNames.length][];
                                if (origDate != null) {
                                    dataValues[0] = new String[]{origDate.toString()};
                                }
                                if (this.titleField != null) {
                                    dataValues[1] = new String[]{this.titleField};
                                }
                                dataValues[2] = new String[]{documentIdentifier};
                                dataValues[3] = new String[this.categoryField.size()];
                                for (q = 0; q < this.categoryField.size(); ++q) {
                                    dataValues[3][q] = (String)this.categoryField.get(q);
                                }
                                activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                continue;
                            }
                            dataNames = new String[]{"pubdate", "title", "source", "category", "data"};
                            dataValues = new Object[dataNames.length][];
                            if (origDate != null) {
                                dataValues[0] = new String[]{origDate.toString()};
                            }
                            if (this.titleField != null) {
                                dataValues[1] = new String[]{this.titleField};
                            }
                            dataValues[2] = new String[]{documentIdentifier};
                            dataValues[3] = new String[this.categoryField.size()];
                            for (q = 0; q < this.categoryField.size(); ++q) {
                                dataValues[3][q] = (String)this.categoryField.get(q);
                            }
                            TempFileCharacterInput ci = new TempFileCharacterInput(this.contentsFile);
                            try {
                                this.contentsFile = null;
                                dataValues[4] = new Object[]{ci};
                                activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                continue;
                            }
                            finally {
                                ci.discard();
                                continue;
                            }
                        }
                        if (!Logging.connectors.isDebugEnabled()) continue;
                        Logging.connectors.debug((Object)("RSS: Identifier '" + newIdentifier + "' is excluded"));
                        continue;
                    }
                    if (!Logging.connectors.isDebugEnabled()) continue;
                    Logging.connectors.debug((Object)("RSS: In RSS document '" + documentIdentifier + "', found an unincluded URL '" + rawURL + "'"));
                }
            }
        }
    }

    protected class RSSChannelContextClass
    extends XMLContext {
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected String ttlValue;

        public RSSChannelContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.ttlValue = null;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("ttl")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("item")) {
                return new RSSItemContextClass(this.theStream, namespaceURI, localName, qName, atts, this.filter.getDechromedContentMode());
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("item")) {
                RSSItemContextClass itemContext = (RSSItemContextClass)theContext;
                itemContext.process(this.documentIdentifier, this.activities, this.filter);
            } else {
                super.endTag();
            }
        }

        protected boolean process() throws ManifoldCFException {
            Long minimumTime;
            long currentTime = System.currentTimeMillis();
            Long rescanTime = this.filter.getDefaultRescanTime(currentTime);
            if (this.ttlValue != null) {
                try {
                    int minutes = Integer.parseInt(this.ttlValue);
                    long nextTime = currentTime + (long)minutes * 60000L;
                    rescanTime = new Long(nextTime);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("RSS: In RSS document '" + this.documentIdentifier + "', found a ttl value of " + this.ttlValue + "; setting refetch time accordingly"));
                    }
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("RSS: RSS document '" + this.documentIdentifier + "' has illegal ttl value '" + this.ttlValue + "'"));
                }
            }
            if (rescanTime != null && (minimumTime = this.filter.getMinimumRescanTime(currentTime)) != null && rescanTime < minimumTime) {
                rescanTime = minimumTime;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: In RSS document '" + this.documentIdentifier + "' setting rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
            }
            this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
            return true;
        }
    }

    protected class RSSContextClass
    extends XMLContext {
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected boolean rescanTimeSet;

        public RSSContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.rescanTimeSet = false;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("channel")) {
                return new RSSChannelContextClass(this.theStream, namespaceURI, localName, qName, atts, this.documentIdentifier, this.activities, this.filter);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext context = this.theStream.getContext();
            String tagName = context.getQname();
            if (tagName.equals("channel")) {
                this.rescanTimeSet = ((RSSChannelContextClass)context).process();
            } else {
                super.endTag();
            }
        }

        protected boolean process() throws ManifoldCFException {
            return this.rescanTimeSet;
        }
    }

    protected class OuterContextClass
    extends XMLContext {
        protected int outerTagCount;
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected boolean rescanTimeSet;

        public OuterContextClass(XMLStream theStream, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream);
            this.outerTagCount = 0;
            this.rescanTimeSet = false;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        public void checkIfValidFeed() {
            if (this.outerTagCount == 0 && Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: RSS document '" + this.documentIdentifier + "' does not have rss, feed, or rdf:RDF tag - not valid feed"));
            }
        }

        public void setDefaultRescanTimeIfNeeded() throws ManifoldCFException {
            if (!this.rescanTimeSet) {
                long currentTime = System.currentTimeMillis();
                Long rescanTime = this.filter.getBadFeedRescanTime(currentTime);
                if (rescanTime == null) {
                    rescanTime = this.filter.getDefaultRescanTime(currentTime);
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: In RSS document '" + this.documentIdentifier + "' setting default rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
                }
                this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
                this.rescanTimeSet = true;
            }
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("rss")) {
                ++this.outerTagCount;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Parsed bottom-level XML for RSS document '" + this.documentIdentifier + "'"));
                }
                return new RSSContextClass(this.theStream, namespaceURI, localName, qName, atts, this.documentIdentifier, this.activities, this.filter);
            }
            if (qName.equals("rdf:RDF")) {
                ++this.outerTagCount;
                return new RDFContextClass(this.theStream, namespaceURI, localName, qName, atts, this.documentIdentifier, this.activities, this.filter);
            }
            if (qName.equals("feed")) {
                ++this.outerTagCount;
                return new FeedContextClass(this.theStream, namespaceURI, localName, qName, atts, this.documentIdentifier, this.activities, this.filter);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext context = this.theStream.getContext();
            String tagName = context.getQname();
            if (tagName.equals("rss")) {
                this.rescanTimeSet = ((RSSContextClass)context).process();
            } else if (tagName.equals("rdf:RDF")) {
                this.rescanTimeSet = ((RDFContextClass)context).process();
            } else if (tagName.equals("feed")) {
                this.rescanTimeSet = ((FeedContextClass)context).process();
            } else {
                super.endTag();
            }
        }
    }
}

