/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.rss;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class SetSeedList {
    public static final String _rcsid = "@(#)$Id: SetSeedList.java 988245 2010-08-23 18:39:35Z kwright $";

    private SetSeedList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: SetSeedList <job_id>");
            System.err.println("(Reads a set of urls from stdin)");
            System.exit(-1);
        }
        String jobString = args[0];
        try {
            ManifoldCF.initializeEnvironment();
            IThreadContext tc = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make((IThreadContext)tc);
            IJobDescription desc = jobManager.load(new Long(jobString));
            DocumentSpecification ds = desc.getSpecification();
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals("feed")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            InputStreamReader str = new InputStreamReader(System.in);
            try {
                BufferedReader is = new BufferedReader(str);
                try {
                    String nextString;
                    while ((nextString = is.readLine()) != null) {
                        if (nextString.length() == 0) continue;
                        SpecificationNode node = new SpecificationNode("feed");
                        node.setAttribute("url", nextString);
                        ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                    }
                }
                finally {
                    is.close();
                }
            }
            finally {
                ((Reader)str).close();
            }
            jobManager.save(desc);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-2);
        }
    }
}

