/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.rss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.CircularRedirectException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.rss.IThrottledConnection;
import org.apache.manifoldcf.crawler.interfaces.IVersionActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class ThrottledFetcher {
    public static final String _rcsid = "@(#)$Id: ThrottledFetcher.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final boolean recordEverything = false;
    protected static final int READ_CHUNK_LENGTH = 4096;
    protected static int globalHandleCount = 0;
    protected static Integer globalHandleCounterLock = new Integer(0);
    protected Map serverMap = new HashMap();
    protected int refCount = 0;
    private static String currentHost = null;
    protected static final String resultLogFile = "/common/rss/resultlog";
    protected static final String dataFileFolder = "/common/rss/data/";
    protected static DataRecorder dataRecorder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerGlobalHandle(int maxHandles) throws ManifoldCFException {
        try {
            Integer n = globalHandleCounterLock;
            synchronized (n) {
                while (globalHandleCount >= maxHandles) {
                    globalHandleCounterLock.wait();
                }
                ++globalHandleCount;
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void releaseGlobalHandle() {
        Integer n = globalHandleCounterLock;
        synchronized (n) {
            --globalHandleCount;
            globalHandleCounterLock.notifyAll();
        }
    }

    public synchronized IThrottledConnection createConnection(String serverName, double minimumMillisecondsPerBytePerServer, int maxOpenConnectionsPerServer, long minimumMillisecondsPerFetchPerServer, int connectionLimit, int connectionTimeoutMilliseconds) throws ManifoldCFException, ServiceInterruption {
        Server server = (Server)this.serverMap.get(serverName);
        if (server == null) {
            server = new Server(serverName);
            this.serverMap.put(serverName, server);
        }
        return new ThrottledConnection(server, minimumMillisecondsPerBytePerServer, maxOpenConnectionsPerServer, minimumMillisecondsPerFetchPerServer, connectionTimeoutMilliseconds, connectionLimit);
    }

    public synchronized void poll() throws ManifoldCFException {
    }

    public synchronized void noteConnectionEstablished() {
        ++this.refCount;
    }

    public synchronized void noteConnectionReleased() {
        --this.refCount;
        if (this.refCount == 0) {
            for (String serverName : this.serverMap.keySet()) {
                Server server = (Server)this.serverMap.get(serverName);
                server.discard();
            }
            this.serverMap.clear();
        }
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            currentHost = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        dataRecorder = new DataRecorder();
    }

    protected class Server {
        protected String serverName;
        protected long nextFetchTime = 0L;
        protected int refCount = 0;
        protected double rateEstimate = 0.0;
        protected boolean estimateValid = false;
        protected boolean estimateInProgress = false;
        protected long seriesStartTime = -1L;
        protected long totalBytesRead = -1L;
        protected Integer firstChunkLock = new Integer(0);
        protected int outstandingConnections = 0;

        public Server(String serverName) {
            this.serverName = serverName;
        }

        public String getServerName() {
            return this.serverName;
        }

        public synchronized void registerConnection(int maxOutstandingConnections) throws ManifoldCFException {
            try {
                while (this.outstandingConnections >= maxOutstandingConnections) {
                    this.wait();
                }
                ++this.outstandingConnections;
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
        }

        public synchronized void releaseConnection() {
            --this.outstandingConnections;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginFetch(long minimumMillisecondsPerFetchPerServer) throws InterruptedException {
            long waitAmount = 0L;
            long currentTime = System.currentTimeMillis();
            Server server = this;
            synchronized (server) {
                if (currentTime < this.nextFetchTime) {
                    waitAmount = this.nextFetchTime - currentTime;
                    this.nextFetchTime += minimumMillisecondsPerFetchPerServer;
                } else {
                    this.nextFetchTime = currentTime + minimumMillisecondsPerFetchPerServer;
                }
            }
            if (waitAmount > 0L) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Performing a fetch wait for server '" + this.serverName + "' for " + new Long(waitAmount).toString() + " ms."));
                }
                ManifoldCF.sleep((long)waitAmount);
            }
            server = this;
            synchronized (server) {
                if (this.refCount == 0) {
                    this.estimateValid = false;
                    this.rateEstimate = 0.0;
                    this.totalBytesRead = 0L;
                    this.estimateInProgress = false;
                    this.seriesStartTime = -1L;
                }
                ++this.refCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endFetch() {
            Server server = this;
            synchronized (server) {
                --this.refCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginRead(int byteCount, double minimumMillisecondsPerBytePerServer) throws InterruptedException {
            long currentTime = System.currentTimeMillis();
            Integer n = this.firstChunkLock;
            synchronized (n) {
                while (this.estimateInProgress) {
                    this.firstChunkLock.wait();
                }
                if (!this.estimateValid) {
                    this.seriesStartTime = currentTime;
                    this.estimateInProgress = true;
                    Server server = this;
                    synchronized (server) {
                        this.totalBytesRead += (long)byteCount;
                    }
                    return;
                }
            }
            long waitTime = 0L;
            Server server = this;
            synchronized (server) {
                this.totalBytesRead += (long)byteCount;
                long estimatedTime = (long)(this.rateEstimate * (double)byteCount);
                long desiredEndTime = this.seriesStartTime + (long)((double)this.totalBytesRead * minimumMillisecondsPerBytePerServer);
                waitTime = desiredEndTime - estimatedTime - currentTime;
            }
            if (waitTime > 0L) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Performing a read wait on server '" + this.serverName + "' of " + new Long(waitTime).toString() + " ms."));
                }
                ManifoldCF.sleep((long)waitTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endRead(int originalCount, int actualCount) {
            long currentTime = System.currentTimeMillis();
            Object object = this;
            synchronized (object) {
                this.totalBytesRead = this.totalBytesRead + (long)actualCount - (long)originalCount;
            }
            object = this.firstChunkLock;
            synchronized (object) {
                if (this.estimateInProgress) {
                    this.rateEstimate = actualCount == 0 ? 0.0 : (double)(currentTime - this.seriesStartTime) / (double)actualCount;
                    this.estimateValid = true;
                    this.estimateInProgress = false;
                    this.firstChunkLock.notifyAll();
                }
            }
        }

        public void discard() {
        }
    }

    protected static class ThrottledInputstream
    extends InputStream {
        protected double minimumMillisecondsPerBytePerServer;
        protected ThrottledConnection throttledConnection;
        protected Server server;
        protected InputStream inputStream;
        protected DataSession dataSession;

        public ThrottledInputstream(ThrottledConnection connection, Server server, InputStream is, double minimumMillisecondsPerBytePerServer, DataSession dataSession) {
            this.throttledConnection = connection;
            this.server = server;
            this.inputStream = is;
            this.minimumMillisecondsPerBytePerServer = minimumMillisecondsPerBytePerServer;
            this.dataSession = dataSession;
        }

        public int read() throws IOException {
            byte[] byteArray = new byte[1];
            int count = this.read(byteArray, 0, 1);
            if (count == -1) {
                return count;
            }
            return byteArray[0];
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int amt;
            int totalCount = 0;
            while (len > 4096) {
                amt = this.basicRead(b, off, 4096, totalCount);
                if (amt == -1) {
                    if (totalCount == 0) {
                        return amt;
                    }
                    return totalCount;
                }
                totalCount += amt;
                off += amt;
                len -= amt;
            }
            if (len > 0) {
                amt = this.basicRead(b, off, len, totalCount);
                if (amt == -1) {
                    if (totalCount == 0) {
                        return amt;
                    }
                    return totalCount;
                }
                return totalCount + amt;
            }
            return totalCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int basicRead(byte[] b, int off, int len, int totalSoFar) throws IOException {
            this.server.beginRead(len, this.minimumMillisecondsPerBytePerServer);
            int amt = 0;
            try {
                int n = amt = this.inputStream.read(b, off, len);
                if (amt == -1) {
                    this.server.endRead(len, 0);
                } else {
                    this.server.endRead(len, amt);
                    this.throttledConnection.logFetchCount(amt);
                }
                return n;
            }
            catch (Throwable throwable) {
                try {
                    if (amt == -1) {
                        this.server.endRead(len, 0);
                    } else {
                        this.server.endRead(len, amt);
                        this.throttledConnection.logFetchCount(amt);
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    InterruptedIOException e2 = new InterruptedIOException("Interrupted");
                    e2.bytesTransferred = totalSoFar;
                    throw e2;
                }
            }
        }

        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        public int available() throws IOException {
            return this.inputStream.available();
        }

        public void mark(int readLimit) {
            this.inputStream.mark(readLimit);
        }

        public void reset() throws IOException {
            this.inputStream.reset();
        }

        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        public void close() throws IOException {
            this.inputStream.close();
        }
    }

    protected static class ThrottledConnection
    implements IThrottledConnection {
        protected double minimumMillisecondsPerBytePerServer;
        protected int maxOpenConnectionsPerServer;
        protected long minimumMillisecondsPerFetchPerServer;
        protected Server server;
        protected HttpMethodBase fetchMethod = null;
        protected long startFetchTime = -1L;
        protected Throwable throwable = null;
        protected String myUrl = null;
        protected int statusCode = -1;
        protected String fetchType = null;
        protected long fetchCounter = 0L;
        protected MultiThreadedHttpConnectionManager connectionManager = null;
        protected int connectionTimeoutMilliseconds;
        protected DataSession dataSession = null;

        public ThrottledConnection(Server server, double minimumMillisecondsPerBytePerServer, int maxOpenConnectionsPerServer, long minimumMillisecondsPerFetchPerServer, int connectionTimeoutMilliseconds, int connectionLimit) throws ManifoldCFException {
            this.minimumMillisecondsPerBytePerServer = minimumMillisecondsPerBytePerServer;
            this.maxOpenConnectionsPerServer = maxOpenConnectionsPerServer;
            this.minimumMillisecondsPerFetchPerServer = minimumMillisecondsPerFetchPerServer;
            this.server = server;
            this.connectionTimeoutMilliseconds = connectionTimeoutMilliseconds;
            this.connectionManager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams httpConParam = this.connectionManager.getParams();
            httpConParam.setMaxTotalConnections(1);
            httpConParam.setConnectionTimeout(connectionTimeoutMilliseconds);
            httpConParam.setSoTimeout(connectionTimeoutMilliseconds);
            ThrottledFetcher.registerGlobalHandle(connectionLimit);
            server.registerConnection(maxOpenConnectionsPerServer);
        }

        public void beginFetch(String fetchType) throws ManifoldCFException {
            this.fetchType = fetchType;
            this.fetchCounter = 0L;
            try {
                this.server.beginFetch(this.minimumMillisecondsPerFetchPerServer);
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", 2);
            }
        }

        public void logFetchCount(int count) {
            this.fetchCounter += (long)count;
        }

        public int executeFetch(String protocol, int port, String urlPath, String userAgent, String from, String proxyHost, int proxyPort, String proxyAuthDomain, String proxyAuthUsername, String proxyAuthPassword, String lastETag, String lastModified) throws ManifoldCFException, ServiceInterruption {
            StringBuffer sb = new StringBuffer(protocol);
            sb.append("://").append(this.server.getServerName());
            if (port != -1) {
                sb.append(":").append(Integer.toString(port));
            }
            sb.append(urlPath);
            this.myUrl = sb.toString();
            try {
                HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
                client.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)new Boolean(true));
                this.fetchMethod = new GetMethod();
                HostConfiguration config = new HostConfiguration();
                config.setHost(this.server.getServerName(), port, Protocol.getProtocol((String)protocol));
                if (proxyHost != null && proxyHost.length() > 0) {
                    config.setProxy(proxyHost, proxyPort);
                    if (proxyAuthUsername != null && proxyAuthUsername.length() > 0) {
                        if (proxyAuthPassword == null) {
                            proxyAuthPassword = "";
                        }
                        if (proxyAuthDomain == null) {
                            proxyAuthDomain = "";
                        }
                        client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new NTCredentials(proxyAuthUsername, proxyAuthPassword, currentHost, proxyAuthDomain));
                    }
                }
                this.startFetchTime = System.currentTimeMillis();
                this.fetchMethod.setURI(new URI(urlPath, true));
                this.fetchMethod.setRequestHeader("User-Agent", userAgent);
                this.fetchMethod.setRequestHeader("From", from);
                if (lastETag != null) {
                    this.fetchMethod.setRequestHeader("ETag", lastETag);
                }
                if (lastModified != null) {
                    this.fetchMethod.setRequestHeader("Last-Modified", lastModified);
                }
                this.fetchMethod.getParams().setSoTimeout(this.connectionTimeoutMilliseconds);
                this.fetchMethod.setFollowRedirects(true);
                try {
                    ExecuteMethodThread t = new ExecuteMethodThread(client, config, this.fetchMethod);
                    try {
                        t.start();
                        t.join();
                        Throwable thr = t.getException();
                        if (thr != null) {
                            throw thr;
                        }
                        this.statusCode = t.getResponse();
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw e;
                    }
                    switch (this.statusCode) {
                        case 200: {
                            return 0;
                        }
                        case 305: 
                        case 401: {
                            return 1;
                        }
                        case 408: 
                        case 503: 
                        case 504: {
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Http response temporary error on '" + this.myUrl + "': " + Integer.toString(this.statusCode), null, currentTime + 3600000L, currentTime + 86400000L, -1, false);
                        }
                        case 304: {
                            return 3;
                        }
                        case 500: {
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Http response internal server error on '" + this.myUrl + "': " + Integer.toString(this.statusCode), null, currentTime + 3600000L, currentTime + 86400000L, -1, false);
                        }
                    }
                    return 2;
                }
                catch (SocketTimeoutException e) {
                    this.throwable = e;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Timed out waiting for IO for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 0x6DDD00L, -1, false);
                }
                catch (ConnectTimeoutException e) {
                    this.throwable = e;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Timed out waiting for connect for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 3600000L, currentTime + 43200000L, -1, false);
                }
                catch (InterruptedIOException e) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                catch (CircularRedirectException e) {
                    this.throwable = e;
                    this.statusCode = -100;
                    return 2;
                }
                catch (NoHttpResponseException e) {
                    this.throwable = e;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Timed out waiting for response for '" + this.myUrl + "'", (Throwable)e, currentTime + 900000L, currentTime + 0x6DDD00L, -1, false);
                }
                catch (ConnectException e) {
                    this.throwable = e;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Timed out waiting for a connection for '" + this.myUrl + "'", (Throwable)e, currentTime + 1000000L, currentTime + 43200000L, -1, false);
                }
                catch (NoRouteToHostException e) {
                    this.throwable = e;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("No route to host for '" + this.myUrl + "'", (Throwable)e, currentTime + 1000000L, currentTime + 43200000L, -1, false);
                }
                catch (IOException e) {
                    this.throwable = e;
                    this.statusCode = -103;
                    return 2;
                }
            }
            catch (InterruptedException e) {
                this.fetchMethod = null;
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (URIException e) {
                this.throwable = new ManifoldCFException("Illegal URI: '" + this.myUrl + "'", (Throwable)e);
                this.statusCode = -101;
                return 2;
            }
            catch (IllegalArgumentException e) {
                this.throwable = new ManifoldCFException("Illegal URI: '" + this.myUrl + "'", (Throwable)e);
                this.statusCode = -101;
                return 2;
            }
            catch (IllegalStateException e) {
                this.throwable = new ManifoldCFException("Illegal state while fetching URI: '" + this.myUrl + "'", (Throwable)e);
                this.statusCode = -102;
                return 2;
            }
            catch (ServiceInterruption e) {
                throw e;
            }
            catch (ManifoldCFException e) {
                throw e;
            }
            catch (Throwable e) {
                Logging.connectors.debug((Object)("RSS: Caught an unexpected exception: " + e.getMessage()), e);
                this.throwable = e;
                this.statusCode = -999;
                return 2;
            }
        }

        public int getResponseCode() throws ManifoldCFException, ServiceInterruption {
            return this.statusCode;
        }

        public InputStream getResponseBodyStream() throws ManifoldCFException, ServiceInterruption {
            if (this.fetchMethod == null) {
                throw new ManifoldCFException("Attempt to get a response when there is no method");
            }
            try {
                InputStream bodyStream = this.fetchMethod.getResponseBodyAsStream();
                if (bodyStream == null) {
                    throw new ManifoldCFException("Failed to set up body response stream");
                }
                return new ThrottledInputstream(this, this.server, bodyStream, this.minimumMillisecondsPerBytePerServer, this.dataSession);
            }
            catch (IOException e) {
                throw new ManifoldCFException("IO exception setting up response stream", (Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new ManifoldCFException("State error getting response body", (Throwable)e);
            }
        }

        public String getResponseHeader(String headerName) throws ManifoldCFException, ServiceInterruption {
            Header h = this.fetchMethod.getResponseHeader(headerName);
            if (h == null) {
                return null;
            }
            return h.getValue();
        }

        public void doneFetch(IVersionActivity activities) throws ManifoldCFException {
            if (this.fetchType != null) {
                long endTime = System.currentTimeMillis();
                this.server.endFetch();
                activities.recordActivity(new Long(this.startFetchTime), "fetch", new Long(this.fetchCounter), this.myUrl, Integer.toString(this.statusCode), this.throwable == null ? null : this.throwable.getMessage(), null);
                Logging.connectors.info((Object)("RSS: FETCH " + this.fetchType + "|" + this.myUrl + "|" + new Long(this.startFetchTime).toString() + "+" + new Long(endTime - this.startFetchTime).toString() + "|" + Integer.toString(this.statusCode) + "|" + new Long(this.fetchCounter).toString() + "|" + (this.throwable == null ? "" : this.throwable.getClass().getName() + "| " + this.throwable.getMessage())));
                if (this.throwable != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Fetch exception for '" + this.myUrl + "'"), this.throwable);
                }
                if (this.fetchMethod != null) {
                    try {
                        this.fetchMethod.releaseConnection();
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                    this.fetchMethod = null;
                }
                this.throwable = null;
                this.startFetchTime = -1L;
                this.myUrl = null;
                this.statusCode = -1;
                this.fetchType = null;
            }
        }

        public void close() throws ManifoldCFException {
            this.connectionManager.shutdown();
            this.server.releaseConnection();
            ThrottledFetcher.releaseGlobalHandle();
        }

        protected static class ExecuteMethodThread
        extends Thread {
            protected HttpClient client;
            protected HostConfiguration hostConfiguration;
            protected HttpMethodBase executeMethod;
            protected Throwable exception = null;
            protected int rval = 0;

            public ExecuteMethodThread(HttpClient client, HostConfiguration hostConfiguration, HttpMethodBase executeMethod) {
                this.setDaemon(true);
                this.client = client;
                this.hostConfiguration = hostConfiguration;
                this.executeMethod = executeMethod;
            }

            public void run() {
                try {
                    this.rval = this.client.executeMethod(this.hostConfiguration, (HttpMethod)this.executeMethod);
                }
                catch (Throwable e) {
                    this.exception = e;
                }
            }

            public Throwable getException() {
                return this.exception;
            }

            public int getResponse() {
                return this.rval;
            }
        }
    }

    protected static class DataSession {
        protected DataRecorder dr;
        protected String url;
        protected int responseCode = 0;
        protected ArrayList headerNames = new ArrayList();
        protected ArrayList headerValues = new ArrayList();
        protected String documentName = null;

        public DataSession(DataRecorder dr, String url) {
            this.dr = dr;
            this.url = url;
        }

        public void setResponseCode(int responseCode) {
            this.responseCode = responseCode;
        }

        public void addHeader(String headerName, String headerValue) {
            this.headerNames.add(headerName);
            this.headerValues.add(headerValue);
        }

        public void endHeader() throws ManifoldCFException {
            this.documentName = this.dr.writeResponseRecord(this.url, this.responseCode, this.headerNames, this.headerValues);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] theBytes, int off, int length) throws IOException {
            if (this.documentName == null) {
                throw new IOException("Must end header before reading data!");
            }
            FileOutputStream os = new FileOutputStream(ThrottledFetcher.dataFileFolder + this.documentName, true);
            try {
                ((OutputStream)os).write(theBytes, off, length);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    protected static class DataRecorder {
        protected int documentNumber = 0;
        protected long startTime = System.currentTimeMillis();
        protected boolean initialized = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String readFile(File f) throws IOException {
            FileInputStream is = new FileInputStream(f);
            try {
                String string;
                InputStreamReader r = new InputStreamReader(is);
                try {
                    String rval;
                    char[] characterBuf = new char[32];
                    int amt = r.read(characterBuf);
                    string = rval = new String(characterBuf, 0, amt);
                }
                catch (Throwable throwable) {
                    ((Reader)r).close();
                    throw throwable;
                }
                ((Reader)r).close();
                return string;
            }
            finally {
                ((InputStream)is).close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeFile(File f, String data) throws IOException {
            FileOutputStream os = new FileOutputStream(f);
            try {
                OutputStreamWriter w = new OutputStreamWriter(os);
                try {
                    w.write(data);
                }
                finally {
                    ((Writer)w).flush();
                }
            }
            finally {
                ((OutputStream)os).close();
            }
        }

        protected synchronized void initializeParameters() {
            if (this.initialized) {
                return;
            }
            try {
                new File(ThrottledFetcher.dataFileFolder).mkdirs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File timestampFile = new File("/common/rss/timestamp.log");
            if (timestampFile.exists()) {
                try {
                    String data = this.readFile(timestampFile);
                    this.startTime = new Long(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.writeFile(timestampFile, new Long(this.startTime).toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            File documentNumberFile = new File("/common/rss/docnumber.log");
            if (documentNumberFile.exists()) {
                try {
                    String data = this.readFile(documentNumberFile);
                    this.documentNumber = Integer.parseInt(data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.initialized = true;
        }

        public DataSession getSession(String url) throws ManifoldCFException {
            this.initializeParameters();
            return new DataSession(this, url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public synchronized String writeResponseRecord(String url, int responseCode, ArrayList headerNames, ArrayList headerValues) throws ManifoldCFException {
            try {
                FileOutputStream os = new FileOutputStream(ThrottledFetcher.resultLogFile, true);
                try {
                    String string;
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "utf-8");
                    try {
                        String documentName = Integer.toString(this.documentNumber++);
                        writer.write("Time: " + new Long(System.currentTimeMillis() - this.startTime).toString() + "\n");
                        writer.write("URI: " + url + "\n");
                        writer.write("File: " + documentName + "\n");
                        writer.write("Code: " + Integer.toString(responseCode) + "\n");
                        for (int i = 0; i < headerNames.size(); ++i) {
                            writer.write("Header: " + (String)headerNames.get(i) + ":" + (String)headerValues.get(i) + "\n");
                        }
                        this.writeFile(new File("/common/rss/docnumber.log"), new Integer(this.documentNumber).toString());
                        string = documentName;
                    }
                    catch (Throwable throwable) {
                        writer.close();
                        throw throwable;
                    }
                    writer.close();
                    return string;
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                throw new ManifoldCFException("Error recording file info: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

