/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.AVTPart;
import org.apache.xalan.templates.AVTPartSimple;
import org.apache.xalan.templates.AVTPartXPath;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.XSLTVisitable;
import org.apache.xalan.templates.XSLTVisitor;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.xml.sax.SAXException;

public class AVT
implements Serializable,
XSLTVisitable {
    static final long serialVersionUID = 5167607155517042691L;
    private static final boolean USE_OBJECT_POOL = false;
    private static final int INIT_BUFFER_CHUNK_BITS = 8;
    private String m_simpleString = null;
    private Vector m_parts = null;
    private String m_rawName;
    private String m_name;
    private String m_uri;

    public String getRawName() {
        return this.m_rawName;
    }

    public void setRawName(String rawName) {
        this.m_rawName = rawName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getURI() {
        return this.m_uri;
    }

    public void setURI(String uri) {
        this.m_uri = uri;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AVT(StylesheetHandler handler, String uri, String name, String rawName, String stringedValue, ElemTemplateElement owner) throws TransformerException {
        this.m_uri = uri;
        this.m_name = name;
        this.m_rawName = rawName;
        StringTokenizer tokenizer = new StringTokenizer(stringedValue, "{}\"'", true);
        int nTokens = tokenizer.countTokens();
        if (nTokens < 2) {
            this.m_simpleString = stringedValue;
        } else {
            FastStringBuffer buffer = null;
            FastStringBuffer exprBuffer = null;
            buffer = new FastStringBuffer(6);
            exprBuffer = new FastStringBuffer(6);
            try {
                this.m_parts = new Vector(nTokens + 1);
                String t = null;
                String lookahead = null;
                String error = null;
                while (tokenizer.hasMoreTokens()) {
                    if (lookahead != null) {
                        t = lookahead;
                        lookahead = null;
                    } else {
                        t = tokenizer.nextToken();
                    }
                    if (t.length() == 1) {
                        block5 : switch (t.charAt(0)) {
                            case '\"': 
                            case '\'': {
                                buffer.append(t);
                                break;
                            }
                            case '{': {
                                try {
                                    lookahead = tokenizer.nextToken();
                                    if (lookahead.equals("{")) {
                                        buffer.append(lookahead);
                                        lookahead = null;
                                        break;
                                    }
                                    if (buffer.length() > 0) {
                                        this.m_parts.addElement(new AVTPartSimple(buffer.toString()));
                                        buffer.setLength(0);
                                    }
                                    exprBuffer.setLength(0);
                                    block20: while (true) {
                                        if (lookahead == null) {
                                            if (error == null) break block5;
                                        }
                                        if (lookahead.length() == 1) {
                                            switch (lookahead.charAt(0)) {
                                                case '\"': 
                                                case '\'': {
                                                    exprBuffer.append(lookahead);
                                                    String quote = lookahead;
                                                    lookahead = tokenizer.nextToken();
                                                    while (true) {
                                                        if (lookahead.equals(quote)) {
                                                            exprBuffer.append(lookahead);
                                                            lookahead = tokenizer.nextToken();
                                                            continue block20;
                                                        }
                                                        exprBuffer.append(lookahead);
                                                        lookahead = tokenizer.nextToken();
                                                    }
                                                }
                                                case '{': {
                                                    error = XSLMessages.createMessage("ER_NO_CURLYBRACE", null);
                                                    lookahead = null;
                                                    continue block20;
                                                }
                                                case '}': {
                                                    buffer.setLength(0);
                                                    XPath xpath = handler.createXPath(exprBuffer.toString(), owner);
                                                    this.m_parts.addElement(new AVTPartXPath(xpath));
                                                    lookahead = null;
                                                    continue block20;
                                                }
                                            }
                                            exprBuffer.append(lookahead);
                                            lookahead = tokenizer.nextToken();
                                            continue;
                                        }
                                        exprBuffer.append(lookahead);
                                        lookahead = tokenizer.nextToken();
                                    }
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    error = XSLMessages.createMessage("ER_ILLEGAL_ATTRIBUTE_VALUE", new Object[]{name, stringedValue});
                                }
                                break;
                            }
                            case '}': {
                                lookahead = tokenizer.nextToken();
                                if (lookahead.equals("}")) {
                                    buffer.append(lookahead);
                                    lookahead = null;
                                    break;
                                }
                                try {
                                    handler.warn("WG_FOUND_CURLYBRACE", null);
                                }
                                catch (SAXException se) {
                                    throw new TransformerException(se);
                                }
                                buffer.append("}");
                                break;
                            }
                            default: {
                                buffer.append(t);
                                break;
                            }
                        }
                    } else {
                        buffer.append(t);
                    }
                    if (error == null) continue;
                    try {
                        handler.warn("WG_ATTR_TEMPLATE", new Object[]{error});
                        break;
                    }
                    catch (SAXException se) {
                        throw new TransformerException(se);
                    }
                }
                if (buffer.length() > 0) {
                    this.m_parts.addElement(new AVTPartSimple(buffer.toString()));
                    buffer.setLength(0);
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                buffer = null;
                exprBuffer = null;
                throw throwable;
            }
            {
                Object var15_19 = null;
                buffer = null;
                exprBuffer = null;
            }
        }
        if (this.m_parts == null && this.m_simpleString == null) {
            this.m_simpleString = "";
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSimpleString() {
        if (this.m_simpleString != null) {
            return this.m_simpleString;
        }
        if (this.m_parts == null) {
            return "";
        }
        FastStringBuffer buf = this.getBuffer();
        String out = null;
        int n = this.m_parts.size();
        try {
            int i = 0;
            while (true) {
                block6: {
                    if (i < n) break block6;
                    out = buf.toString();
                    break;
                }
                AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                buf.append(part.getSimpleString());
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            buf.setLength(0);
            throw throwable;
        }
        {
            Object var6_8 = null;
            buf.setLength(0);
            return out;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String evaluate(XPathContext xctxt, int context, PrefixResolver nsNode) throws TransformerException {
        if (this.m_simpleString != null) {
            return this.m_simpleString;
        }
        if (this.m_parts == null) {
            return "";
        }
        FastStringBuffer buf = this.getBuffer();
        String out = null;
        int n = this.m_parts.size();
        try {
            int i = 0;
            while (true) {
                block6: {
                    if (i < n) break block6;
                    out = buf.toString();
                    break;
                }
                AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                part.evaluate(xctxt, buf, context, nsNode);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            buf.setLength(0);
            throw throwable;
        }
        {
            Object var9_11 = null;
            buf.setLength(0);
            return out;
        }
    }

    public boolean isContextInsensitive() {
        return this.m_simpleString != null;
    }

    public boolean canTraverseOutsideSubtree() {
        if (this.m_parts != null) {
            int n = this.m_parts.size();
            int i = 0;
            while (i < n) {
                AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                if (part.canTraverseOutsideSubtree()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        if (this.m_parts != null) {
            int n = this.m_parts.size();
            int i = 0;
            while (i < n) {
                AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                part.fixupVariables(vars, globalsSize);
                ++i;
            }
        }
    }

    public void callVisitors(XSLTVisitor visitor) {
        if (visitor.visitAVT(this) && this.m_parts != null) {
            int n = this.m_parts.size();
            int i = 0;
            while (i < n) {
                AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                part.callVisitors(visitor);
                ++i;
            }
        }
    }

    public boolean isSimple() {
        return this.m_simpleString != null;
    }

    private final FastStringBuffer getBuffer() {
        return new FastStringBuffer(8);
    }
}

