/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemUse;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XSLTVisitor;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.utils.StringVector;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.SAXException;

public class ElemLiteralResult
extends ElemUse {
    static final long serialVersionUID = -8703409074421657260L;
    private static final String EMPTYSTRING = "";
    private boolean isLiteralResultAsStylesheet = false;
    private List m_avts = null;
    private List m_xslAttr = null;
    private String m_namespace;
    private String m_localName;
    private String m_rawName;
    private StringVector m_ExtensionElementURIs;
    private String m_version;
    private StringVector m_excludeResultPrefixes;

    public void setIsLiteralResultAsStylesheet(boolean b) {
        this.isLiteralResultAsStylesheet = b;
    }

    public boolean getIsLiteralResultAsStylesheet() {
        return this.isLiteralResultAsStylesheet;
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        super.compose(sroot);
        StylesheetRoot.ComposeState cstate = sroot.getComposeState();
        Vector vnames = cstate.getVariableNames();
        if (this.m_avts != null) {
            int nAttrs = this.m_avts.size();
            int i = nAttrs - 1;
            while (i >= 0) {
                AVT avt = (AVT)this.m_avts.get(i);
                avt.fixupVariables(vnames, cstate.getGlobalsSize());
                --i;
            }
        }
    }

    public void addLiteralResultAttribute(AVT avt) {
        if (this.m_avts == null) {
            this.m_avts = new ArrayList();
        }
        this.m_avts.add(avt);
    }

    public void addLiteralResultAttribute(String att) {
        if (this.m_xslAttr == null) {
            this.m_xslAttr = new ArrayList();
        }
        this.m_xslAttr.add(att);
    }

    public void setXmlSpace(AVT avt) {
        this.addLiteralResultAttribute(avt);
        String val = avt.getSimpleString();
        if (val.equals("default")) {
            super.setXmlSpace(2);
        } else if (val.equals("preserve")) {
            super.setXmlSpace(1);
        }
    }

    public AVT getLiteralResultAttributeNS(String namespaceURI, String localName) {
        if (this.m_avts != null) {
            int nAttrs = this.m_avts.size();
            int i = nAttrs - 1;
            while (i >= 0) {
                AVT avt = (AVT)this.m_avts.get(i);
                if (avt.getName().equals(localName) && avt.getURI().equals(namespaceURI)) {
                    return avt;
                }
                --i;
            }
        }
        return null;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        AVT avt = this.getLiteralResultAttributeNS(namespaceURI, localName);
        if (avt != null) {
            return avt.getSimpleString();
        }
        return EMPTYSTRING;
    }

    public AVT getLiteralResultAttribute(String name) {
        if (this.m_avts != null) {
            int nAttrs = this.m_avts.size();
            String namespace = null;
            int i = nAttrs - 1;
            while (i >= 0) {
                AVT avt = (AVT)this.m_avts.get(i);
                namespace = avt.getURI();
                if (namespace != null && !namespace.equals(EMPTYSTRING) && (String.valueOf(namespace) + ":" + avt.getName()).equals(name) || (namespace == null || namespace.equals(EMPTYSTRING)) && avt.getRawName().equals(name)) {
                    return avt;
                }
                --i;
            }
        }
        return null;
    }

    public String getAttribute(String rawName) {
        AVT avt = this.getLiteralResultAttribute(rawName);
        if (avt != null) {
            return avt.getSimpleString();
        }
        return EMPTYSTRING;
    }

    public boolean containsExcludeResultPrefix(String prefix, String uri) {
        if (uri == null || this.m_excludeResultPrefixes == null && this.m_ExtensionElementURIs == null) {
            return super.containsExcludeResultPrefix(prefix, uri);
        }
        if (prefix.length() == 0) {
            prefix = "#default";
        }
        if (this.m_excludeResultPrefixes != null) {
            int i = 0;
            while (i < this.m_excludeResultPrefixes.size()) {
                if (uri.equals(this.getNamespaceForPrefix(this.m_excludeResultPrefixes.elementAt(i)))) {
                    return true;
                }
                ++i;
            }
        }
        if (this.m_ExtensionElementURIs != null && this.m_ExtensionElementURIs.contains(uri)) {
            return true;
        }
        return super.containsExcludeResultPrefix(prefix, uri);
    }

    public void resolvePrefixTables() throws TransformerException {
        NamespaceAlias nsa;
        super.resolvePrefixTables();
        StylesheetRoot stylesheet = this.getStylesheetRoot();
        if (this.m_namespace != null && this.m_namespace.length() > 0 && (nsa = stylesheet.getNamespaceAliasComposed(this.m_namespace)) != null) {
            this.m_namespace = nsa.getResultNamespace();
            String resultPrefix = nsa.getStylesheetPrefix();
            this.m_rawName = resultPrefix != null && resultPrefix.length() > 0 ? String.valueOf(resultPrefix) + ":" + this.m_localName : this.m_localName;
        }
        if (this.m_avts != null) {
            int n = this.m_avts.size();
            int i = 0;
            while (i < n) {
                NamespaceAlias nsa2;
                AVT avt = (AVT)this.m_avts.get(i);
                String ns = avt.getURI();
                if (ns != null && ns.length() > 0 && (nsa2 = stylesheet.getNamespaceAliasComposed(this.m_namespace)) != null) {
                    String namespace = nsa2.getResultNamespace();
                    String resultPrefix = nsa2.getStylesheetPrefix();
                    String rawName = avt.getName();
                    if (resultPrefix != null && resultPrefix.length() > 0) {
                        rawName = String.valueOf(resultPrefix) + ":" + rawName;
                    }
                    avt.setURI(namespace);
                    avt.setRawName(rawName);
                }
                ++i;
            }
        }
    }

    boolean needToCheckExclude() {
        if (this.m_excludeResultPrefixes == null && this.getPrefixTable() == null && this.m_ExtensionElementURIs == null) {
            return false;
        }
        if (this.getPrefixTable() == null) {
            this.setPrefixTable(new ArrayList());
        }
        return true;
    }

    public void setNamespace(String ns) {
        if (ns == null) {
            ns = EMPTYSTRING;
        }
        this.m_namespace = ns;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public void setLocalName(String localName) {
        this.m_localName = localName;
    }

    public String getLocalName() {
        return this.m_localName;
    }

    public void setRawName(String rawName) {
        this.m_rawName = rawName;
    }

    public String getRawName() {
        return this.m_rawName;
    }

    public String getPrefix() {
        int len = this.m_rawName.length() - this.m_localName.length() - 1;
        return len > 0 ? this.m_rawName.substring(0, len) : EMPTYSTRING;
    }

    public void setExtensionElementPrefixes(StringVector v) {
        this.m_ExtensionElementURIs = v;
    }

    public NamedNodeMap getAttributes() {
        return new LiteralElementAttributes();
    }

    public String getExtensionElementPrefix(int i) throws ArrayIndexOutOfBoundsException {
        if (this.m_ExtensionElementURIs == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.m_ExtensionElementURIs.elementAt(i);
    }

    public int getExtensionElementPrefixCount() {
        return this.m_ExtensionElementURIs != null ? this.m_ExtensionElementURIs.size() : 0;
    }

    public boolean containsExtensionElementURI(String uri) {
        if (this.m_ExtensionElementURIs == null) {
            return false;
        }
        return this.m_ExtensionElementURIs.contains(uri);
    }

    public int getXSLToken() {
        return 77;
    }

    public String getNodeName() {
        return this.m_rawName;
    }

    public void setVersion(String v) {
        this.m_version = v;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setExcludeResultPrefixes(StringVector v) {
        this.m_excludeResultPrefixes = v;
    }

    private boolean excludeResultNSDecl(String prefix, String uri) throws TransformerException {
        if (this.m_excludeResultPrefixes != null) {
            return this.containsExcludeResultPrefix(prefix, uri);
        }
        return false;
    }

    public void execute(TransformerImpl transformer) throws TransformerException {
        SerializationHandler rhandler = transformer.getSerializationHandler();
        try {
            if (transformer.getDebug()) {
                rhandler.flushPending();
                transformer.getTraceManager().fireTraceEvent(this);
            }
            rhandler.startPrefixMapping(this.getPrefix(), this.getNamespace());
            this.executeNSDecls(transformer);
            rhandler.startElement(this.getNamespace(), this.getLocalName(), this.getRawName());
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        TransformerException tException = null;
        try {
            super.execute(transformer);
            if (this.m_avts != null) {
                int nAttrs = this.m_avts.size();
                int i = nAttrs - 1;
                while (i >= 0) {
                    int sourceNode;
                    XPathContext xctxt;
                    AVT avt = (AVT)this.m_avts.get(i);
                    String stringedValue = avt.evaluate(xctxt = transformer.getXPathContext(), sourceNode = xctxt.getCurrentNode(), this);
                    if (stringedValue != null) {
                        rhandler.addAttribute(avt.getURI(), avt.getName(), avt.getRawName(), "CDATA", stringedValue, false);
                    }
                    --i;
                }
            }
            transformer.executeChildTemplates((ElemTemplateElement)this, true);
        }
        catch (TransformerException te) {
            tException = te;
        }
        catch (SAXException se) {
            tException = new TransformerException(se);
        }
        try {
            if (transformer.getDebug()) {
                transformer.getTraceManager().fireTraceEndEvent(this);
            }
            rhandler.endElement(this.getNamespace(), this.getLocalName(), this.getRawName());
        }
        catch (SAXException se) {
            if (tException != null) {
                throw tException;
            }
            throw new TransformerException(se);
        }
        if (tException != null) {
            throw tException;
        }
        this.unexecuteNSDecls(transformer);
        try {
            rhandler.endPrefixMapping(this.getPrefix());
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public Iterator enumerateLiteralResultAttributes() {
        return this.m_avts == null ? null : this.m_avts.iterator();
    }

    protected boolean accept(XSLTVisitor visitor) {
        return visitor.visitLiteralResultElement(this);
    }

    protected void callChildVisitors(XSLTVisitor visitor, boolean callAttrs) {
        if (callAttrs && this.m_avts != null) {
            int nAttrs = this.m_avts.size();
            int i = nAttrs - 1;
            while (i >= 0) {
                AVT avt = (AVT)this.m_avts.get(i);
                avt.callVisitors(visitor);
                --i;
            }
        }
        super.callChildVisitors(visitor, callAttrs);
    }

    public void throwDOMException(short code, String msg) {
        String themsg = XSLMessages.createMessage(msg, null);
        throw new DOMException(code, themsg);
    }

    public class Attribute
    implements Attr {
        private AVT m_attribute;
        private Element m_owner = null;

        public Attribute(AVT avt, Element elem) {
            this.m_attribute = avt;
            this.m_owner = elem;
        }

        public Node appendChild(Node newChild) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
            return null;
        }

        public Node cloneNode(boolean deep) {
            return new Attribute(this.m_attribute, this.m_owner);
        }

        public NamedNodeMap getAttributes() {
            return null;
        }

        public NodeList getChildNodes() {
            return new NodeList(this){
                final /* synthetic */ Attribute this$1;
                {
                    this.this$1 = attribute;
                }

                public int getLength() {
                    return 0;
                }

                public Node item(int index) {
                    return null;
                }
            };
        }

        public Node getFirstChild() {
            return null;
        }

        public Node getLastChild() {
            return null;
        }

        public String getLocalName() {
            return this.m_attribute.getName();
        }

        public String getNamespaceURI() {
            String uri = this.m_attribute.getURI();
            return uri.equals(ElemLiteralResult.EMPTYSTRING) ? null : uri;
        }

        public Node getNextSibling() {
            return null;
        }

        public String getNodeName() {
            String uri = this.m_attribute.getURI();
            String localName = this.getLocalName();
            return uri.equals(ElemLiteralResult.EMPTYSTRING) ? localName : String.valueOf(uri) + ":" + localName;
        }

        public short getNodeType() {
            return 2;
        }

        public String getNodeValue() throws DOMException {
            return this.m_attribute.getSimpleString();
        }

        public Document getOwnerDocument() {
            return this.m_owner.getOwnerDocument();
        }

        public Node getParentNode() {
            return this.m_owner;
        }

        public String getPrefix() {
            String uri = this.m_attribute.getURI();
            String rawName = this.m_attribute.getRawName();
            return uri.equals(ElemLiteralResult.EMPTYSTRING) ? null : rawName.substring(0, rawName.indexOf(":"));
        }

        public Node getPreviousSibling() {
            return null;
        }

        public boolean hasAttributes() {
            return false;
        }

        public boolean hasChildNodes() {
            return false;
        }

        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
            return null;
        }

        public boolean isSupported(String feature, String version) {
            return false;
        }

        public void normalize() {
        }

        public Node removeChild(Node oldChild) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
            return null;
        }

        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
            return null;
        }

        public void setNodeValue(String nodeValue) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
        }

        public void setPrefix(String prefix) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
        }

        public String getName() {
            return this.m_attribute.getName();
        }

        public String getValue() {
            return this.m_attribute.getSimpleString();
        }

        public Element getOwnerElement() {
            return this.m_owner;
        }

        public boolean getSpecified() {
            return true;
        }

        public void setValue(String value) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
        }

        public TypeInfo getSchemaTypeInfo() {
            return null;
        }

        public boolean isId() {
            return false;
        }

        public Object setUserData(String key, Object data, UserDataHandler handler) {
            return this.getOwnerDocument().setUserData(key, data, handler);
        }

        public Object getUserData(String key) {
            return this.getOwnerDocument().getUserData(key);
        }

        public Object getFeature(String feature, String version) {
            return this.isSupported(feature, version) ? this : null;
        }

        public boolean isEqualNode(Node arg) {
            return arg == this;
        }

        public String lookupNamespaceURI(String specifiedPrefix) {
            return null;
        }

        public boolean isDefaultNamespace(String namespaceURI) {
            return false;
        }

        public String lookupPrefix(String namespaceURI) {
            return null;
        }

        public boolean isSameNode(Node other) {
            return this == other;
        }

        public void setTextContent(String textContent) throws DOMException {
            this.setNodeValue(textContent);
        }

        public String getTextContent() throws DOMException {
            return this.getNodeValue();
        }

        public short compareDocumentPosition(Node other) throws DOMException {
            return 0;
        }

        public String getBaseURI() {
            return null;
        }
    }

    public class LiteralElementAttributes
    implements NamedNodeMap {
        private int m_count = -1;

        public int getLength() {
            if (this.m_count == -1) {
                this.m_count = ElemLiteralResult.this.m_avts != null ? ElemLiteralResult.this.m_avts.size() : 0;
            }
            return this.m_count;
        }

        public Node getNamedItem(String name) {
            if (this.getLength() == 0) {
                return null;
            }
            String uri = null;
            String localName = name;
            int index = name.indexOf(":");
            if (-1 != index) {
                uri = name.substring(0, index);
                localName = name.substring(index + 1);
            }
            Attribute retNode = null;
            Iterator eum = ElemLiteralResult.this.m_avts.iterator();
            while (eum.hasNext()) {
                AVT avt = (AVT)eum.next();
                if (!localName.equals(avt.getName())) continue;
                String nsURI = avt.getURI();
                if ((uri != null || nsURI != null) && (uri == null || !uri.equals(nsURI))) continue;
                retNode = new Attribute(avt, ElemLiteralResult.this);
                break;
            }
            return retNode;
        }

        public Node getNamedItemNS(String namespaceURI, String localName) {
            if (this.getLength() == 0) {
                return null;
            }
            Attribute retNode = null;
            Iterator eum = ElemLiteralResult.this.m_avts.iterator();
            while (eum.hasNext()) {
                AVT avt = (AVT)eum.next();
                if (!localName.equals(avt.getName())) continue;
                String nsURI = avt.getURI();
                if ((namespaceURI != null || nsURI != null) && (namespaceURI == null || !namespaceURI.equals(nsURI))) continue;
                retNode = new Attribute(avt, ElemLiteralResult.this);
                break;
            }
            return retNode;
        }

        public Node item(int i) {
            if (this.getLength() == 0 || i >= ElemLiteralResult.this.m_avts.size()) {
                return null;
            }
            return new Attribute((AVT)ElemLiteralResult.this.m_avts.get(i), ElemLiteralResult.this);
        }

        public Node removeNamedItem(String name) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
            return null;
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
            return null;
        }

        public Node setNamedItem(Node arg) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
            return null;
        }

        public Node setNamedItemNS(Node arg) throws DOMException {
            ElemLiteralResult.this.throwDOMException((short)7, "NO_MODIFICATION_ALLOWED_ERR");
            return null;
        }
    }
}

