/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.WrappedRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class TransformerIdentityImpl
extends Transformer
implements TransformerHandler,
DeclHandler {
    boolean m_flushedStartDoc = false;
    private FileOutputStream m_outputStream = null;
    private ContentHandler m_resultContentHandler;
    private LexicalHandler m_resultLexicalHandler;
    private DTDHandler m_resultDTDHandler;
    private DeclHandler m_resultDeclHandler;
    private Serializer m_serializer;
    private Result m_result;
    private String m_systemID;
    private Hashtable m_params;
    private ErrorListener m_errorListener = new DefaultErrorHandler(false);
    URIResolver m_URIResolver;
    private OutputProperties m_outputFormat = new OutputProperties("xml");
    boolean m_foundFirstElement;
    private boolean m_isSecureProcessing = false;

    public TransformerIdentityImpl(boolean isSecureProcessing) {
        this.m_isSecureProcessing = isSecureProcessing;
    }

    public TransformerIdentityImpl() {
        this(false);
    }

    public void setResult(Result result) throws IllegalArgumentException {
        if (result == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_RESULT_NULL", null));
        }
        this.m_result = result;
    }

    public void setSystemId(String systemID) {
        this.m_systemID = systemID;
    }

    public String getSystemId() {
        return this.m_systemID;
    }

    public Transformer getTransformer() {
        return this;
    }

    public void reset() {
        this.m_flushedStartDoc = false;
        this.m_foundFirstElement = false;
        this.m_outputStream = null;
        this.clearParameters();
        this.m_result = null;
        this.m_resultContentHandler = null;
        this.m_resultDeclHandler = null;
        this.m_resultDTDHandler = null;
        this.m_resultLexicalHandler = null;
        this.m_serializer = null;
        this.m_systemID = null;
        this.m_URIResolver = null;
        this.m_outputFormat = new OutputProperties("xml");
    }

    private void createResultContentHandler(Result outputTarget) throws TransformerException {
        if (outputTarget instanceof SAXResult) {
            SAXResult saxResult = (SAXResult)outputTarget;
            this.m_resultContentHandler = saxResult.getHandler();
            this.m_resultLexicalHandler = saxResult.getLexicalHandler();
            if (this.m_resultContentHandler instanceof Serializer) {
                this.m_serializer = (Serializer)((Object)this.m_resultContentHandler);
            }
        } else if (outputTarget instanceof DOMResult) {
            DOMBuilder domBuilder;
            Document doc;
            short type;
            DOMResult domResult = (DOMResult)outputTarget;
            Node outputNode = domResult.getNode();
            Node nextSibling = domResult.getNextSibling();
            if (outputNode != null) {
                type = outputNode.getNodeType();
                doc = 9 == type ? (Document)outputNode : outputNode.getOwnerDocument();
            } else {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    if (this.m_isSecureProcessing) {
                        try {
                            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        }
                        catch (ParserConfigurationException parserConfigurationException) {}
                    }
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    doc = db.newDocument();
                }
                catch (ParserConfigurationException pce) {
                    throw new TransformerException(pce);
                }
                outputNode = doc;
                type = outputNode.getNodeType();
                ((DOMResult)outputTarget).setNode(outputNode);
            }
            DOMBuilder dOMBuilder = domBuilder = 11 == type ? new DOMBuilder(doc, (DocumentFragment)outputNode) : new DOMBuilder(doc, outputNode);
            if (nextSibling != null) {
                domBuilder.setNextSibling(nextSibling);
            }
            this.m_resultContentHandler = domBuilder;
            this.m_resultLexicalHandler = domBuilder;
        } else if (outputTarget instanceof StreamResult) {
            StreamResult sresult = (StreamResult)outputTarget;
            try {
                Serializer serializer;
                this.m_serializer = serializer = SerializerFactory.getSerializer(this.m_outputFormat.getProperties());
                if (sresult.getWriter() != null) {
                    serializer.setWriter(sresult.getWriter());
                } else if (sresult.getOutputStream() != null) {
                    serializer.setOutputStream(sresult.getOutputStream());
                } else if (sresult.getSystemId() != null) {
                    String fileURL = sresult.getSystemId();
                    if (fileURL.startsWith("file:///")) {
                        fileURL = fileURL.substring(8).indexOf(":") > 0 ? fileURL.substring(8) : fileURL.substring(7);
                    } else if (fileURL.startsWith("file:/")) {
                        fileURL = fileURL.substring(6).indexOf(":") > 0 ? fileURL.substring(6) : fileURL.substring(5);
                    }
                    this.m_outputStream = new FileOutputStream(fileURL);
                    serializer.setOutputStream(this.m_outputStream);
                } else {
                    throw new TransformerException(XSLMessages.createMessage("ER_NO_OUTPUT_SPECIFIED", null));
                }
                this.m_resultContentHandler = serializer.asContentHandler();
            }
            catch (IOException ioe) {
                throw new TransformerException(ioe);
            }
        } else {
            throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_TRANSFORM_TO_RESULT_TYPE", new Object[]{outputTarget.getClass().getName()}));
        }
        if (this.m_resultContentHandler instanceof DTDHandler) {
            this.m_resultDTDHandler = (DTDHandler)((Object)this.m_resultContentHandler);
        }
        if (this.m_resultContentHandler instanceof DeclHandler) {
            this.m_resultDeclHandler = (DeclHandler)((Object)this.m_resultContentHandler);
        }
        if (this.m_resultContentHandler instanceof LexicalHandler) {
            this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
        }
    }

    /*
     * Exception decompiling
     */
    public void transform(Source source, Result outputTarget) throws TransformerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [2 : 282->288)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setParameter(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_INVALID_SET_PARAM_VALUE", new Object[]{name}));
        }
        if (this.m_params == null) {
            this.m_params = new Hashtable();
        }
        this.m_params.put(name, value);
    }

    public Object getParameter(String name) {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.get(name);
    }

    public void clearParameters() {
        if (this.m_params == null) {
            return;
        }
        this.m_params.clear();
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_URIResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.m_URIResolver;
    }

    public void setOutputProperties(Properties oformat) throws IllegalArgumentException {
        if (oformat != null) {
            String method = (String)oformat.get("method");
            this.m_outputFormat = method != null ? new OutputProperties(method) : new OutputProperties();
            this.m_outputFormat.copyFrom(oformat);
        } else {
            this.m_outputFormat = null;
        }
    }

    public Properties getOutputProperties() {
        return (Properties)this.m_outputFormat.getProperties().clone();
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        if (!OutputProperties.isLegalPropertyKey(name)) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{name}));
        }
        this.m_outputFormat.setProperty(name, value);
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.m_outputFormat;
        value = props.getProperty(name);
        if (value == null && !OutputProperties.isLegalPropertyKey(name)) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{name}));
        }
        return value;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_NULL_ERROR_HANDLER", null));
        }
        this.m_errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.m_resultDTDHandler != null) {
            this.m_resultDTDHandler.notationDecl(name, publicId, systemId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.m_resultDTDHandler != null) {
            this.m_resultDTDHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    public void setDocumentLocator(Locator locator) {
        try {
            if (this.m_resultContentHandler == null) {
                this.createResultContentHandler(this.m_result);
            }
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
        this.m_resultContentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        try {
            if (this.m_resultContentHandler == null) {
                this.createResultContentHandler(this.m_result);
            }
        }
        catch (TransformerException te) {
            throw new SAXException(te.getMessage(), te);
        }
        this.m_flushedStartDoc = false;
        this.m_foundFirstElement = false;
    }

    protected final void flushStartDoc() throws SAXException {
        if (!this.m_flushedStartDoc) {
            if (this.m_resultContentHandler == null) {
                try {
                    this.createResultContentHandler(this.m_result);
                }
                catch (TransformerException te) {
                    throw new SAXException(te);
                }
            }
            this.m_resultContentHandler.startDocument();
            this.m_flushedStartDoc = true;
        }
    }

    public void endDocument() throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.m_foundFirstElement && this.m_serializer != null) {
            Serializer newSerializer;
            this.m_foundFirstElement = true;
            try {
                newSerializer = SerializerSwitcher.switchSerializerIfHTML(uri, localName, this.m_outputFormat.getProperties(), this.m_serializer);
            }
            catch (TransformerException te) {
                throw new SAXException(te);
            }
            if (newSerializer != this.m_serializer) {
                try {
                    this.m_resultContentHandler = newSerializer.asContentHandler();
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
                if (this.m_resultContentHandler instanceof DTDHandler) {
                    this.m_resultDTDHandler = (DTDHandler)((Object)this.m_resultContentHandler);
                }
                if (this.m_resultContentHandler instanceof LexicalHandler) {
                    this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
                }
                this.m_serializer = newSerializer;
            }
        }
        this.flushStartDoc();
        this.m_resultContentHandler.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.m_resultContentHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.m_resultContentHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.flushStartDoc();
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushStartDoc();
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.comment(ch, start, length);
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.m_resultDeclHandler != null) {
            this.m_resultDeclHandler.elementDecl(name, model);
        }
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        if (this.m_resultDeclHandler != null) {
            this.m_resultDeclHandler.attributeDecl(eName, aName, type, valueDefault, value);
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.m_resultDeclHandler != null) {
            this.m_resultDeclHandler.internalEntityDecl(name, value);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.m_resultDeclHandler != null) {
            this.m_resultDeclHandler.externalEntityDecl(name, publicId, systemId);
        }
    }
}

