/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xalan.xsltc.dom.SecuritySupport;

class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xalan.properties";
    private static final String SERVICES_PATH = "META-INF/services/";
    private static final boolean DEBUG = false;
    private static Properties fXalanProperties = null;
    private static long fLastModified = -1L;
    static /* synthetic */ Class class$0;

    ObjectFactory() {
    }

    static Object createObject(String factoryId, String fallbackClassName) throws ConfigurationError {
        return ObjectFactory.createObject(factoryId, null, fallbackClassName);
    }

    static Object createObject(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        Class factoryClass = ObjectFactory.lookUpFactoryClass(factoryId, propertiesFilename, fallbackClassName);
        if (factoryClass == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        try {
            Object instance = factoryClass.newInstance();
            ObjectFactory.debugPrintln("created new instance of factory " + factoryId);
            return instance;
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider for factory " + factoryId + " could not be instantiated: " + x, x);
        }
    }

    static Class lookUpFactoryClass(String factoryId) throws ConfigurationError {
        return ObjectFactory.lookUpFactoryClass(factoryId, null, null);
    }

    static Class lookUpFactoryClass(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        String factoryClassName = ObjectFactory.lookUpFactoryClassName(factoryId, propertiesFilename, fallbackClassName);
        ClassLoader cl = ObjectFactory.findClassLoader();
        if (factoryClassName == null) {
            factoryClassName = fallbackClassName;
        }
        try {
            Class providerClass = ObjectFactory.findProviderClass(factoryClassName, cl, true);
            ObjectFactory.debugPrintln("created new instance of " + providerClass + " using ClassLoader: " + cl);
            return providerClass;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + factoryClassName + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + factoryClassName + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static String lookUpFactoryClassName(String factoryId, String propertiesFilename, String fallbackClassName) {
        String factoryClassName;
        block36: {
            SecuritySupport ss;
            block37: {
                block35: {
                    Class<?> clazz;
                    ss = SecuritySupport.getInstance();
                    try {
                        String systemProp = ss.getSystemProperty(factoryId);
                        if (systemProp != null) {
                            ObjectFactory.debugPrintln("found system property, value=" + systemProp);
                            return systemProp;
                        }
                    }
                    catch (SecurityException securityException) {}
                    factoryClassName = null;
                    if (propertiesFilename != null) break block37;
                    File propertiesFile = null;
                    boolean propertiesFileExists = false;
                    try {
                        String javah = ss.getSystemProperty("java.home");
                        propertiesFilename = String.valueOf(javah) + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
                        propertiesFile = new File(propertiesFilename);
                        propertiesFileExists = ss.getFileExists(propertiesFile);
                    }
                    catch (SecurityException securityException) {
                        fLastModified = -1L;
                        fXalanProperties = null;
                    }
                    if ((clazz = class$0) == null) {
                        try {
                            clazz = class$0 = Class.forName("org.apache.xalan.xsltc.dom.ObjectFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class<?> clazz2 = clazz;
                    // MONITORENTER : clazz
                    boolean loadProperties = false;
                    FileInputStream fis = null;
                    try {
                        try {
                            block39: {
                                block38: {
                                    if (fLastModified < 0L) break block38;
                                    if (propertiesFileExists && fLastModified < (fLastModified = ss.getLastModified(propertiesFile))) {
                                        loadProperties = true;
                                        break block39;
                                    } else if (!propertiesFileExists) {
                                        fLastModified = -1L;
                                        fXalanProperties = null;
                                    }
                                    break block39;
                                }
                                if (propertiesFileExists) {
                                    loadProperties = true;
                                    fLastModified = ss.getLastModified(propertiesFile);
                                }
                            }
                            if (loadProperties) {
                                fXalanProperties = new Properties();
                                fis = ss.getFileInputStream(propertiesFile);
                                fXalanProperties.load(fis);
                            }
                        }
                        catch (Exception exception) {
                            fXalanProperties = null;
                            fLastModified = -1L;
                        }
                        Object var10_17 = null;
                        if (fis == null) break block35;
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        if (fis == null) throw throwable;
                        try {
                            fis.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    fis.close();
                }
                // MONITOREXIT : clazz2
                if (fXalanProperties != null) {
                    factoryClassName = fXalanProperties.getProperty(factoryId);
                }
                break block36;
            }
            FileInputStream fis = null;
            try {
                try {
                    fis = ss.getFileInputStream(new File(propertiesFilename));
                    Properties props = new Properties();
                    props.load(fis);
                    factoryClassName = props.getProperty(factoryId);
                }
                catch (Exception exception) {}
                Object var7_11 = null;
                if (fis == null) break block36;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            fis.close();
        }
        if (factoryClassName == null) return ObjectFactory.findJarServiceProviderName(factoryId);
        ObjectFactory.debugPrintln("found in " + propertiesFilename + ", value=" + factoryClassName);
        return factoryClassName;
    }

    private static void debugPrintln(String msg) {
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader system;
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader context = ss.getContextClassLoader();
        ClassLoader chain = system = ss.getSystemClassLoader();
        while (true) {
            if (context == chain) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.apache.xalan.xsltc.dom.ObjectFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ClassLoader current = clazz.getClassLoader();
                chain = system;
                while (true) {
                    if (current == chain) {
                        return system;
                    }
                    if (chain == null) break;
                    chain = ss.getParentClassLoader(chain);
                }
                return current;
            }
            if (chain == null) break;
            chain = ss.getParentClassLoader(chain);
        }
        return context;
    }

    static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class providerClass = ObjectFactory.findProviderClass(className, cl, doFallback);
            Object instance = providerClass.newInstance();
            ObjectFactory.debugPrintln("created new instance of " + providerClass + " using ClassLoader: " + cl);
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Class findProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException, ConfigurationError {
        Class<?> providerClass;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            int lastDot = className.lastIndexOf(".");
            String packageName = className;
            if (lastDot != -1) {
                packageName = className.substring(0, lastDot);
            }
            security.checkPackageAccess(packageName);
        }
        if (cl == null) {
            providerClass = Class.forName(className);
        } else {
            try {
                providerClass = cl.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                if (doFallback) {
                    ClassLoader current;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.apache.xalan.xsltc.dom.ObjectFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((current = clazz.getClassLoader()) == null) {
                        providerClass = Class.forName(className);
                    }
                    if (cl != current) {
                        cl = current;
                        providerClass = cl.loadClass(className);
                    }
                    throw x;
                }
                throw x;
            }
        }
        return providerClass;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findJarServiceProviderName(String factoryId) {
        BufferedReader rd;
        SecuritySupport ss = SecuritySupport.getInstance();
        String serviceId = SERVICES_PATH + factoryId;
        InputStream is = null;
        ClassLoader cl = ObjectFactory.findClassLoader();
        is = ss.getResourceAsStream(cl, serviceId);
        if (is == null) {
            ClassLoader current;
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.apache.xalan.xsltc.dom.ObjectFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            if (cl != (current = clazz.getClassLoader())) {
                cl = current;
                is = ss.getResourceAsStream(cl, serviceId);
            }
        }
        if (is == null) {
            return null;
        }
        ObjectFactory.debugPrintln("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            rd = new BufferedReader(new InputStreamReader(is));
        }
        String factoryClassName = null;
        try {
            try {
                factoryClassName = rd.readLine();
            }
            catch (IOException iOException) {
                Object var7_7 = null;
                try {
                    rd.close();
                    return null;
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {}
            catch (IOException iOException) {}
            rd.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {}
        rd.close();
        if (factoryClassName == null) return null;
        if ("".equals(factoryClassName)) return null;
        ObjectFactory.debugPrintln("found in resource, value=" + factoryClassName);
        return factoryClassName;
    }

    static class ConfigurationError
    extends Error {
        static final long serialVersionUID = -5948733402959678002L;
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

