/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public class StepPattern
extends NodeTest
implements SubContextList,
ExpressionOwner {
    static final long serialVersionUID = 9071668960168152644L;
    protected int m_axis;
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int whatToShow, String namespace, String name, int axis, int axisForPredicate) {
        super(whatToShow, namespace, name);
        this.m_axis = axis;
    }

    public StepPattern(int whatToShow, int axis, int axisForPredicate) {
        super(whatToShow);
        this.m_axis = axis;
    }

    public void calcTargetString() {
        int whatToShow = this.getWhatToShow();
        switch (whatToShow) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if ("*" == this.m_name) {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        if (this.m_predicates != null) {
            int i = 0;
            while (i < this.m_predicates.length) {
                this.m_predicates[i].fixupVariables(vars, globalsSize);
                ++i;
            }
        }
        if (this.m_relativePathPattern != null) {
            this.m_relativePathPattern.fixupVariables(vars, globalsSize);
        }
    }

    public void setRelativePathPattern(StepPattern expr) {
        this.m_relativePathPattern = expr;
        expr.exprSetParent(this);
        this.calcScore();
    }

    public StepPattern getRelativePathPattern() {
        return this.m_relativePathPattern;
    }

    public Expression[] getPredicates() {
        return this.m_predicates;
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int i = 0;
        while (i < n) {
            if (this.getPredicate(i).canTraverseOutsideSubtree()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Expression getPredicate(int i) {
        return this.m_predicates[i];
    }

    public final int getPredicateCount() {
        return this.m_predicates == null ? 0 : this.m_predicates.length;
    }

    public void setPredicates(Expression[] predicates) {
        this.m_predicates = predicates;
        if (predicates != null) {
            int i = 0;
            while (i < predicates.length) {
                predicates[i].exprSetParent(this);
                ++i;
            }
        }
        this.calcScore();
    }

    public void calcScore() {
        if (this.getPredicateCount() > 0 || this.m_relativePathPattern != null) {
            this.m_score = SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (this.m_targetString == null) {
            this.calcTargetString();
        }
    }

    public XObject execute(XPathContext xctxt, int currentNode) throws TransformerException {
        DTM dtm = xctxt.getDTM(currentNode);
        if (dtm != null) {
            int expType = dtm.getExpandedTypeID(currentNode);
            return this.execute(xctxt, currentNode, dtm, expType);
        }
        return NodeTest.SCORE_NONE;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt, xctxt.getCurrentNode());
    }

    public XObject execute(XPathContext xctxt, int currentNode, DTM dtm, int expType) throws TransformerException {
        if (this.m_whatToShow == 65536) {
            if (this.m_relativePathPattern != null) {
                return this.m_relativePathPattern.execute(xctxt);
            }
            return NodeTest.SCORE_NONE;
        }
        XObject score = super.execute(xctxt, currentNode, dtm, expType);
        if (score == NodeTest.SCORE_NONE) {
            return NodeTest.SCORE_NONE;
        }
        if (this.getPredicateCount() != 0 && !this.executePredicates(xctxt, dtm, currentNode)) {
            return NodeTest.SCORE_NONE;
        }
        if (this.m_relativePathPattern != null) {
            return this.m_relativePathPattern.executeRelativePathPattern(xctxt, dtm, currentNode);
        }
        return score;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkProximityPosition(XPathContext xctxt, int predPos, DTM dtm, int context, int pos) {
        try {
            DTMAxisTraverser traverser = dtm.getAxisTraverser(12);
            int child = traverser.first(context);
            while (-1 != child) {
                Object var17_15;
                try {
                    block20: {
                        xctxt.pushCurrentNode(child);
                        if (NodeTest.SCORE_NONE != super.execute(xctxt, child)) {
                            Object var15_14;
                            boolean pass = true;
                            try {
                                xctxt.pushSubContextList(this);
                                int i = 0;
                                while (i < predPos) {
                                    Object var13_13;
                                    xctxt.pushPredicatePos(i);
                                    try {
                                        Object var11_12;
                                        XObject pred;
                                        block19: {
                                            pred = this.m_predicates[i].execute(xctxt);
                                            try {
                                                if (2 == pred.getType()) {
                                                    throw new Error("Why: Should never have been called");
                                                }
                                                if (pred.boolWithSideEffects()) break block19;
                                                pass = false;
                                                var11_12 = null;
                                                pred.detach();
                                            }
                                            catch (Throwable throwable) {
                                                var11_12 = null;
                                                pred.detach();
                                                throw throwable;
                                            }
                                            var13_13 = null;
                                            xctxt.popPredicatePos();
                                            break;
                                        }
                                        var11_12 = null;
                                        pred.detach();
                                        var13_13 = null;
                                        xctxt.popPredicatePos();
                                        ++i;
                                    }
                                    catch (Throwable throwable) {
                                        var13_13 = null;
                                        xctxt.popPredicatePos();
                                        throw throwable;
                                    }
                                }
                                var15_14 = null;
                                xctxt.popSubContextList();
                                if (pass) {
                                    --pos;
                                }
                                if (pos >= 1) break block20;
                            }
                            catch (Throwable throwable) {
                                var15_14 = null;
                                xctxt.popSubContextList();
                                throw throwable;
                            }
                            var17_15 = null;
                            xctxt.popCurrentNode();
                            return false;
                        }
                    }
                    var17_15 = null;
                    xctxt.popCurrentNode();
                    child = traverser.next(context, child);
                }
                catch (Throwable throwable) {
                    var17_15 = null;
                    xctxt.popCurrentNode();
                    throw throwable;
                    return pos == 1;
                }
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getProximityPosition(XPathContext xctxt, int predPos, boolean findLast) {
        int pos = 0;
        int context = xctxt.getCurrentNode();
        DTM dtm = xctxt.getDTM(context);
        int parent = dtm.getParent(context);
        try {
            DTMAxisTraverser traverser = dtm.getAxisTraverser(3);
            int child = traverser.first(parent);
            while (-1 != child) {
                Object var19_17;
                try {
                    block22: {
                        xctxt.pushCurrentNode(child);
                        if (NodeTest.SCORE_NONE != super.execute(xctxt, child)) {
                            int n;
                            Object var17_16;
                            boolean pass = true;
                            try {
                                xctxt.pushSubContextList(this);
                                int i = 0;
                                while (i < predPos) {
                                    Object var15_15;
                                    xctxt.pushPredicatePos(i);
                                    try {
                                        Object var13_14;
                                        XObject pred;
                                        block21: {
                                            pred = this.m_predicates[i].execute(xctxt);
                                            try {
                                                if (2 == pred.getType()) {
                                                    if (pos + 1 == (int)pred.numWithSideEffects()) break block21;
                                                    pass = false;
                                                } else {
                                                    if (pred.boolWithSideEffects()) break block21;
                                                    pass = false;
                                                }
                                                var13_14 = null;
                                                pred.detach();
                                            }
                                            catch (Throwable throwable) {
                                                var13_14 = null;
                                                pred.detach();
                                                throw throwable;
                                            }
                                            var15_15 = null;
                                            xctxt.popPredicatePos();
                                            break;
                                        }
                                        var13_14 = null;
                                        pred.detach();
                                        var15_15 = null;
                                        xctxt.popPredicatePos();
                                        ++i;
                                    }
                                    catch (Throwable throwable) {
                                        var15_15 = null;
                                        xctxt.popPredicatePos();
                                        throw throwable;
                                    }
                                }
                                var17_16 = null;
                                xctxt.popSubContextList();
                                if (pass) {
                                    ++pos;
                                }
                                if (findLast || child != context) break block22;
                                n = pos;
                            }
                            catch (Throwable throwable) {
                                var17_16 = null;
                                xctxt.popSubContextList();
                                throw throwable;
                            }
                            var19_17 = null;
                            xctxt.popCurrentNode();
                            return n;
                        }
                    }
                    var19_17 = null;
                    xctxt.popCurrentNode();
                    child = traverser.next(parent, child);
                }
                catch (Throwable throwable) {
                    var19_17 = null;
                    xctxt.popCurrentNode();
                    throw throwable;
                }
            }
            return pos;
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public int getProximityPosition(XPathContext xctxt) {
        return this.getProximityPosition(xctxt, xctxt.getPredicatePos(), false);
    }

    public int getLastPos(XPathContext xctxt) {
        return this.getProximityPosition(xctxt, xctxt.getPredicatePos(), true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final XObject executeRelativePathPattern(XPathContext xctxt, DTM dtm, int currentNode) throws TransformerException {
        XObject score = NodeTest.SCORE_NONE;
        int context = currentNode;
        DTMAxisTraverser traverser = dtm.getAxisTraverser(this.m_axis);
        int relative = traverser.first(context);
        while (-1 != relative) {
            Object var8_8;
            try {
                xctxt.pushCurrentNode(relative);
                score = this.execute(xctxt);
                if (score != NodeTest.SCORE_NONE) {
                    var8_8 = null;
                    xctxt.popCurrentNode();
                    return score;
                }
            }
            catch (Throwable throwable) {
                var8_8 = null;
                xctxt.popCurrentNode();
                throw throwable;
            }
            {
                var8_8 = null;
                xctxt.popCurrentNode();
                relative = traverser.next(context, relative);
                continue;
            }
            break;
        }
        return score;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean executePredicates(XPathContext xctxt, DTM dtm, int currentNode) throws TransformerException {
        boolean result = true;
        boolean positionAlreadySeen = false;
        int n = this.getPredicateCount();
        try {
            xctxt.pushSubContextList(this);
            int i = 0;
            while (i < n) {
                Object var12_11;
                xctxt.pushPredicatePos(i);
                try {
                    Object var10_10;
                    XObject pred;
                    block13: {
                        pred = this.m_predicates[i].execute(xctxt);
                        try {
                            block15: {
                                block14: {
                                    if (2 != pred.getType()) break block14;
                                    int pos = (int)pred.num();
                                    if (positionAlreadySeen) {
                                        result = pos == 1;
                                        break block15;
                                    } else {
                                        positionAlreadySeen = true;
                                        if (this.checkProximityPosition(xctxt, i, dtm, currentNode, pos)) break block13;
                                        result = false;
                                    }
                                    break block15;
                                }
                                if (pred.boolWithSideEffects()) break block13;
                                result = false;
                            }
                            var10_10 = null;
                            pred.detach();
                        }
                        catch (Throwable throwable) {
                            var10_10 = null;
                            pred.detach();
                            throw throwable;
                        }
                        var12_11 = null;
                        xctxt.popPredicatePos();
                        break;
                    }
                    var10_10 = null;
                    pred.detach();
                    var12_11 = null;
                    xctxt.popPredicatePos();
                    ++i;
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    xctxt.popPredicatePos();
                    throw throwable;
                }
            }
            Object var14_16 = null;
            xctxt.popSubContextList();
            return result;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            xctxt.popSubContextList();
            throw throwable;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        StepPattern pat = this;
        while (pat != null) {
            if (pat != this) {
                buf.append("/");
            }
            buf.append(Axis.getNames(pat.m_axis));
            buf.append("::");
            if (20480 == pat.m_whatToShow) {
                buf.append("doc()");
            } else if (65536 == pat.m_whatToShow) {
                buf.append("function()");
            } else if (-1 == pat.m_whatToShow) {
                buf.append("node()");
            } else if (4 == pat.m_whatToShow) {
                buf.append("text()");
            } else if (64 == pat.m_whatToShow) {
                buf.append("processing-instruction(");
                if (pat.m_name != null) {
                    buf.append(pat.m_name);
                }
                buf.append(")");
            } else if (128 == pat.m_whatToShow) {
                buf.append("comment()");
            } else if (pat.m_name != null) {
                if (2 == pat.m_whatToShow) {
                    buf.append("@");
                }
                if (pat.m_namespace != null) {
                    buf.append("{");
                    buf.append(pat.m_namespace);
                    buf.append("}");
                }
                buf.append(pat.m_name);
            } else if (2 == pat.m_whatToShow) {
                buf.append("@");
            } else if (1280 == pat.m_whatToShow) {
                buf.append("doc-root()");
            } else {
                buf.append("?" + Integer.toHexString(pat.m_whatToShow));
            }
            if (pat.m_predicates != null) {
                int i = 0;
                while (i < pat.m_predicates.length) {
                    buf.append("[");
                    buf.append(pat.m_predicates[i]);
                    buf.append("]");
                    ++i;
                }
            }
            pat = pat.m_relativePathPattern;
        }
        return buf.toString();
    }

    public double getMatchScore(XPathContext xctxt, int context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.execute(xctxt);
            double d = score.num();
            Object var4_5 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public void setAxis(int axis) {
        this.m_axis = axis;
    }

    public int getAxis() {
        return this.m_axis;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        if (visitor.visitMatchPattern(owner, this)) {
            this.callSubtreeVisitors(visitor);
        }
    }

    protected void callSubtreeVisitors(XPathVisitor visitor) {
        if (this.m_predicates != null) {
            int n = this.m_predicates.length;
            int i = 0;
            while (i < n) {
                PredOwner predOwner = new PredOwner(i);
                if (visitor.visitPredicate(predOwner, this.m_predicates[i])) {
                    this.m_predicates[i].callVisitors(predOwner, visitor);
                }
                ++i;
            }
        }
        if (this.m_relativePathPattern != null) {
            this.m_relativePathPattern.callVisitors(this, visitor);
        }
    }

    public Expression getExpression() {
        return this.m_relativePathPattern;
    }

    public void setExpression(Expression exp) {
        exp.exprSetParent(this);
        this.m_relativePathPattern = (StepPattern)exp;
    }

    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        StepPattern sp = (StepPattern)expr;
        if (this.m_predicates != null) {
            int n = this.m_predicates.length;
            if (sp.m_predicates == null || sp.m_predicates.length != n) {
                return false;
            }
            int i = 0;
            while (i < n) {
                if (!this.m_predicates[i].deepEquals(sp.m_predicates[i])) {
                    return false;
                }
                ++i;
            }
        } else if (sp.m_predicates != null) {
            return false;
        }
        return !(this.m_relativePathPattern != null ? !this.m_relativePathPattern.deepEquals(sp.m_relativePathPattern) : sp.m_relativePathPattern != null);
    }

    class PredOwner
    implements ExpressionOwner {
        int m_index;

        PredOwner(int index) {
            this.m_index = index;
        }

        public Expression getExpression() {
            return StepPattern.this.m_predicates[this.m_index];
        }

        public void setExpression(Expression exp) {
            exp.exprSetParent(StepPattern.this);
            StepPattern.this.m_predicates[this.m_index] = exp;
        }
    }
}

