/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.opic;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.scoring.ScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPICScoringFilter
implements ScoringFilter {
    private static final Logger LOG = LoggerFactory.getLogger(OPICScoringFilter.class);
    private Configuration conf;
    private float scoreInjected;
    private float scorePower;
    private float internalScoreFactor;
    private float externalScoreFactor;
    private boolean countFiltered;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.scorePower = conf.getFloat("indexer.score.power", 0.5f);
        this.internalScoreFactor = conf.getFloat("db.score.link.internal", 1.0f);
        this.externalScoreFactor = conf.getFloat("db.score.link.external", 1.0f);
        this.countFiltered = conf.getBoolean("db.score.count.filtered", false);
    }

    public void injectedScore(Text url, CrawlDatum datum) throws ScoringFilterException {
    }

    public void initialScore(Text url, CrawlDatum datum) throws ScoringFilterException {
        datum.setScore(0.0f);
    }

    public float generatorSortValue(Text url, CrawlDatum datum, float initSort) throws ScoringFilterException {
        return datum.getScore() * initSort;
    }

    public void updateDbScore(Text url, CrawlDatum old, CrawlDatum datum, List<CrawlDatum> inlinked) throws ScoringFilterException {
        float adjust = 0.0f;
        for (int i = 0; i < inlinked.size(); ++i) {
            CrawlDatum linked = inlinked.get(i);
            adjust += linked.getScore();
        }
        if (old == null) {
            old = datum;
        }
        datum.setScore(old.getScore() + adjust);
    }

    public void passScoreBeforeParsing(Text url, CrawlDatum datum, Content content) {
        content.getMetadata().set("nutch.crawl.score", "" + datum.getScore());
    }

    public void passScoreAfterParsing(Text url, Content content, Parse parse) {
        parse.getData().getContentMeta().set("nutch.crawl.score", content.getMetadata().get("nutch.crawl.score"));
    }

    public CrawlDatum distributeScoreToOutlinks(Text fromUrl, ParseData parseData, Collection<Map.Entry<Text, CrawlDatum>> targets, CrawlDatum adjust, int allCount) throws ScoringFilterException {
        float score = this.scoreInjected;
        String scoreString = parseData.getContentMeta().get("nutch.crawl.score");
        if (scoreString != null) {
            try {
                score = Float.parseFloat(scoreString);
            }
            catch (Exception e) {
                LOG.error("Error: ", (Throwable)e);
            }
        }
        int validCount = targets.size();
        if (this.countFiltered) {
            score /= (float)allCount;
        } else {
            if (validCount == 0) {
                return adjust;
            }
            score /= (float)validCount;
        }
        float internalScore = score * this.internalScoreFactor;
        float externalScore = score * this.externalScoreFactor;
        for (Map.Entry<Text, CrawlDatum> target : targets) {
            try {
                String toHost = new URL(target.getKey().toString()).getHost();
                String fromHost = new URL(fromUrl.toString()).getHost();
                if (toHost.equalsIgnoreCase(fromHost)) {
                    target.getValue().setScore(internalScore);
                    continue;
                }
                target.getValue().setScore(externalScore);
            }
            catch (MalformedURLException e) {
                LOG.error("Error: ", (Throwable)e);
                target.getValue().setScore(externalScore);
            }
        }
        return adjust;
    }

    public float indexerScore(Text url, NutchDocument doc, CrawlDatum dbDatum, CrawlDatum fetchDatum, Parse parse, Inlinks inlinks, float initScore) throws ScoringFilterException {
        return (float)Math.pow(dbDatum.getScore(), this.scorePower) * initScore;
    }
}

