/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import javax.xml.datatype.SecuritySupport;

final class FactoryFinder {
    private static final String CLASS_NAME = "javax.xml.datatype.FactoryFinder";
    private static boolean debug = false;
    private static Properties cacheProps = new Properties();
    private static boolean firstTime = true;
    private static final int DEFAULT_LINE_LENGTH = 80;
    static /* synthetic */ Class class$0;

    static {
        try {
            String string = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (Exception exception) {
            debug = false;
        }
    }

    private FactoryFinder() {
    }

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("javax.xml.datatype.FactoryFinder:" + string);
        }
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        if (debug) {
            FactoryFinder.debugPrintln("Using context class loader: " + classLoader);
        }
        if (classLoader == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName(CLASS_NAME);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classLoader = clazz.getClassLoader();
            if (debug) {
                FactoryFinder.debugPrintln("Using the class loader of FactoryFinder: " + classLoader);
            }
        }
        return classLoader;
    }

    private static Object newInstance(String string, ClassLoader classLoader) throws ConfigurationError {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            if (debug) {
                FactoryFinder.debugPrintln("Loaded " + string + " from " + FactoryFinder.which(clazz));
            }
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String string, String string2) throws ConfigurationError {
        Object object;
        ClassLoader classLoader;
        block18: {
            classLoader = FactoryFinder.findClassLoader();
            try {
                object = SecuritySupport.getSystemProperty(string);
                if (object != null) {
                    if (debug) {
                        FactoryFinder.debugPrintln("found " + (String)object + " in the system property " + string);
                    }
                    return FactoryFinder.newInstance((String)object, classLoader);
                }
            }
            catch (SecurityException securityException) {}
            try {
                object = SecuritySupport.getSystemProperty("java.home");
                String string3 = String.valueOf(object) + File.separator + "lib" + File.separator + "jaxp.properties";
                String string4 = null;
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File file = new File(string3);
                            firstTime = false;
                            if (SecuritySupport.doesFileExist(file)) {
                                if (debug) {
                                    FactoryFinder.debugPrintln("Read properties file " + file);
                                }
                                cacheProps.load(SecuritySupport.getFileInputStream(file));
                            }
                        }
                    }
                }
                string4 = cacheProps.getProperty(string);
                if (debug) {
                    FactoryFinder.debugPrintln("found " + string4 + " in $java.home/jaxp.properties");
                }
                if (string4 != null) {
                    return FactoryFinder.newInstance(string4, classLoader);
                }
            }
            catch (Exception exception) {
                if (!debug) break block18;
                exception.printStackTrace();
            }
        }
        if ((object = FactoryFinder.findJarServiceProvider(string)) != null) {
            return object;
        }
        if (string2 == null) {
            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        if (debug) {
            FactoryFinder.debugPrintln("loaded from fallback value: " + string2);
        }
        return FactoryFinder.newInstance(string2, classLoader);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        BufferedReader bufferedReader;
        ClassLoader classLoader;
        InputStream inputStream;
        String string2;
        block21: {
            block20: {
                string2 = "META-INF/services/" + string;
                inputStream = null;
                classLoader = SecuritySupport.getContextClassLoader();
                if (classLoader == null) break block20;
                inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
                if (inputStream == null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName(CLASS_NAME);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    classLoader = clazz.getClassLoader();
                    inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
                }
                break block21;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName(CLASS_NAME);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz3;
            }
            classLoader = clazz.getClassLoader();
            inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        if (debug) {
            FactoryFinder.debugPrintln("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 80);
        }
        String string3 = null;
        try {
            try {
                string3 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                Object var6_6 = null;
                try {
                    bufferedReader.close();
                    return null;
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {}
            catch (IOException iOException) {}
            bufferedReader.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        if (string3 == null) return null;
        if ("".equals(string3)) return null;
        if (!debug) return FactoryFinder.newInstance(string3, classLoader);
        FactoryFinder.debugPrintln("found in resource, value=" + string3);
        return FactoryFinder.newInstance(string3, classLoader);
    }

    private static String which(Class clazz) {
        block3: {
            try {
                String string = String.valueOf(clazz.getName().replace('.', '/')) + ".class";
                ClassLoader classLoader = clazz.getClassLoader();
                URL uRL = classLoader != null ? classLoader.getResource(string) : ClassLoader.getSystemResource(string);
                if (uRL != null) {
                    return uRL.toString();
                }
            }
            catch (Throwable throwable) {
                if (!debug) break block3;
                throwable.printStackTrace();
            }
        }
        return "unknown location";
    }

    static class ConfigurationError
    extends Error {
        private static final long serialVersionUID = -3644413026244211347L;
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

