/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.NewInstance;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.SecuritySupport;

public final class XMLReaderFactory {
    private static final String property = "org.xml.sax.driver";
    private static final int DEFAULT_LINE_LENGTH = 80;
    static /* synthetic */ Class class$0;

    private XMLReaderFactory() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XMLReader createXMLReader() throws SAXException {
        ClassLoader classLoader;
        String string;
        block24: {
            InputStream inputStream;
            block26: {
                ClassLoader classLoader2;
                String string2;
                SecuritySupport securitySupport;
                block25: {
                    string = null;
                    securitySupport = SecuritySupport.getInstance();
                    classLoader = NewInstance.getClassLoader();
                    try {
                        string = securitySupport.getSystemProperty(property);
                    }
                    catch (Exception exception) {}
                    if (string != null) break block24;
                    string2 = "META-INF/services/org.xml.sax.driver";
                    inputStream = null;
                    classLoader2 = securitySupport.getContextClassLoader();
                    if (classLoader2 == null) break block25;
                    inputStream = securitySupport.getResourceAsStream(classLoader2, string2);
                    if (inputStream == null) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            Class<?> clazz2;
                            try {
                                clazz2 = Class.forName("org.xml.sax.helpers.XMLReaderFactory");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$0 = clazz2;
                        }
                        classLoader2 = clazz.getClassLoader();
                        inputStream = securitySupport.getResourceAsStream(classLoader2, string2);
                    }
                    break block26;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.xml.sax.helpers.XMLReaderFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz3;
                }
                classLoader2 = clazz.getClassLoader();
                inputStream = securitySupport.getResourceAsStream(classLoader2, string2);
            }
            if (inputStream != null) {
                BufferedReader bufferedReader;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 80);
                }
                try {
                    try {
                        string = bufferedReader.readLine();
                    }
                    catch (Exception exception) {}
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        bufferedReader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var7_9 = null;
                }
                try {}
                catch (IOException iOException) {}
                bufferedReader.close();
            }
        }
        if (string == null) {
            string = "org.apache.xerces.parsers.SAXParser";
        }
        if (string != null) {
            return XMLReaderFactory.loadClass(classLoader, string);
        }
        try {
            return new ParserAdapter(ParserFactory.makeParser());
        }
        catch (Exception exception) {
            throw new SAXException("Can't create default XMLReader; is system property org.xml.sax.driver set?");
        }
    }

    public static XMLReader createXMLReader(String string) throws SAXException {
        return XMLReaderFactory.loadClass(NewInstance.getClassLoader(), string);
    }

    private static XMLReader loadClass(ClassLoader classLoader, String string) throws SAXException {
        try {
            return (XMLReader)NewInstance.newInstance(classLoader, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException("SAX2 driver class " + string + " not found", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException("SAX2 driver class " + string + " found but cannot be loaded", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException("SAX2 driver class " + string + " loaded but cannot be instantiated (no empty public constructor?)", instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException("SAX2 driver class " + string + " does not implement XMLReader", classCastException);
        }
    }
}

