/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.file;

import crawlercommons.robots.BaseRobotRules;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.Protocol;
import org.apache.nutch.protocol.ProtocolOutput;
import org.apache.nutch.protocol.ProtocolStatus;
import org.apache.nutch.protocol.RobotRulesParser;
import org.apache.nutch.protocol.file.FileError;
import org.apache.nutch.protocol.file.FileException;
import org.apache.nutch.protocol.file.FileResponse;
import org.apache.nutch.util.NutchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class File
implements Protocol {
    public static final Logger LOG = LoggerFactory.getLogger(File.class);
    static final int MAX_REDIRECTS = 5;
    int maxContentLength;
    boolean crawlParents;
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.maxContentLength = conf.getInt("file.content.limit", 65536);
        this.crawlParents = conf.getBoolean("file.crawl.parent", true);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public ProtocolOutput getProtocolOutput(Text url, CrawlDatum datum) {
        String urlString = url.toString();
        try {
            int code;
            URL u = new URL(urlString);
            int redirects = 0;
            while (true) {
                FileResponse response;
                if ((code = (response = new FileResponse(u, datum, this, this.getConf())).getCode()) == 200) {
                    return new ProtocolOutput(response.toContent());
                }
                if (code == 304) {
                    return new ProtocolOutput(response.toContent(), ProtocolStatus.STATUS_NOTMODIFIED);
                }
                if (code == 401) {
                    return new ProtocolOutput(response.toContent(), new ProtocolStatus(17));
                }
                if (code == 404) {
                    return new ProtocolOutput(response.toContent(), ProtocolStatus.STATUS_NOTFOUND);
                }
                if (code < 300 || code >= 400) break;
                if (redirects == 5) {
                    throw new FileException("Too many redirects: " + url);
                }
                u = new URL(response.getHeader("Location"));
                ++redirects;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("redirect to " + u);
            }
            throw new FileError(code);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ProtocolOutput(null, new ProtocolStatus((Throwable)e));
        }
    }

    public static void main(String[] args) throws Exception {
        int maxContentLength = Integer.MIN_VALUE;
        String logLevel = "info";
        boolean dumpContent = false;
        String urlString = null;
        String usage = "Usage: File [-logLevel level] [-maxContentLength L] [-dumpContent] url";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-logLevel")) {
                logLevel = args[++i];
                continue;
            }
            if (args[i].equals("-maxContentLength")) {
                maxContentLength = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-dumpContent")) {
                dumpContent = true;
                continue;
            }
            if (i != args.length - 1) {
                System.err.println(usage);
                System.exit(-1);
                continue;
            }
            urlString = args[i];
        }
        File file = new File();
        file.setConf(NutchConfiguration.create());
        if (maxContentLength != Integer.MIN_VALUE) {
            file.setMaxContentLength(maxContentLength);
        }
        Content content = file.getProtocolOutput(new Text(urlString), new CrawlDatum()).getContent();
        System.err.println("Content-Type: " + content.getContentType());
        System.err.println("Content-Length: " + content.getMetadata().get("Content-Length"));
        System.err.println("Last-Modified: " + content.getMetadata().get("Last-Modified"));
        if (dumpContent) {
            System.out.print(new String(content.getContent()));
        }
        file = null;
    }

    public BaseRobotRules getRobotRules(Text url, CrawlDatum datum) {
        return RobotRulesParser.EMPTY_RULES;
    }
}

