/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.metadata.SpellCheckedMetadata;
import org.apache.nutch.net.protocols.HttpDateFormat;
import org.apache.nutch.net.protocols.Response;
import org.apache.nutch.protocol.httpclient.Http;

public class HttpResponse
implements Response {
    private URL url;
    private byte[] content;
    private int code;
    private Metadata headers = new SpellCheckedMetadata();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpResponse(Http http, URL url, CrawlDatum datum, boolean followRedirects) throws IOException {
        this.url = url;
        GetMethod get = new GetMethod(url.toString());
        get.setFollowRedirects(followRedirects);
        get.setDoAuthentication(true);
        if (datum.getModifiedTime() > 0L) {
            get.setRequestHeader("If-Modified-Since", HttpDateFormat.toString((long)datum.getModifiedTime()));
        }
        HttpMethodParams params = get.getParams();
        if (http.getUseHttp11()) {
            params.setVersion(HttpVersion.HTTP_1_1);
        } else {
            params.setVersion(HttpVersion.HTTP_1_0);
        }
        params.makeLenient();
        params.setContentCharset("UTF-8");
        params.setCookiePolicy("compatibility");
        params.setBooleanParameter("http.protocol.single-cookie-header", true);
        try {
            this.code = Http.getClient().executeMethod((HttpMethod)get);
            Header[] heads = get.getResponseHeaders();
            for (int i = 0; i < heads.length; ++i) {
                this.headers.set(heads[i].getName(), heads[i].getValue());
            }
            int contentLength = Integer.MAX_VALUE;
            String contentLengthString = this.headers.get("Content-Length");
            if (contentLengthString != null) {
                try {
                    contentLength = Integer.parseInt(contentLengthString.trim());
                }
                catch (NumberFormatException ex) {
                    throw new HttpException("bad content length: " + contentLengthString);
                }
            }
            if (http.getMaxContent() >= 0 && contentLength > http.getMaxContent()) {
                contentLength = http.getMaxContent();
            }
            InputStream in = get.getResponseBodyAsStream();
            try {
                byte[] buffer = new byte[8192];
                int bufferFilled = 0;
                int totalRead = 0;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((bufferFilled = in.read(buffer, 0, buffer.length)) != -1 && totalRead + bufferFilled <= contentLength) {
                    totalRead += bufferFilled;
                    out.write(buffer, 0, bufferFilled);
                }
                this.content = out.toByteArray();
            }
            catch (Exception e) {
                if (this.code == 200) {
                    throw new IOException(e.toString());
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                get.abort();
            }
            StringBuilder fetchTrace = null;
            if (Http.LOG.isTraceEnabled()) {
                fetchTrace = new StringBuilder("url: " + url + "; status code: " + this.code + "; bytes received: " + this.content.length);
                if (this.getHeader("Content-Length") != null) {
                    fetchTrace.append("; Content-Length: " + this.getHeader("Content-Length"));
                }
                if (this.getHeader("Location") != null) {
                    fetchTrace.append("; Location: " + this.getHeader("Location"));
                }
            }
            if (this.content != null) {
                String contentEncoding = this.headers.get("Content-Encoding");
                if (contentEncoding != null && Http.LOG.isTraceEnabled()) {
                    fetchTrace.append("; Content-Encoding: " + contentEncoding);
                }
                if ("gzip".equals(contentEncoding) || "x-gzip".equals(contentEncoding)) {
                    this.content = http.processGzipEncoded(this.content, url);
                    if (Http.LOG.isTraceEnabled()) {
                        fetchTrace.append("; extracted to " + this.content.length + " bytes");
                    }
                } else if ("deflate".equals(contentEncoding)) {
                    this.content = http.processDeflateEncoded(this.content, url);
                    if (Http.LOG.isTraceEnabled()) {
                        fetchTrace.append("; extracted to " + this.content.length + " bytes");
                    }
                }
            }
            if (Http.LOG.isTraceEnabled()) {
                Http.LOG.trace(fetchTrace.toString());
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public int getCode() {
        return this.code;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Metadata getHeaders() {
        return this.headers;
    }

    public byte[] getContent() {
        return this.content;
    }
}

