/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.AbstractFetchSchedule;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Nutch;
import org.apache.nutch.util.NutchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveFetchSchedule
extends AbstractFetchSchedule {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractFetchSchedule.class);
    protected float INC_RATE;
    protected float DEC_RATE;
    private int MAX_INTERVAL;
    private int MIN_INTERVAL;
    private boolean SYNC_DELTA;
    private double SYNC_DELTA_RATE;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.INC_RATE = conf.getFloat("db.fetch.schedule.adaptive.inc_rate", 0.2f);
        this.DEC_RATE = conf.getFloat("db.fetch.schedule.adaptive.dec_rate", 0.2f);
        this.MIN_INTERVAL = conf.getInt("db.fetch.schedule.adaptive.min_interval", 60);
        this.MAX_INTERVAL = conf.getInt("db.fetch.schedule.adaptive.max_interval", 31536000);
        this.SYNC_DELTA = conf.getBoolean("db.fetch.schedule.adaptive.sync_delta", true);
        this.SYNC_DELTA_RATE = conf.getFloat("db.fetch.schedule.adaptive.sync_delta_rate", 0.2f);
    }

    @Override
    public CrawlDatum setFetchSchedule(Text url, CrawlDatum datum, long prevFetchTime, long prevModifiedTime, long fetchTime, long modifiedTime, int state) {
        super.setFetchSchedule(url, datum, prevFetchTime, prevModifiedTime, fetchTime, modifiedTime, state);
        float interval = datum.getFetchInterval();
        long refTime = fetchTime;
        float f = interval = interval == 0.0f ? (float)this.defaultInterval : interval;
        if (datum.getMetaData().containsKey((Object)Nutch.WRITABLE_FIXED_INTERVAL_KEY)) {
            FloatWritable customIntervalWritable = (FloatWritable)datum.getMetaData().get((Object)Nutch.WRITABLE_FIXED_INTERVAL_KEY);
            interval = customIntervalWritable.get();
        } else {
            if (modifiedTime <= 0L) {
                modifiedTime = fetchTime;
            }
            switch (state) {
                case 1: {
                    interval *= 1.0f - this.DEC_RATE;
                    break;
                }
                case 2: {
                    interval *= 1.0f + this.INC_RATE;
                    break;
                }
            }
            if (this.SYNC_DELTA) {
                long delta = (fetchTime - modifiedTime) / 1000L;
                if ((float)delta > interval) {
                    interval = delta;
                }
                refTime = fetchTime - Math.round((double)delta * this.SYNC_DELTA_RATE * 1000.0);
            }
            if (interval < (float)this.MIN_INTERVAL) {
                interval = this.MIN_INTERVAL;
            } else if (interval > (float)this.MAX_INTERVAL) {
                interval = this.MAX_INTERVAL;
            }
        }
        datum.setFetchInterval(interval);
        datum.setFetchTime(refTime + Math.round((double)interval * 1000.0));
        datum.setModifiedTime(modifiedTime);
        return datum;
    }

    public static void main(String[] args) throws Exception {
        AdaptiveFetchSchedule fs = new AdaptiveFetchSchedule();
        fs.setConf(NutchConfiguration.create());
        long curTime = 0L;
        long delta = 86400000L;
        long update = 2592000000L;
        boolean changed = true;
        long lastModified = 0L;
        int miss = 0;
        int totalMiss = 0;
        int maxMiss = 0;
        int fetchCnt = 0;
        int changeCnt = 0;
        CrawlDatum p = new CrawlDatum(1, 2592000, 1.0f);
        p.setFetchTime(0L);
        LOG.info(p.toString());
        for (int i = 0; i < 10000; ++i) {
            if (lastModified + update < curTime) {
                changed = true;
                ++changeCnt;
                lastModified = curTime;
            }
            LOG.info(i + ". " + changed + "\twill fetch at " + p.getFetchTime() / delta + "\tinterval " + p.getFetchInterval() / 86400 + " days" + "\t missed " + miss);
            if (p.getFetchTime() <= curTime) {
                ++fetchCnt;
                fs.setFetchSchedule(new Text("http://www.example.com"), p, p.getFetchTime(), p.getModifiedTime(), curTime, lastModified, changed ? 1 : 2);
                LOG.info("\tfetched & adjusted: \twill fetch at " + p.getFetchTime() / delta + "\tinterval " + p.getFetchInterval() / 86400 + " days");
                if (!changed) {
                    ++miss;
                }
                if (miss > maxMiss) {
                    maxMiss = miss;
                }
                changed = false;
                totalMiss += miss;
                miss = 0;
            }
            if (changed) {
                ++miss;
            }
            curTime += delta;
        }
        LOG.info("Total missed: " + totalMiss + ", max miss: " + maxMiss);
        LOG.info("Page changed " + changeCnt + " times, fetched " + fetchCnt + " times.");
    }
}

