/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.CrawlDbFilter;
import org.apache.nutch.crawl.CrawlDbReducer;
import org.apache.nutch.util.HadoopFSUtil;
import org.apache.nutch.util.LockUtil;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TimingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlDb
extends Configured
implements Tool {
    public static final Logger LOG = LoggerFactory.getLogger(CrawlDb.class);
    public static final String CRAWLDB_ADDITIONS_ALLOWED = "db.update.additions.allowed";
    public static final String CRAWLDB_PURGE_404 = "db.update.purge.404";
    public static final String CURRENT_NAME = "current";
    public static final String LOCK_NAME = ".locked";

    public CrawlDb() {
    }

    public CrawlDb(Configuration conf) {
        this.setConf(conf);
    }

    public void update(Path crawlDb, Path[] segments, boolean normalize, boolean filter) throws IOException {
        boolean additionsAllowed = this.getConf().getBoolean(CRAWLDB_ADDITIONS_ALLOWED, true);
        this.update(crawlDb, segments, normalize, filter, additionsAllowed, false);
    }

    public void update(Path crawlDb, Path[] segments, boolean normalize, boolean filter, boolean additionsAllowed, boolean force) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        Path lock = new Path(crawlDb, LOCK_NAME);
        LockUtil.createLockFile(fs, lock, force);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long start = System.currentTimeMillis();
        JobConf job = CrawlDb.createJob(this.getConf(), crawlDb);
        job.setBoolean(CRAWLDB_ADDITIONS_ALLOWED, additionsAllowed);
        job.setBoolean("crawldb.url.filters", filter);
        job.setBoolean("crawldb.url.normalizers", normalize);
        boolean url404Purging = job.getBoolean(CRAWLDB_PURGE_404, false);
        if (LOG.isInfoEnabled()) {
            LOG.info("CrawlDb update: starting at " + sdf.format(start));
            LOG.info("CrawlDb update: db: " + crawlDb);
            LOG.info("CrawlDb update: segments: " + Arrays.asList(segments));
            LOG.info("CrawlDb update: additions allowed: " + additionsAllowed);
            LOG.info("CrawlDb update: URL normalizing: " + normalize);
            LOG.info("CrawlDb update: URL filtering: " + filter);
            LOG.info("CrawlDb update: 404 purging: " + url404Purging);
        }
        for (int i = 0; i < segments.length; ++i) {
            Path fetch = new Path(segments[i], "crawl_fetch");
            Path parse = new Path(segments[i], "crawl_parse");
            if (fs.exists(fetch) && fs.exists(parse)) {
                FileInputFormat.addInputPath((JobConf)job, (Path)fetch);
                FileInputFormat.addInputPath((JobConf)job, (Path)parse);
                continue;
            }
            LOG.info(" - skipping invalid segment " + segments[i]);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("CrawlDb update: Merging segment data into db.");
        }
        try {
            JobClient.runJob((JobConf)job);
        }
        catch (IOException e) {
            LockUtil.removeLockFile(fs, lock);
            Path outPath = FileOutputFormat.getOutputPath((JobConf)job);
            if (fs.exists(outPath)) {
                fs.delete(outPath, true);
            }
            throw e;
        }
        CrawlDb.install(job, crawlDb);
        long end = System.currentTimeMillis();
        LOG.info("CrawlDb update: finished at " + sdf.format(end) + ", elapsed: " + TimingUtil.elapsedTime(start, end));
    }

    public static JobConf createJob(Configuration config, Path crawlDb) throws IOException {
        Path newCrawlDb = new Path(crawlDb, Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
        NutchJob job = new NutchJob(config);
        job.setJobName("crawldb " + crawlDb);
        Path current = new Path(crawlDb, CURRENT_NAME);
        if (FileSystem.get((Configuration)job).exists(current)) {
            FileInputFormat.addInputPath((JobConf)job, (Path)current);
        }
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(CrawlDbFilter.class);
        job.setReducerClass(CrawlDbReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)newCrawlDb);
        job.setOutputFormat(MapFileOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(CrawlDatum.class);
        job.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
        return job;
    }

    public static void install(JobConf job, Path crawlDb) throws IOException {
        boolean preserveBackup = job.getBoolean("db.preserve.backup", true);
        Path newCrawlDb = FileOutputFormat.getOutputPath((JobConf)job);
        FileSystem fs = new JobClient(job).getFs();
        Path old = new Path(crawlDb, "old");
        Path current = new Path(crawlDb, CURRENT_NAME);
        if (fs.exists(current)) {
            if (fs.exists(old)) {
                fs.delete(old, true);
            }
            fs.rename(current, old);
        }
        fs.mkdirs(crawlDb);
        fs.rename(newCrawlDb, current);
        if (!preserveBackup && fs.exists(old)) {
            fs.delete(old, true);
        }
        Path lock = new Path(crawlDb, LOCK_NAME);
        LockUtil.removeLockFile(fs, lock);
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new CrawlDb(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: CrawlDb <crawldb> (-dir <segments> | <seg1> <seg2> ...) [-force] [-normalize] [-filter] [-noAdditions]");
            System.err.println("\tcrawldb\tCrawlDb to update");
            System.err.println("\t-dir segments\tparent directory containing all segments to update from");
            System.err.println("\tseg1 seg2 ...\tlist of segment names to update from");
            System.err.println("\t-force\tforce update even if CrawlDb appears to be locked (CAUTION advised)");
            System.err.println("\t-normalize\tuse URLNormalizer on urls in CrawlDb and segment (usually not needed)");
            System.err.println("\t-filter\tuse URLFilters on urls in CrawlDb and segment");
            System.err.println("\t-noAdditions\tonly update already existing URLs, don't add any newly discovered URLs");
            return -1;
        }
        boolean normalize = false;
        boolean filter = false;
        boolean force = false;
        boolean url404Purging = false;
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        boolean additionsAllowed = this.getConf().getBoolean(CRAWLDB_ADDITIONS_ALLOWED, true);
        HashSet<Path> dirs = new HashSet<Path>();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-normalize")) {
                normalize = true;
                continue;
            }
            if (args[i].equals("-filter")) {
                filter = true;
                continue;
            }
            if (args[i].equals("-force")) {
                force = true;
                continue;
            }
            if (args[i].equals("-noAdditions")) {
                additionsAllowed = false;
                continue;
            }
            if (args[i].equals("-dir")) {
                FileStatus[] paths = fs.listStatus(new Path(args[++i]), HadoopFSUtil.getPassDirectoriesFilter(fs));
                dirs.addAll(Arrays.asList(HadoopFSUtil.getPaths(paths)));
                continue;
            }
            dirs.add(new Path(args[i]));
        }
        try {
            this.update(new Path(args[0]), dirs.toArray(new Path[dirs.size()]), normalize, filter, additionsAllowed, force);
            return 0;
        }
        catch (Exception e) {
            LOG.error("CrawlDb update: " + StringUtils.stringifyException((Throwable)e));
            return -1;
        }
    }
}

