/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.CrawlDbFilter;
import org.apache.nutch.crawl.FetchSchedule;
import org.apache.nutch.crawl.FetchScheduleFactory;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TimingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlDbMerger
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(CrawlDbMerger.class);

    public CrawlDbMerger() {
    }

    public CrawlDbMerger(Configuration conf) {
        this.setConf(conf);
    }

    public void merge(Path output, Path[] dbs, boolean normalize, boolean filter) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long start = System.currentTimeMillis();
        LOG.info("CrawlDb merge: starting at " + sdf.format(start));
        JobConf job = CrawlDbMerger.createMergeJob(this.getConf(), output, normalize, filter);
        for (int i = 0; i < dbs.length; ++i) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Adding " + dbs[i]);
            }
            FileInputFormat.addInputPath((JobConf)job, (Path)new Path(dbs[i], "current"));
        }
        JobClient.runJob((JobConf)job);
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        if (fs.exists(output)) {
            fs.delete(output, true);
        }
        fs.mkdirs(output);
        fs.rename(FileOutputFormat.getOutputPath((JobConf)job), new Path(output, "current"));
        long end = System.currentTimeMillis();
        LOG.info("CrawlDb merge: finished at " + sdf.format(end) + ", elapsed: " + TimingUtil.elapsedTime(start, end));
    }

    public static JobConf createMergeJob(Configuration conf, Path output, boolean normalize, boolean filter) {
        Path newCrawlDb = new Path("crawldb-merge-" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
        NutchJob job = new NutchJob(conf);
        job.setJobName("crawldb merge " + output);
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(CrawlDbFilter.class);
        job.setBoolean("crawldb.url.filters", filter);
        job.setBoolean("crawldb.url.normalizers", normalize);
        job.setReducerClass(Merger.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)newCrawlDb);
        job.setOutputFormat(MapFileOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(CrawlDatum.class);
        return job;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new CrawlDbMerger(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: CrawlDbMerger <output_crawldb> <crawldb1> [<crawldb2> <crawldb3> ...] [-normalize] [-filter]");
            System.err.println("\toutput_crawldb\toutput CrawlDb");
            System.err.println("\tcrawldb1 ...\tinput CrawlDb-s (single input CrawlDb is ok)");
            System.err.println("\t-normalize\tuse URLNormalizer on urls in the crawldb(s) (usually not needed)");
            System.err.println("\t-filter\tuse URLFilters on urls in the crawldb(s)");
            return -1;
        }
        Path output = new Path(args[0]);
        ArrayList<Path> dbs = new ArrayList<Path>();
        boolean filter = false;
        boolean normalize = false;
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-filter")) {
                filter = true;
                continue;
            }
            if (args[i].equals("-normalize")) {
                normalize = true;
                continue;
            }
            Path dbPath = new Path(args[i]);
            if (!fs.exists(dbPath)) continue;
            dbs.add(dbPath);
        }
        try {
            this.merge(output, dbs.toArray(new Path[dbs.size()]), normalize, filter);
            return 0;
        }
        catch (Exception e) {
            LOG.error("CrawlDb merge: " + StringUtils.stringifyException((Throwable)e));
            return -1;
        }
    }

    public static class Merger
    extends MapReduceBase
    implements Reducer<Text, CrawlDatum, Text, CrawlDatum> {
        private MapWritable meta;
        private CrawlDatum res = new CrawlDatum();
        private FetchSchedule schedule;

        public void close() throws IOException {
        }

        public void configure(JobConf conf) {
            this.schedule = FetchScheduleFactory.getFetchSchedule((Configuration)conf);
        }

        public void reduce(Text key, Iterator<CrawlDatum> values, OutputCollector<Text, CrawlDatum> output, Reporter reporter) throws IOException {
            long resTime = 0L;
            boolean resSet = false;
            this.meta = new MapWritable();
            while (values.hasNext()) {
                CrawlDatum val = values.next();
                if (!resSet) {
                    this.res.set(val);
                    resSet = true;
                    resTime = this.schedule.calculateLastFetchTime(this.res);
                    for (Map.Entry e : this.res.getMetaData().entrySet()) {
                        this.meta.put((Writable)e.getKey(), (Writable)e.getValue());
                    }
                    continue;
                }
                long valTime = this.schedule.calculateLastFetchTime(val);
                if (valTime > resTime) {
                    for (Map.Entry e : val.getMetaData().entrySet()) {
                        this.meta.put((Writable)e.getKey(), (Writable)e.getValue());
                    }
                    this.res.set(val);
                    resTime = valTime;
                    continue;
                }
                for (Map.Entry e : this.meta.entrySet()) {
                    val.getMetaData().put((Writable)e.getKey(), (Writable)e.getValue());
                }
                this.meta = val.getMetaData();
            }
            this.res.setMetaData(this.meta);
            output.collect((Object)key, (Object)this.res);
        }
    }
}

