/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.Inlink;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.crawl.LinkDbFilter;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TimingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkDbMerger
extends Configured
implements Tool,
Reducer<Text, Inlinks, Text, Inlinks> {
    private static final Logger LOG = LoggerFactory.getLogger(LinkDbMerger.class);
    private int maxInlinks;

    public LinkDbMerger() {
    }

    public LinkDbMerger(Configuration conf) {
        this.setConf(conf);
    }

    public void reduce(Text key, Iterator<Inlinks> values, OutputCollector<Text, Inlinks> output, Reporter reporter) throws IOException {
        Inlinks result = new Inlinks();
        while (values.hasNext()) {
            Inlinks inlinks = values.next();
            int end = Math.min(this.maxInlinks - result.size(), inlinks.size());
            Iterator<Inlink> it = inlinks.iterator();
            int i = 0;
            while (it.hasNext() && i++ < end) {
                result.add(it.next());
            }
        }
        if (result.size() == 0) {
            return;
        }
        output.collect((Object)key, (Object)result);
    }

    public void configure(JobConf job) {
        this.maxInlinks = job.getInt("db.max.inlinks", 10000);
    }

    public void close() throws IOException {
    }

    public void merge(Path output, Path[] dbs, boolean normalize, boolean filter) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long start = System.currentTimeMillis();
        LOG.info("LinkDb merge: starting at " + sdf.format(start));
        JobConf job = LinkDbMerger.createMergeJob(this.getConf(), output, normalize, filter);
        for (int i = 0; i < dbs.length; ++i) {
            FileInputFormat.addInputPath((JobConf)job, (Path)new Path(dbs[i], "current"));
        }
        JobClient.runJob((JobConf)job);
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        fs.mkdirs(output);
        fs.rename(FileOutputFormat.getOutputPath((JobConf)job), new Path(output, "current"));
        long end = System.currentTimeMillis();
        LOG.info("LinkDb merge: finished at " + sdf.format(end) + ", elapsed: " + TimingUtil.elapsedTime(start, end));
    }

    public static JobConf createMergeJob(Configuration config, Path linkDb, boolean normalize, boolean filter) {
        Path newLinkDb = new Path("linkdb-merge-" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
        NutchJob job = new NutchJob(config);
        job.setJobName("linkdb merge " + linkDb);
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(LinkDbFilter.class);
        job.setBoolean("linkdb.url.normalizer", normalize);
        job.setBoolean("linkdb.url.filters", filter);
        job.setReducerClass(LinkDbMerger.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)newLinkDb);
        job.setOutputFormat(MapFileOutputFormat.class);
        job.setBoolean("mapred.output.compress", true);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Inlinks.class);
        job.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
        return job;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new LinkDbMerger(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: LinkDbMerger <output_linkdb> <linkdb1> [<linkdb2> <linkdb3> ...] [-normalize] [-filter]");
            System.err.println("\toutput_linkdb\toutput LinkDb");
            System.err.println("\tlinkdb1 ...\tinput LinkDb-s (single input LinkDb is ok)");
            System.err.println("\t-normalize\tuse URLNormalizer on both fromUrls and toUrls in linkdb(s) (usually not needed)");
            System.err.println("\t-filter\tuse URLFilters on both fromUrls and toUrls in linkdb(s)");
            return -1;
        }
        Path output = new Path(args[0]);
        ArrayList<Path> dbs = new ArrayList<Path>();
        boolean normalize = false;
        boolean filter = false;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-filter")) {
                filter = true;
                continue;
            }
            if (args[i].equals("-normalize")) {
                normalize = true;
                continue;
            }
            dbs.add(new Path(args[i]));
        }
        try {
            this.merge(output, dbs.toArray(new Path[dbs.size()]), normalize, filter);
            return 0;
        }
        catch (Exception e) {
            LOG.error("LinkDbMerger: " + StringUtils.stringifyException((Throwable)e));
            return -1;
        }
    }
}

