/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.Closeable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.Inlink;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TimingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkDbReader
extends Configured
implements Tool,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(LinkDbReader.class);
    private static final Partitioner<WritableComparable<?>, Writable> PARTITIONER = new HashPartitioner();
    private FileSystem fs;
    private Path directory;
    private MapFile.Reader[] readers;

    public LinkDbReader() {
    }

    public LinkDbReader(Configuration conf, Path directory) throws Exception {
        this.setConf(conf);
        this.init(directory);
    }

    public void init(Path directory) throws Exception {
        this.fs = FileSystem.get((Configuration)this.getConf());
        this.directory = directory;
    }

    public String[] getAnchors(Text url) throws IOException {
        Inlinks inlinks = this.getInlinks(url);
        if (inlinks == null) {
            return null;
        }
        return inlinks.getAnchors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inlinks getInlinks(Text url) throws IOException {
        if (this.readers == null) {
            LinkDbReader linkDbReader = this;
            synchronized (linkDbReader) {
                this.readers = MapFileOutputFormat.getReaders((FileSystem)this.fs, (Path)new Path(this.directory, "current"), (Configuration)this.getConf());
            }
        }
        return (Inlinks)MapFileOutputFormat.getEntry((MapFile.Reader[])this.readers, PARTITIONER, (WritableComparable)url, (Writable)new Inlinks());
    }

    @Override
    public void close() throws IOException {
        if (this.readers != null) {
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i].close();
            }
        }
    }

    public void processDumpJob(String linkdb, String output) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long start = System.currentTimeMillis();
        if (LOG.isInfoEnabled()) {
            LOG.info("LinkDb dump: starting at " + sdf.format(start));
            LOG.info("LinkDb dump: db: " + linkdb);
        }
        Path outFolder = new Path(output);
        NutchJob job = new NutchJob(this.getConf());
        job.setJobName("read " + linkdb);
        FileInputFormat.addInputPath((JobConf)job, (Path)new Path(linkdb, "current"));
        job.setInputFormat(SequenceFileInputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outFolder);
        job.setOutputFormat(TextOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Inlinks.class);
        JobClient.runJob((JobConf)job);
        long end = System.currentTimeMillis();
        LOG.info("LinkDb dump: finished at " + sdf.format(end) + ", elapsed: " + TimingUtil.elapsedTime(start, end));
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new LinkDbReader(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: LinkDbReader <linkdb> (-dump <out_dir> | -url <url>)");
            System.err.println("\t-dump <out_dir>\tdump whole link db to a text file in <out_dir>");
            System.err.println("\t-url <url>\tprint information about <url> to System.out");
            return -1;
        }
        try {
            if (args[1].equals("-dump")) {
                this.processDumpJob(args[0], args[2]);
                return 0;
            }
            if (args[1].equals("-url")) {
                this.init(new Path(args[0]));
                Inlinks links = this.getInlinks(new Text(args[2]));
                if (links == null) {
                    System.out.println(" - no link information.");
                } else {
                    Iterator<Inlink> it = links.iterator();
                    while (it.hasNext()) {
                        System.out.println(it.next().toString());
                    }
                }
                return 0;
            }
            System.err.println("Error: wrong argument " + args[1]);
            return -1;
        }
        catch (Exception e) {
            LOG.error("LinkDbReader: " + StringUtils.stringifyException((Throwable)e));
            return -1;
        }
    }
}

