/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.parse.ParseText;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.ProtocolStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MapWritable
implements Writable {
    public static final Logger LOG = LoggerFactory.getLogger(MapWritable.class);
    private KeyValueEntry fFirst;
    private KeyValueEntry fLast;
    private KeyValueEntry fOld;
    private int fSize = 0;
    private int fIdCount = 0;
    private ClassIdEntry fIdLast;
    private ClassIdEntry fIdFirst;
    private static Map<Class<?>, Byte> CLASS_ID_MAP = new HashMap();
    private static Map<Byte, Class<?>> ID_CLASS_MAP = new HashMap();

    private static void addToMap(Class<?> clazz, Byte byteId) {
        CLASS_ID_MAP.put(clazz, byteId);
        ID_CLASS_MAP.put(byteId, clazz);
    }

    public MapWritable() {
    }

    public MapWritable(MapWritable map) {
        if (map != null) {
            try {
                DataOutputBuffer dob = new DataOutputBuffer();
                map.write((DataOutput)dob);
                DataInputBuffer dib = new DataInputBuffer();
                dib.reset(dob.getData(), dob.getLength());
                this.readFields((DataInput)dib);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("this map cannot be copied: " + StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    public void clear() {
        this.fOld = this.fFirst;
        this.fLast = null;
        this.fFirst = null;
        this.fSize = 0;
    }

    public boolean containsKey(Writable key) {
        return this.findEntryByKey(key) != null;
    }

    public boolean containsValue(Writable value) {
        KeyValueEntry entry = this.fFirst;
        while (entry != null) {
            if (entry.fValue.equals(value)) {
                return true;
            }
            entry = entry.fNextEntry;
        }
        return false;
    }

    public Writable get(Writable key) {
        KeyValueEntry entry = this.findEntryByKey(key);
        if (entry != null) {
            return entry.fValue;
        }
        return null;
    }

    public int hashCode() {
        int seed = 23;
        int hash = 0;
        KeyValueEntry entry = this.fFirst;
        while (entry != null) {
            hash += entry.fKey.hashCode() * 23;
            hash += entry.fValue.hashCode() * 23;
            entry = entry.fNextEntry;
        }
        return hash;
    }

    public boolean isEmpty() {
        return this.fFirst == null;
    }

    public Set<Writable> keySet() {
        HashSet<Writable> set = new HashSet<Writable>();
        if (this.isEmpty()) {
            return set;
        }
        set.add(this.fFirst.fKey);
        KeyValueEntry entry = this.fFirst;
        while ((entry = entry.fNextEntry) != null) {
            set.add(entry.fKey);
        }
        return set;
    }

    public Writable put(Writable key, Writable value) {
        KeyValueEntry entry = this.findEntryByKey(key);
        if (entry != null) {
            Writable oldValue = entry.fValue;
            entry.fValue = value;
            return oldValue;
        }
        KeyValueEntry newEntry = new KeyValueEntry(key, value);
        ++this.fSize;
        if (this.fLast != null) {
            this.fLast = this.fLast.fNextEntry = newEntry;
            return null;
        }
        this.fLast = this.fFirst = newEntry;
        return null;
    }

    public void putAll(MapWritable map) {
        if (map == null || map.size() == 0) {
            return;
        }
        for (Writable key : map.keySet()) {
            Writable value = map.get(key);
            this.put(key, value);
        }
    }

    public Writable remove(Writable key) {
        Writable oldValue = null;
        KeyValueEntry entry = this.fFirst;
        KeyValueEntry predecessor = null;
        while (entry != null) {
            if (entry.fKey.equals(key)) {
                oldValue = entry.fValue;
                if (predecessor == null) {
                    this.fFirst = this.fFirst.fNextEntry;
                } else {
                    predecessor.fNextEntry = entry.fNextEntry;
                }
                if (this.fLast.equals(entry)) {
                    this.fLast = predecessor;
                }
                --this.fSize;
                return oldValue;
            }
            predecessor = entry;
            entry = entry.fNextEntry;
        }
        return oldValue;
    }

    public int size() {
        return this.fSize;
    }

    public Collection<Writable> values() {
        LinkedList<Writable> list = new LinkedList<Writable>();
        KeyValueEntry entry = this.fFirst;
        while (entry != null) {
            list.add(entry.fValue);
            entry = entry.fNextEntry;
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapWritable) {
            MapWritable map = (MapWritable)obj;
            if (this.fSize != map.fSize) {
                return false;
            }
            HashSet<KeyValueEntry> set1 = new HashSet<KeyValueEntry>();
            KeyValueEntry e1 = this.fFirst;
            while (e1 != null) {
                set1.add(e1);
                e1 = e1.fNextEntry;
            }
            HashSet<KeyValueEntry> set2 = new HashSet<KeyValueEntry>();
            KeyValueEntry e2 = map.fFirst;
            while (e2 != null) {
                set2.add(e2);
                e2 = e2.fNextEntry;
            }
            return set1.equals(set2);
        }
        return false;
    }

    public String toString() {
        if (this.fFirst != null) {
            StringBuffer buffer = new StringBuffer();
            KeyValueEntry entry = this.fFirst;
            while (entry != null) {
                buffer.append(entry.toString());
                buffer.append(" ");
                entry = entry.fNextEntry;
            }
            return buffer.toString();
        }
        return null;
    }

    private KeyValueEntry findEntryByKey(Writable key) {
        KeyValueEntry entry = this.fFirst;
        while (entry != null && !entry.fKey.equals(key)) {
            entry = entry.fNextEntry;
        }
        return entry;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() > 0) {
            Object entry;
            this.createInternalIdClassEntries();
            out.writeByte(this.fIdCount);
            if (this.fIdCount > 0) {
                entry = this.fIdFirst;
                while (entry != null) {
                    out.writeByte(((ClassIdEntry)entry).fId);
                    Text.writeString((DataOutput)out, (String)((ClassIdEntry)entry).fclazz.getName());
                    entry = ((ClassIdEntry)entry).fNextIdEntry;
                }
            }
            entry = this.fFirst;
            while (entry != null) {
                out.writeByte(((KeyValueEntry)entry).fKeyClassId);
                out.writeByte(((KeyValueEntry)entry).fValueClassId);
                ((KeyValueEntry)entry).fKey.write(out);
                ((KeyValueEntry)entry).fValue.write(out);
                entry = ((KeyValueEntry)entry).fNextEntry;
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.clear();
        this.fSize = in.readInt();
        if (this.fSize > 0) {
            this.fIdCount = in.readByte();
            for (int i = 0; i < this.fIdCount; ++i) {
                try {
                    byte id = in.readByte();
                    Class<?> clazz = Class.forName(Text.readString((DataInput)in));
                    this.addIdEntry(id, clazz);
                    continue;
                }
                catch (Exception e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Unable to load internal map entry" + e.toString());
                    }
                    --this.fIdCount;
                }
            }
            for (int i = 0; i < this.fSize; ++i) {
                try {
                    KeyValueEntry entry = this.getKeyValueEntry(in.readByte(), in.readByte());
                    entry.fKey.readFields(in);
                    entry.fValue.readFields(in);
                    if (this.fFirst == null) {
                        this.fFirst = this.fLast = entry;
                        continue;
                    }
                    this.fLast = this.fLast.fNextEntry = entry;
                    continue;
                }
                catch (IOException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Unable to load meta data entry, ignoring.. : " + e.toString());
                    }
                    --this.fSize;
                }
            }
        }
    }

    private void createInternalIdClassEntries() {
        KeyValueEntry entry = this.fFirst;
        while (entry != null) {
            byte id = this.getClassId(entry.fKey.getClass());
            if (id == -128) {
                id = this.addIdEntry((byte)(-128 + CLASS_ID_MAP.size() + ++this.fIdCount), entry.fKey.getClass());
            }
            entry.fKeyClassId = id;
            id = this.getClassId(entry.fValue.getClass());
            if (id == -128) {
                id = this.addIdEntry((byte)(-128 + CLASS_ID_MAP.size() + ++this.fIdCount), entry.fValue.getClass());
            }
            entry.fValueClassId = id;
            entry = entry.fNextEntry;
        }
    }

    private byte addIdEntry(byte id, Class<?> clazz) {
        if (this.fIdFirst == null) {
            this.fIdFirst = this.fIdLast = new ClassIdEntry(id, clazz);
        } else {
            this.fIdLast = new ClassIdEntry(id, clazz);
            this.fIdLast.fNextIdEntry = this.fIdLast;
        }
        return id;
    }

    private byte getClassId(Class<?> clazz) {
        Byte classId = CLASS_ID_MAP.get(clazz);
        if (classId != null) {
            return classId;
        }
        ClassIdEntry entry = this.fIdFirst;
        while (entry != null) {
            if (entry.fclazz.equals(clazz)) {
                return entry.fId;
            }
            entry = entry.fNextIdEntry;
        }
        return -128;
    }

    private KeyValueEntry getKeyValueEntry(byte keyId, byte valueId) throws IOException {
        KeyValueEntry entry = this.fOld;
        KeyValueEntry last = null;
        while (entry != null) {
            byte entryKeyId = this.getClassId(entry.fKey.getClass());
            byte entryValueId = this.getClassId(entry.fValue.getClass());
            if (entryKeyId == keyId && entryValueId == valueId) {
                if (last != null) {
                    last.fNextEntry = entry.fNextEntry;
                } else {
                    this.fOld = entry.fNextEntry;
                }
                entry.fNextEntry = null;
                return entry;
            }
            last = entry;
            entry = entry.fNextEntry;
        }
        Class<?> keyClass = this.getClass(keyId);
        Class<?> valueClass = this.getClass(valueId);
        try {
            return new KeyValueEntry((Writable)keyClass.newInstance(), (Writable)valueClass.newInstance());
        }
        catch (Exception e) {
            throw new IOException("unable to instantiate class: " + e.toString());
        }
    }

    private Class<?> getClass(byte id) throws IOException {
        Class<?> clazz = ID_CLASS_MAP.get(new Byte(id));
        if (clazz == null) {
            ClassIdEntry entry = this.fIdFirst;
            while (entry != null) {
                if (entry.fId == id) {
                    return entry.fclazz;
                }
                entry = entry.fNextIdEntry;
            }
        } else {
            return clazz;
        }
        throw new IOException("unable to load class for id: " + id);
    }

    static {
        MapWritable.addToMap(NullWritable.class, new Byte(-127));
        MapWritable.addToMap(LongWritable.class, new Byte(-126));
        MapWritable.addToMap(Text.class, new Byte(-125));
        MapWritable.addToMap(MD5Hash.class, new Byte(-124));
        MapWritable.addToMap(Content.class, new Byte(-122));
        MapWritable.addToMap(ParseText.class, new Byte(-121));
        MapWritable.addToMap(ParseData.class, new Byte(-120));
        MapWritable.addToMap(MapWritable.class, new Byte(-119));
        MapWritable.addToMap(BytesWritable.class, new Byte(-118));
        MapWritable.addToMap(FloatWritable.class, new Byte(-117));
        MapWritable.addToMap(IntWritable.class, new Byte(-116));
        MapWritable.addToMap(ObjectWritable.class, new Byte(-115));
        MapWritable.addToMap(ProtocolStatus.class, new Byte(-114));
    }

    private class ClassIdEntry {
        private byte fId;
        private Class<?> fclazz;
        private ClassIdEntry fNextIdEntry;

        public ClassIdEntry(byte id, Class<?> clazz) {
            this.fId = id;
            this.fclazz = clazz;
        }
    }

    private class KeyValueEntry {
        private byte fKeyClassId;
        private byte fValueClassId;
        private Writable fKey;
        private Writable fValue;
        private KeyValueEntry fNextEntry;

        public KeyValueEntry(Writable key, Writable value) {
            this.fKey = key;
            this.fValue = value;
        }

        public String toString() {
            return this.fKey.toString() + ":" + this.fValue.toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof KeyValueEntry) {
                KeyValueEntry entry = (KeyValueEntry)obj;
                return entry.fKey.equals(this.fKey) && entry.fValue.equals(this.fValue);
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

