/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.crawl.MD5Signature;
import org.apache.nutch.crawl.Signature;
import org.apache.nutch.util.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureFactory.class);

    private SignatureFactory() {
    }

    public static synchronized Signature getSignature(Configuration conf) {
        String clazz = conf.get("db.signature.class", MD5Signature.class.getName());
        ObjectCache objectCache = ObjectCache.get(conf);
        Signature impl = (Signature)objectCache.getObject(clazz);
        if (impl == null) {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Using Signature impl: " + clazz);
                }
                Class<?> implClass = Class.forName(clazz);
                impl = (Signature)implClass.newInstance();
                impl.setConf(conf);
                objectCache.setObject(clazz, impl);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't create " + clazz, e);
            }
        }
        return impl;
    }
}

