/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.nutch.crawl.Generator;
import org.apache.nutch.net.URLNormalizers;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLPartitioner
implements Partitioner<Text, Writable> {
    private static final Logger LOG = LoggerFactory.getLogger(URLPartitioner.class);
    public static final String PARTITION_MODE_KEY = "partition.url.mode";
    public static final String PARTITION_MODE_HOST = "byHost";
    public static final String PARTITION_MODE_DOMAIN = "byDomain";
    public static final String PARTITION_MODE_IP = "byIP";
    private int seed;
    private URLNormalizers normalizers;
    private String mode = "byHost";

    public void configure(JobConf job) {
        this.seed = job.getInt("partition.url.seed", 0);
        this.mode = job.get(PARTITION_MODE_KEY, PARTITION_MODE_HOST);
        if (!(this.mode.equals(PARTITION_MODE_IP) || this.mode.equals(PARTITION_MODE_DOMAIN) || this.mode.equals(PARTITION_MODE_HOST))) {
            LOG.error("Unknown partition mode : " + this.mode + " - forcing to byHost");
            this.mode = PARTITION_MODE_HOST;
        }
        this.normalizers = new URLNormalizers((Configuration)job, "partition");
    }

    public void close() {
    }

    public int getPartition(Text key, Writable value, int numReduceTasks) {
        String urlString = key.toString();
        URL url = null;
        int hashCode = urlString.hashCode();
        try {
            urlString = this.normalizers.normalize(urlString, "partition");
            url = new URL(urlString);
            hashCode = url.getHost().hashCode();
        }
        catch (MalformedURLException e) {
            LOG.warn("Malformed URL: '" + urlString + "'");
        }
        if (this.mode.equals(PARTITION_MODE_DOMAIN) && url != null) {
            hashCode = URLUtil.getDomainName(url).hashCode();
        } else if (this.mode.equals(PARTITION_MODE_IP)) {
            try {
                InetAddress address = InetAddress.getByName(url.getHost());
                hashCode = address.getHostAddress().hashCode();
            }
            catch (UnknownHostException e) {
                Generator.LOG.info("Couldn't find IP for host: " + url.getHost());
            }
        }
        return ((hashCode ^= this.seed) & Integer.MAX_VALUE) % numReduceTasks;
    }
}

