/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.fetcher;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.NutchWritable;
import org.apache.nutch.fetcher.Fetcher;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseOutputFormat;
import org.apache.nutch.protocol.Content;

public class FetcherOutputFormat
implements OutputFormat<Text, NutchWritable> {
    public void checkOutputSpecs(FileSystem fs, JobConf job) throws IOException {
        Path out = FileOutputFormat.getOutputPath((JobConf)job);
        if (out == null && job.getNumReduceTasks() != 0) {
            throw new InvalidJobConfException("Output directory not set in JobConf.");
        }
        if (fs == null) {
            fs = out.getFileSystem((Configuration)job);
        }
        if (fs.exists(new Path(out, "crawl_fetch"))) {
            throw new IOException("Segment already fetched!");
        }
    }

    public RecordWriter<Text, NutchWritable> getRecordWriter(final FileSystem fs, final JobConf job, final String name, final Progressable progress) throws IOException {
        Path out = FileOutputFormat.getOutputPath((JobConf)job);
        Path fetch = new Path(new Path(out, "crawl_fetch"), name);
        final Path content = new Path(new Path(out, "content"), name);
        final SequenceFile.CompressionType compType = SequenceFileOutputFormat.getOutputCompressionType((JobConf)job);
        final MapFile.Writer fetchOut = new MapFile.Writer((Configuration)job, fs, fetch.toString(), Text.class, CrawlDatum.class, compType, progress);
        return new RecordWriter<Text, NutchWritable>(){
            private MapFile.Writer contentOut;
            private RecordWriter<Text, Parse> parseOut;
            {
                if (Fetcher.isStoringContent((Configuration)job)) {
                    this.contentOut = new MapFile.Writer((Configuration)job, fs, content.toString(), Text.class, Content.class, compType, progress);
                }
                if (Fetcher.isParsing((Configuration)job)) {
                    this.parseOut = new ParseOutputFormat().getRecordWriter(fs, job, name, progress);
                }
            }

            public void write(Text key, NutchWritable value) throws IOException {
                Writable w = value.get();
                if (w instanceof CrawlDatum) {
                    fetchOut.append((WritableComparable)key, w);
                } else if (w instanceof Content && this.contentOut != null) {
                    this.contentOut.append((WritableComparable)key, w);
                } else if (w instanceof Parse && this.parseOut != null) {
                    this.parseOut.write((Object)key, (Object)((Parse)w));
                }
            }

            public void close(Reporter reporter) throws IOException {
                fetchOut.close();
                if (this.contentOut != null) {
                    this.contentOut.close();
                }
                if (this.parseOut != null) {
                    this.parseOut.close(reporter);
                }
            }
        };
    }
}

