/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.nutch.indexer.IndexWriter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.util.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexWriters {
    public static final Logger LOG = LoggerFactory.getLogger(IndexWriters.class);
    private IndexWriter[] indexWriters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriters(Configuration conf) {
        ObjectCache objectCache;
        ObjectCache objectCache2 = objectCache = ObjectCache.get(conf);
        synchronized (objectCache2) {
            this.indexWriters = (IndexWriter[])objectCache.getObject(IndexWriter.class.getName());
            if (this.indexWriters == null) {
                try {
                    ExtensionPoint point = PluginRepository.get(conf).getExtensionPoint(IndexWriter.X_POINT_ID);
                    if (point == null) {
                        throw new RuntimeException(IndexWriter.X_POINT_ID + " not found.");
                    }
                    Extension[] extensions = point.getExtensions();
                    HashMap<String, IndexWriter> indexerMap = new HashMap<String, IndexWriter>();
                    for (int i = 0; i < extensions.length; ++i) {
                        Extension extension = extensions[i];
                        IndexWriter writer = (IndexWriter)extension.getExtensionInstance();
                        LOG.info("Adding " + writer.getClass().getName());
                        if (indexerMap.containsKey(writer.getClass().getName())) continue;
                        indexerMap.put(writer.getClass().getName(), writer);
                    }
                    objectCache.setObject(IndexWriter.class.getName(), indexerMap.values().toArray(new IndexWriter[0]));
                }
                catch (PluginRuntimeException e) {
                    throw new RuntimeException(e);
                }
                this.indexWriters = (IndexWriter[])objectCache.getObject(IndexWriter.class.getName());
            }
        }
    }

    public void open(JobConf job, String name) throws IOException {
        for (int i = 0; i < this.indexWriters.length; ++i) {
            this.indexWriters[i].open(job, name);
            continue;
        }
    }

    public void write(NutchDocument doc) throws IOException {
        for (int i = 0; i < this.indexWriters.length; ++i) {
            this.indexWriters[i].write(doc);
            continue;
        }
    }

    public void update(NutchDocument doc) throws IOException {
        for (int i = 0; i < this.indexWriters.length; ++i) {
            this.indexWriters[i].update(doc);
            continue;
        }
    }

    public void delete(String key) throws IOException {
        for (int i = 0; i < this.indexWriters.length; ++i) {
            this.indexWriters[i].delete(key);
            continue;
        }
    }

    public void close() throws IOException {
        for (int i = 0; i < this.indexWriters.length; ++i) {
            this.indexWriters[i].close();
            continue;
        }
    }

    public void commit() throws IOException {
        for (int i = 0; i < this.indexWriters.length; ++i) {
            this.indexWriters[i].commit();
            continue;
        }
    }

    public String describe() throws IOException {
        StringBuffer buffer = new StringBuffer();
        if (this.indexWriters.length == 0) {
            buffer.append("No IndexWriters activated - check your configuration\n");
        } else {
            buffer.append("Active IndexWriters :\n");
        }
        for (int i = 0; i < this.indexWriters.length; ++i) {
            buffer.append(this.indexWriters[i].describe()).append("\n");
        }
        return buffer.toString();
    }
}

