/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.nutch.indexer.IndexWriters;
import org.apache.nutch.indexer.NutchIndexAction;

public class IndexerOutputFormat
extends FileOutputFormat<Text, NutchIndexAction> {
    public RecordWriter<Text, NutchIndexAction> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        final IndexWriters writers = new IndexWriters((Configuration)job);
        writers.open(job, name);
        return new RecordWriter<Text, NutchIndexAction>(){

            public void close(Reporter reporter) throws IOException {
                writers.close();
            }

            public void write(Text key, NutchIndexAction indexAction) throws IOException {
                if (indexAction.action == 0) {
                    writers.write(indexAction.doc);
                } else if (indexAction.action == 1) {
                    writers.delete(key.toString());
                }
            }
        };
    }
}

