/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.indexer.IndexWriters;
import org.apache.nutch.indexer.IndexerMapReduce;
import org.apache.nutch.util.HadoopFSUtil;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TimingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingJob
extends Configured
implements Tool {
    public static Logger LOG = LoggerFactory.getLogger(IndexingJob.class);

    public IndexingJob() {
        super(null);
    }

    public IndexingJob(Configuration conf) {
        super(conf);
    }

    public void index(Path crawlDb, Path linkDb, List<Path> segments, boolean noCommit) throws IOException {
        this.index(crawlDb, linkDb, segments, noCommit, false, null);
    }

    public void index(Path crawlDb, Path linkDb, List<Path> segments, boolean noCommit, boolean deleteGone) throws IOException {
        this.index(crawlDb, linkDb, segments, noCommit, deleteGone, null);
    }

    public void index(Path crawlDb, Path linkDb, List<Path> segments, boolean noCommit, boolean deleteGone, String params) throws IOException {
        this.index(crawlDb, linkDb, segments, noCommit, deleteGone, params, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(Path crawlDb, Path linkDb, List<Path> segments, boolean noCommit, boolean deleteGone, String params, boolean filter, boolean normalize) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long start = System.currentTimeMillis();
        LOG.info("Indexer: starting at " + sdf.format(start));
        NutchJob job = new NutchJob(this.getConf());
        job.setJobName("Indexer");
        LOG.info("Indexer: deleting gone documents: " + deleteGone);
        LOG.info("Indexer: URL filtering: " + filter);
        LOG.info("Indexer: URL normalizing: " + normalize);
        IndexWriters writers = new IndexWriters(this.getConf());
        LOG.info(writers.describe());
        IndexerMapReduce.initMRJob(crawlDb, linkDb, segments, job);
        job.setBoolean("indexer.delete", deleteGone);
        job.setBoolean("indexer.url.filters", filter);
        job.setBoolean("indexer.url.normalizers", normalize);
        if (params != null) {
            job.set("indexer.additional.params", params);
        }
        job.setReduceSpeculativeExecution(false);
        Path tmp = new Path("tmp_" + System.currentTimeMillis() + "-" + new Random().nextInt());
        FileOutputFormat.setOutputPath((JobConf)job, (Path)tmp);
        try {
            JobClient.runJob((JobConf)job);
            if (!noCommit) {
                writers.open(job, "commit");
                writers.commit();
            }
            long end = System.currentTimeMillis();
            LOG.info("Indexer: finished at " + sdf.format(end) + ", elapsed: " + TimingUtil.elapsedTime(start, end));
        }
        finally {
            FileSystem.get((Configuration)job).delete(tmp, true);
        }
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: Indexer <crawldb> [-linkdb <linkdb>] [-params k1=v1&k2=v2...] (<segment> ... | -dir <segments>) [-noCommit] [-deleteGone] [-filter] [-normalize]");
            IndexWriters writers = new IndexWriters(this.getConf());
            System.err.println(writers.describe());
            return -1;
        }
        Path crawlDb = new Path(args[0]);
        Path linkDb = null;
        ArrayList<Path> segments = new ArrayList<Path>();
        String params = null;
        boolean noCommit = false;
        boolean deleteGone = false;
        boolean filter = false;
        boolean normalize = false;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-linkdb")) {
                linkDb = new Path(args[++i]);
                continue;
            }
            if (args[i].equals("-dir")) {
                Path[] files;
                Path dir = new Path(args[++i]);
                FileSystem fs = dir.getFileSystem(this.getConf());
                FileStatus[] fstats = fs.listStatus(dir, HadoopFSUtil.getPassDirectoriesFilter(fs));
                for (Path p : files = HadoopFSUtil.getPaths(fstats)) {
                    segments.add(p);
                }
                continue;
            }
            if (args[i].equals("-noCommit")) {
                noCommit = true;
                continue;
            }
            if (args[i].equals("-deleteGone")) {
                deleteGone = true;
                continue;
            }
            if (args[i].equals("-filter")) {
                filter = true;
                continue;
            }
            if (args[i].equals("-normalize")) {
                normalize = true;
                continue;
            }
            if (args[i].equals("-params")) {
                params = args[++i];
                continue;
            }
            segments.add(new Path(args[i]));
        }
        try {
            this.index(crawlDb, linkDb, segments, noCommit, deleteGone, params, filter, normalize);
            return 0;
        }
        catch (Exception e) {
            LOG.error("Indexer: " + StringUtils.stringifyException((Throwable)e));
            return -1;
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new IndexingJob(), (String[])args);
        System.exit(res);
    }
}

