/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.Plugin;
import org.apache.nutch.plugin.PluginClassLoader;
import org.apache.nutch.plugin.PluginRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDescriptor {
    private String fPluginPath;
    private String fPluginClass = Plugin.class.getName();
    private String fPluginId;
    private String fVersion;
    private String fName;
    private String fProviderName;
    private HashMap<String, ResourceBundle> fMessages = new HashMap();
    private ArrayList<ExtensionPoint> fExtensionPoints = new ArrayList();
    private ArrayList<String> fDependencies = new ArrayList();
    private ArrayList<URL> fExportedLibs = new ArrayList();
    private ArrayList<URL> fNotExportedLibs = new ArrayList();
    private ArrayList<Extension> fExtensions = new ArrayList();
    private PluginClassLoader fClassLoader;
    public static final Logger LOG = LoggerFactory.getLogger(PluginDescriptor.class);
    private Configuration fConf;

    public PluginDescriptor(String pId, String pVersion, String pName, String pProviderName, String pPluginclazz, String pPath, Configuration conf) {
        this.setPath(pPath);
        this.setPluginId(pId);
        this.setVersion(pVersion);
        this.setName(pName);
        this.setProvidername(pProviderName);
        if (pPluginclazz != null) {
            this.setPluginClass(pPluginclazz);
        }
        this.fConf = conf;
    }

    private void setPath(String pPath) {
        this.fPluginPath = pPath;
    }

    public String getName() {
        return this.fName;
    }

    private void setProvidername(String providerName) {
        this.fProviderName = providerName;
    }

    private void setName(String name) {
        this.fName = name;
    }

    private void setVersion(String version) {
        this.fVersion = version;
    }

    public String getPluginClass() {
        return this.fPluginClass;
    }

    public String getPluginId() {
        return this.fPluginId;
    }

    public Extension[] getExtensions() {
        return this.fExtensions.toArray(new Extension[this.fExtensions.size()]);
    }

    public void addExtension(Extension pExtension) {
        this.fExtensions.add(pExtension);
    }

    private void setPluginClass(String pluginClass) {
        this.fPluginClass = pluginClass;
    }

    private void setPluginId(String pluginId) {
        this.fPluginId = pluginId;
    }

    public void addExtensionPoint(ExtensionPoint extensionPoint) {
        this.fExtensionPoints.add(extensionPoint);
    }

    public ExtensionPoint[] getExtenstionPoints() {
        return this.fExtensionPoints.toArray(new ExtensionPoint[this.fExtensionPoints.size()]);
    }

    public String[] getDependencies() {
        return this.fDependencies.toArray(new String[this.fDependencies.size()]);
    }

    public void addDependency(String pId) {
        this.fDependencies.add(pId);
    }

    public void addExportedLibRelative(String pLibPath) throws MalformedURLException {
        URI uri = new File(this.getPluginPath() + File.separator + pLibPath).toURI();
        URL url = uri.toURL();
        this.fExportedLibs.add(url);
    }

    public String getPluginPath() {
        return this.fPluginPath;
    }

    public URL[] getExportedLibUrls() {
        return this.fExportedLibs.toArray(new URL[0]);
    }

    public void addNotExportedLibRelative(String pLibPath) throws MalformedURLException {
        URI uri = new File(this.getPluginPath() + File.separator + pLibPath).toURI();
        URL url = uri.toURL();
        this.fNotExportedLibs.add(url);
    }

    public URL[] getNotExportedLibUrls() {
        return this.fNotExportedLibs.toArray(new URL[this.fNotExportedLibs.size()]);
    }

    public PluginClassLoader getClassLoader() {
        if (this.fClassLoader != null) {
            return this.fClassLoader;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.addAll(this.fExportedLibs);
        arrayList.addAll(this.fNotExportedLibs);
        arrayList.addAll(this.getDependencyLibs());
        File file = new File(this.getPluginPath());
        try {
            for (File file2 : file.listFiles()) {
                if (!file2.getAbsolutePath().endsWith("properties")) continue;
                arrayList.add(file2.getParentFile().toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            LOG.debug(this.getPluginId() + " " + e.toString());
        }
        URL[] urls = arrayList.toArray(new URL[arrayList.size()]);
        this.fClassLoader = new PluginClassLoader(urls, PluginDescriptor.class.getClassLoader());
        return this.fClassLoader;
    }

    private ArrayList<URL> getDependencyLibs() {
        ArrayList<URL> list = new ArrayList<URL>();
        this.collectLibs(list, this);
        return list;
    }

    private void collectLibs(ArrayList<URL> pLibs, PluginDescriptor pDescriptor) {
        for (String id : pDescriptor.getDependencies()) {
            PluginDescriptor descriptor = PluginRepository.get(this.fConf).getPluginDescriptor(id);
            for (URL url : descriptor.getExportedLibUrls()) {
                pLibs.add(url);
            }
            this.collectLibs(pLibs, descriptor);
        }
    }

    public String getResourceString(String pKey, Locale pLocale) throws IOException {
        if (this.fMessages.containsKey(pLocale.toString())) {
            ResourceBundle bundle = this.fMessages.get(pLocale.toString());
            try {
                return bundle.getString(pKey);
            }
            catch (MissingResourceException e) {
                return '!' + pKey + '!';
            }
        }
        try {
            ResourceBundle res = ResourceBundle.getBundle("messages", pLocale, this.getClassLoader());
            return res.getString(pKey);
        }
        catch (MissingResourceException x) {
            return '!' + pKey + '!';
        }
    }

    public String getProviderName() {
        return this.fProviderName;
    }

    public String getVersion() {
        return this.fVersion;
    }
}

