/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.InflaterInputStream;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.util.MimeUtil;
import org.apache.nutch.util.NutchConfiguration;

public final class Content
implements Writable {
    public static final String DIR_NAME = "content";
    private static final int VERSION = -1;
    private int version;
    private String url;
    private String base;
    private byte[] content;
    private String contentType;
    private Metadata metadata;
    private MimeUtil mimeTypes;

    public Content() {
        this.metadata = new Metadata();
    }

    public Content(String url, String base, byte[] content, String contentType, Metadata metadata, Configuration conf) {
        if (url == null) {
            throw new IllegalArgumentException("null url");
        }
        if (base == null) {
            throw new IllegalArgumentException("null base");
        }
        if (content == null) {
            throw new IllegalArgumentException("null content");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("null metadata");
        }
        this.url = url;
        this.base = base;
        this.content = content;
        this.metadata = metadata;
        this.mimeTypes = new MimeUtil(conf);
        this.contentType = this.getContentType(contentType, url, content);
    }

    private final void readFieldsCompressed(DataInput in) throws IOException {
        byte oldVersion = in.readByte();
        switch (oldVersion) {
            case 0: 
            case 1: {
                this.url = Text.readString((DataInput)in);
                this.base = Text.readString((DataInput)in);
                this.content = new byte[in.readInt()];
                in.readFully(this.content);
                this.contentType = Text.readString((DataInput)in);
                int keySize = in.readInt();
                for (int i = 0; i < keySize; ++i) {
                    String key = Text.readString((DataInput)in);
                    int valueSize = in.readInt();
                    for (int j = 0; j < valueSize; ++j) {
                        this.metadata.add(key, Text.readString((DataInput)in));
                    }
                }
                break;
            }
            case 2: {
                this.url = Text.readString((DataInput)in);
                this.base = Text.readString((DataInput)in);
                this.content = new byte[in.readInt()];
                in.readFully(this.content);
                this.contentType = Text.readString((DataInput)in);
                this.metadata.readFields(in);
                break;
            }
            default: {
                throw new VersionMismatchException(2, oldVersion);
            }
        }
    }

    public final void readFields(DataInput in) throws IOException {
        block4: {
            int sizeOrVersion;
            block3: {
                this.metadata.clear();
                sizeOrVersion = in.readInt();
                if (sizeOrVersion >= 0) break block3;
                this.version = sizeOrVersion;
                switch (this.version) {
                    case -1: {
                        this.url = Text.readString((DataInput)in);
                        this.base = Text.readString((DataInput)in);
                        this.content = new byte[in.readInt()];
                        in.readFully(this.content);
                        this.contentType = Text.readString((DataInput)in);
                        this.metadata.readFields(in);
                        break block4;
                    }
                    default: {
                        throw new VersionMismatchException(-1, (byte)this.version);
                    }
                }
            }
            byte[] compressed = new byte[sizeOrVersion];
            in.readFully(compressed, 0, compressed.length);
            ByteArrayInputStream deflated = new ByteArrayInputStream(compressed);
            DataInputStream inflater = new DataInputStream(new InflaterInputStream(deflated));
            this.readFieldsCompressed(inflater);
        }
    }

    public final void write(DataOutput out) throws IOException {
        out.writeInt(-1);
        Text.writeString((DataOutput)out, (String)this.url);
        Text.writeString((DataOutput)out, (String)this.base);
        out.writeInt(this.content.length);
        out.write(this.content);
        Text.writeString((DataOutput)out, (String)this.contentType);
        this.metadata.write(out);
    }

    public static Content read(DataInput in) throws IOException {
        Content content = new Content();
        content.readFields(in);
        return content;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBaseUrl() {
        return this.base;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Content)) {
            return false;
        }
        Content that = (Content)o;
        return this.url.equals(that.url) && this.base.equals(that.base) && Arrays.equals(this.getContent(), that.getContent()) && this.contentType.equals(that.contentType) && this.metadata.equals(that.metadata);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Version: " + this.version + "\n");
        buffer.append("url: " + this.url + "\n");
        buffer.append("base: " + this.base + "\n");
        buffer.append("contentType: " + this.contentType + "\n");
        buffer.append("metadata: " + this.metadata + "\n");
        buffer.append("Content:\n");
        buffer.append(new String(this.content));
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        String usage = "Content (-local | -dfs <namenode:port>) recno segment";
        if (argv.length < 3) {
            System.out.println("usage:" + usage);
            return;
        }
        Options opts = new Options();
        Configuration conf = NutchConfiguration.create();
        GenericOptionsParser parser = new GenericOptionsParser(conf, opts, argv);
        String[] remainingArgs = parser.getRemainingArgs();
        FileSystem fs = FileSystem.get((Configuration)conf);
        try {
            int recno = Integer.parseInt(remainingArgs[0]);
            String segment = remainingArgs[1];
            Path file = new Path(segment, DIR_NAME);
            System.out.println("Reading from file: " + file);
            ArrayFile.Reader contents = new ArrayFile.Reader(fs, file.toString(), conf);
            Content content = new Content();
            contents.get((long)recno, (Writable)content);
            System.out.println("Retrieved " + recno + " from file " + file);
            System.out.println(content);
            contents.close();
        }
        finally {
            fs.close();
        }
    }

    private String getContentType(String typeName, String url, byte[] data) {
        return this.mimeTypes.autoResolveContentType(typeName, url, data);
    }
}

