/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.protocol.Protocol;
import org.apache.nutch.protocol.ProtocolNotFound;
import org.apache.nutch.util.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolFactory {
    public static final Logger LOG = LoggerFactory.getLogger(ProtocolFactory.class);
    private ExtensionPoint extensionPoint;
    private Configuration conf;

    public ProtocolFactory(Configuration conf) {
        this.conf = conf;
        this.extensionPoint = PluginRepository.get(conf).getExtensionPoint(Protocol.X_POINT_ID);
        if (this.extensionPoint == null) {
            throw new RuntimeException("x-point " + Protocol.X_POINT_ID + " not found.");
        }
    }

    public synchronized Protocol getProtocol(String urlString) throws ProtocolNotFound {
        ObjectCache objectCache = ObjectCache.get(this.conf);
        try {
            URL url = new URL(urlString);
            String protocolName = url.getProtocol();
            if (protocolName == null) {
                throw new ProtocolNotFound(urlString);
            }
            String cacheId = Protocol.X_POINT_ID + protocolName;
            Protocol protocol = (Protocol)objectCache.getObject(cacheId);
            if (protocol != null) {
                return protocol;
            }
            Extension extension = this.findExtension(protocolName);
            if (extension == null) {
                throw new ProtocolNotFound(protocolName);
            }
            protocol = (Protocol)extension.getExtensionInstance();
            objectCache.setObject(cacheId, protocol);
            return protocol;
        }
        catch (MalformedURLException e) {
            throw new ProtocolNotFound(urlString, e.toString());
        }
        catch (PluginRuntimeException e) {
            throw new ProtocolNotFound(urlString, e.toString());
        }
    }

    private Extension findExtension(String name) throws PluginRuntimeException {
        Extension[] extensions = this.extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            Extension extension = extensions[i];
            if (!this.contains(name, extension.getAttribute("protocolName"))) continue;
            return extension;
        }
        return null;
    }

    boolean contains(String what, String where) {
        String[] parts = where.split("[, ]");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equals(what)) continue;
            return true;
        }
        return false;
    }
}

