/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class ProtocolStatus
implements Writable {
    private static final byte VERSION = 2;
    public static final int SUCCESS = 1;
    public static final int FAILED = 2;
    public static final int PROTO_NOT_FOUND = 10;
    public static final int GONE = 11;
    public static final int MOVED = 12;
    public static final int TEMP_MOVED = 13;
    public static final int NOTFOUND = 14;
    public static final int RETRY = 15;
    public static final int EXCEPTION = 16;
    public static final int ACCESS_DENIED = 17;
    public static final int ROBOTS_DENIED = 18;
    public static final int REDIR_EXCEEDED = 19;
    public static final int NOTFETCHING = 20;
    public static final int NOTMODIFIED = 21;
    public static final int WOULDBLOCK = 22;
    public static final int BLOCKED = 23;
    public static final ProtocolStatus STATUS_SUCCESS = new ProtocolStatus(1);
    public static final ProtocolStatus STATUS_FAILED = new ProtocolStatus(2);
    public static final ProtocolStatus STATUS_GONE = new ProtocolStatus(11);
    public static final ProtocolStatus STATUS_NOTFOUND = new ProtocolStatus(14);
    public static final ProtocolStatus STATUS_RETRY = new ProtocolStatus(15);
    public static final ProtocolStatus STATUS_ROBOTS_DENIED = new ProtocolStatus(18);
    public static final ProtocolStatus STATUS_REDIR_EXCEEDED = new ProtocolStatus(19);
    public static final ProtocolStatus STATUS_NOTFETCHING = new ProtocolStatus(20);
    public static final ProtocolStatus STATUS_NOTMODIFIED = new ProtocolStatus(21);
    public static final ProtocolStatus STATUS_WOULDBLOCK = new ProtocolStatus(22);
    public static final ProtocolStatus STATUS_BLOCKED = new ProtocolStatus(23);
    private int code;
    private long lastModified;
    private String[] args;
    private static final HashMap<Integer, String> codeToName = new HashMap();

    public ProtocolStatus() {
    }

    public ProtocolStatus(int code, String[] args) {
        this.code = code;
        this.args = args;
    }

    public ProtocolStatus(int code, String[] args, long lastModified) {
        this.code = code;
        this.args = args;
        this.lastModified = lastModified;
    }

    public ProtocolStatus(int code) {
        this(code, null);
    }

    public ProtocolStatus(int code, long lastModified) {
        this(code, null, lastModified);
    }

    public ProtocolStatus(int code, Object message) {
        this(code, message, 0L);
    }

    public ProtocolStatus(int code, Object message, long lastModified) {
        this.code = code;
        this.lastModified = lastModified;
        if (message != null) {
            this.args = new String[]{String.valueOf(message)};
        }
    }

    public ProtocolStatus(Throwable t) {
        this(16, t);
    }

    public static ProtocolStatus read(DataInput in) throws IOException {
        ProtocolStatus res = new ProtocolStatus();
        res.readFields(in);
        return res;
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        switch (version) {
            case 1: {
                this.code = in.readByte();
                this.lastModified = in.readLong();
                this.args = WritableUtils.readCompressedStringArray((DataInput)in);
                break;
            }
            case 2: {
                this.code = in.readByte();
                this.lastModified = in.readLong();
                this.args = WritableUtils.readStringArray((DataInput)in);
                break;
            }
            default: {
                throw new VersionMismatchException(2, version);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(2);
        out.writeByte((byte)this.code);
        out.writeLong(this.lastModified);
        if (this.args == null) {
            out.writeInt(-1);
        } else {
            WritableUtils.writeStringArray((DataOutput)out, (String[])this.args);
        }
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return codeToName.get(this.code);
    }

    public void setCode(int code) {
        this.code = code;
    }

    public boolean isSuccess() {
        return this.code == 1;
    }

    public boolean isTransientFailure() {
        return this.code == 17 || this.code == 16 || this.code == 19 || this.code == 15 || this.code == 13 || this.code == 22 || this.code == 10;
    }

    public boolean isPermanentFailure() {
        return this.code == 2 || this.code == 11 || this.code == 12 || this.code == 14 || this.code == 18;
    }

    public String getMessage() {
        if (this.args != null && this.args.length > 0) {
            return this.args[0];
        }
        return null;
    }

    public void setMessage(String msg) {
        if (this.args != null && this.args.length > 0) {
            this.args[0] = msg;
        } else {
            this.args = new String[]{msg};
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ProtocolStatus)) {
            return false;
        }
        ProtocolStatus other = (ProtocolStatus)o;
        if (this.code != other.code || this.lastModified != other.lastModified) {
            return false;
        }
        if (this.args == null) {
            return other.args == null;
        }
        if (other.args == null) {
            return false;
        }
        if (other.args.length != this.args.length) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equals(other.args[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append(codeToName.get(new Integer(this.code)) + "(" + this.code + "), lastModified=" + this.lastModified);
        if (this.args != null) {
            if (this.args.length == 1) {
                res.append(": " + String.valueOf(this.args[0]));
            } else {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i] == null) continue;
                    res.append(", args[" + i + "]=" + String.valueOf(this.args[i]));
                }
            }
        }
        return res.toString();
    }

    static {
        codeToName.put(new Integer(1), "success");
        codeToName.put(new Integer(2), "failed");
        codeToName.put(new Integer(10), "proto_not_found");
        codeToName.put(new Integer(11), "gone");
        codeToName.put(new Integer(12), "moved");
        codeToName.put(new Integer(13), "temp_moved");
        codeToName.put(new Integer(14), "notfound");
        codeToName.put(new Integer(15), "retry");
        codeToName.put(new Integer(16), "exception");
        codeToName.put(new Integer(17), "access_denied");
        codeToName.put(new Integer(18), "robots_denied");
        codeToName.put(new Integer(19), "redir_exceeded");
        codeToName.put(new Integer(20), "notfetching");
        codeToName.put(new Integer(21), "notmodified");
        codeToName.put(new Integer(22), "wouldblock");
        codeToName.put(new Integer(23), "blocked");
    }
}

