/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.scoring.ScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;

public class ScoringFilters
extends Configured
implements ScoringFilter {
    private ScoringFilter[] filters;

    public ScoringFilters(Configuration conf) {
        super(conf);
        this.filters = (ScoringFilter[])PluginRepository.get(conf).getOrderedPlugins(ScoringFilter.class, ScoringFilter.X_POINT_ID, "scoring.filter.order");
    }

    @Override
    public float generatorSortValue(Text url, CrawlDatum datum, float initSort) throws ScoringFilterException {
        for (int i = 0; i < this.filters.length; ++i) {
            initSort = this.filters[i].generatorSortValue(url, datum, initSort);
        }
        return initSort;
    }

    @Override
    public void initialScore(Text url, CrawlDatum datum) throws ScoringFilterException {
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i].initialScore(url, datum);
        }
    }

    @Override
    public void injectedScore(Text url, CrawlDatum datum) throws ScoringFilterException {
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i].injectedScore(url, datum);
        }
    }

    @Override
    public void updateDbScore(Text url, CrawlDatum old, CrawlDatum datum, List<CrawlDatum> inlinked) throws ScoringFilterException {
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i].updateDbScore(url, old, datum, inlinked);
        }
    }

    @Override
    public void passScoreBeforeParsing(Text url, CrawlDatum datum, Content content) throws ScoringFilterException {
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i].passScoreBeforeParsing(url, datum, content);
        }
    }

    @Override
    public void passScoreAfterParsing(Text url, Content content, Parse parse) throws ScoringFilterException {
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i].passScoreAfterParsing(url, content, parse);
        }
    }

    @Override
    public CrawlDatum distributeScoreToOutlinks(Text fromUrl, ParseData parseData, Collection<Map.Entry<Text, CrawlDatum>> targets, CrawlDatum adjust, int allCount) throws ScoringFilterException {
        for (int i = 0; i < this.filters.length; ++i) {
            adjust = this.filters[i].distributeScoreToOutlinks(fromUrl, parseData, targets, adjust, allCount);
        }
        return adjust;
    }

    @Override
    public float indexerScore(Text url, NutchDocument doc, CrawlDatum dbDatum, CrawlDatum fetchDatum, Parse parse, Inlinks inlinks, float initScore) throws ScoringFilterException {
        for (int i = 0; i < this.filters.length; ++i) {
            initScore = this.filters[i].indexerScore(url, doc, dbDatum, fetchDatum, parse, inlinks, initScore);
        }
        return initScore;
    }
}

