/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.webgraph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.scoring.webgraph.LinkDatum;
import org.apache.nutch.scoring.webgraph.Loops;
import org.apache.nutch.scoring.webgraph.Node;
import org.apache.nutch.util.FSUtils;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TimingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkDumper
extends Configured
implements Tool {
    public static final Logger LOG = LoggerFactory.getLogger(LinkDumper.class);
    public static final String DUMP_DIR = "linkdump";

    public void dumpLinks(Path webGraphDb) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long start = System.currentTimeMillis();
        LOG.info("NodeDumper: starting at " + sdf.format(start));
        Configuration conf = this.getConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path linkdump = new Path(webGraphDb, DUMP_DIR);
        Path nodeDb = new Path(webGraphDb, "nodes");
        Path loopSetDb = new Path(webGraphDb, "loops");
        boolean loopsExists = fs.exists(loopSetDb);
        Path outlinkDb = new Path(webGraphDb, "outlinks/current");
        Path tempInverted = new Path(webGraphDb, "inverted-" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
        NutchJob inverter = new NutchJob(conf);
        inverter.setJobName("LinkDumper: inverter");
        FileInputFormat.addInputPath((JobConf)inverter, (Path)nodeDb);
        if (loopsExists) {
            FileInputFormat.addInputPath((JobConf)inverter, (Path)loopSetDb);
        }
        FileInputFormat.addInputPath((JobConf)inverter, (Path)outlinkDb);
        inverter.setInputFormat(SequenceFileInputFormat.class);
        inverter.setMapperClass(Inverter.class);
        inverter.setReducerClass(Inverter.class);
        inverter.setMapOutputKeyClass(Text.class);
        inverter.setMapOutputValueClass(ObjectWritable.class);
        inverter.setOutputKeyClass(Text.class);
        inverter.setOutputValueClass(LinkNode.class);
        FileOutputFormat.setOutputPath((JobConf)inverter, (Path)tempInverted);
        inverter.setOutputFormat(SequenceFileOutputFormat.class);
        try {
            LOG.info("LinkDumper: running inverter");
            JobClient.runJob((JobConf)inverter);
            LOG.info("LinkDumper: finished inverter");
        }
        catch (IOException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        NutchJob merger = new NutchJob(conf);
        merger.setJobName("LinkDumper: merger");
        FileInputFormat.addInputPath((JobConf)merger, (Path)tempInverted);
        merger.setInputFormat(SequenceFileInputFormat.class);
        merger.setReducerClass(Merger.class);
        merger.setMapOutputKeyClass(Text.class);
        merger.setMapOutputValueClass(LinkNode.class);
        merger.setOutputKeyClass(Text.class);
        merger.setOutputValueClass(LinkNodes.class);
        FileOutputFormat.setOutputPath((JobConf)merger, (Path)linkdump);
        merger.setOutputFormat(MapFileOutputFormat.class);
        try {
            LOG.info("LinkDumper: running merger");
            JobClient.runJob((JobConf)merger);
            LOG.info("LinkDumper: finished merger");
        }
        catch (IOException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        fs.delete(tempInverted, true);
        long end = System.currentTimeMillis();
        LOG.info("LinkDumper: finished at " + sdf.format(end) + ", elapsed: " + TimingUtil.elapsedTime(start, end));
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new LinkDumper(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withArgName((String)"help");
        OptionBuilder.withDescription((String)"show this help message");
        Option helpOpts = OptionBuilder.create((String)"help");
        options.addOption(helpOpts);
        OptionBuilder.withArgName((String)"webgraphdb");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the web graph database to use");
        Option webGraphDbOpts = OptionBuilder.create((String)"webgraphdb");
        options.addOption(webGraphDbOpts);
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help") || !line.hasOption("webgraphdb")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("LinkDumper", options);
                return -1;
            }
            String webGraphDb = line.getOptionValue("webgraphdb");
            this.dumpLinks(new Path(webGraphDb));
            return 0;
        }
        catch (Exception e) {
            LOG.error("LinkDumper: " + StringUtils.stringifyException((Throwable)e));
            return -2;
        }
    }

    public static class Merger
    implements Reducer<Text, LinkNode, Text, LinkNodes> {
        private JobConf conf;
        private int maxInlinks = 50000;

        public void configure(JobConf conf) {
            this.conf = conf;
        }

        public void reduce(Text key, Iterator<LinkNode> values, OutputCollector<Text, LinkNodes> output, Reporter reporter) throws IOException {
            ArrayList<Writable> nodeList = new ArrayList<Writable>();
            int numNodes = 0;
            while (values.hasNext()) {
                LinkNode cur = values.next();
                if (numNodes >= this.maxInlinks) break;
                nodeList.add(WritableUtils.clone((Writable)cur, (Configuration)this.conf));
                ++numNodes;
            }
            LinkNode[] linkNodesAr = nodeList.toArray(new LinkNode[nodeList.size()]);
            LinkNodes linkNodes = new LinkNodes(linkNodesAr);
            output.collect((Object)key, (Object)linkNodes);
        }

        public void close() {
        }
    }

    public static class Inverter
    implements Mapper<Text, Writable, Text, ObjectWritable>,
    Reducer<Text, ObjectWritable, Text, LinkNode> {
        private JobConf conf;

        public void configure(JobConf conf) {
            this.conf = conf;
        }

        public void map(Text key, Writable value, OutputCollector<Text, ObjectWritable> output, Reporter reporter) throws IOException {
            ObjectWritable objWrite = new ObjectWritable();
            objWrite.set((Object)value);
            output.collect((Object)key, (Object)objWrite);
        }

        public void reduce(Text key, Iterator<ObjectWritable> values, OutputCollector<Text, LinkNode> output, Reporter reporter) throws IOException {
            String fromUrl = key.toString();
            ArrayList<Writable> outlinks = new ArrayList<Writable>();
            Node node = null;
            Loops.LoopSet loops = null;
            while (values.hasNext()) {
                ObjectWritable write = values.next();
                Object obj = write.get();
                if (obj instanceof Node) {
                    node = (Node)obj;
                    continue;
                }
                if (obj instanceof LinkDatum) {
                    outlinks.add(WritableUtils.clone((Writable)((LinkDatum)obj), (Configuration)this.conf));
                    continue;
                }
                if (!(obj instanceof Loops.LoopSet)) continue;
                loops = (Loops.LoopSet)obj;
            }
            int numOutlinks = node.getNumOutlinks();
            if (numOutlinks > 0) {
                Set<String> loopSet = loops != null ? loops.getLoopSet() : null;
                for (int i = 0; i < outlinks.size(); ++i) {
                    LinkDatum outlink = (LinkDatum)outlinks.get(i);
                    String toUrl = outlink.getUrl();
                    if (loopSet != null && loopSet.contains(toUrl)) continue;
                    output.collect((Object)new Text(toUrl), (Object)new LinkNode(fromUrl, node));
                }
            }
        }

        public void close() {
        }
    }

    public static class LinkNodes
    implements Writable {
        private LinkNode[] links;

        public LinkNodes() {
        }

        public LinkNodes(LinkNode[] links) {
            this.links = links;
        }

        public LinkNode[] getLinks() {
            return this.links;
        }

        public void setLinks(LinkNode[] links) {
            this.links = links;
        }

        public void readFields(DataInput in) throws IOException {
            int numLinks = in.readInt();
            if (numLinks > 0) {
                this.links = new LinkNode[numLinks];
                for (int i = 0; i < numLinks; ++i) {
                    LinkNode node = new LinkNode();
                    node.readFields(in);
                    this.links[i] = node;
                }
            }
        }

        public void write(DataOutput out) throws IOException {
            if (this.links != null && this.links.length > 0) {
                int numLinks = this.links.length;
                out.writeInt(numLinks);
                for (int i = 0; i < numLinks; ++i) {
                    this.links[i].write(out);
                }
            }
        }
    }

    public static class LinkNode
    implements Writable {
        private String url = null;
        private Node node = null;

        public LinkNode() {
        }

        public LinkNode(String url, Node node) {
            this.url = url;
            this.node = node;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public void readFields(DataInput in) throws IOException {
            this.url = in.readUTF();
            this.node = new Node();
            this.node.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.url);
            this.node.write(out);
        }
    }

    public static class Reader {
        public static void main(String[] args) throws Exception {
            if (args == null || args.length < 2) {
                System.out.println("LinkDumper$Reader usage: <webgraphdb> <url>");
                return;
            }
            Configuration conf = NutchConfiguration.create();
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path webGraphDb = new Path(args[0]);
            String url = args[1];
            MapFile.Reader[] readers = MapFileOutputFormat.getReaders((FileSystem)fs, (Path)new Path(webGraphDb, LinkDumper.DUMP_DIR), (Configuration)conf);
            Text key = new Text(url);
            LinkNodes nodes = new LinkNodes();
            MapFileOutputFormat.getEntry((MapFile.Reader[])readers, (Partitioner)new HashPartitioner(), (WritableComparable)key, (Writable)nodes);
            LinkNode[] linkNodesAr = nodes.getLinks();
            System.out.println(url + ":");
            for (LinkNode node : linkNodesAr) {
                System.out.println("  " + node.getUrl() + " - " + node.getNode().toString());
            }
            FSUtils.closeReaders(readers);
        }
    }
}

