/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.webgraph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.scoring.webgraph.LinkDatum;
import org.apache.nutch.scoring.webgraph.Node;
import org.apache.nutch.util.FSUtils;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TimingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loops
extends Configured
implements Tool {
    public static final Logger LOG = LoggerFactory.getLogger(Loops.class);
    public static final String LOOPS_DIR = "loops";
    public static final String ROUTES_DIR = "routes";

    public void findLoops(Path webGraphDb) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long start = System.currentTimeMillis();
        if (LOG.isInfoEnabled()) {
            LOG.info("Loops: starting at " + sdf.format(start));
            LOG.info("Loops: webgraphdb: " + webGraphDb);
        }
        Configuration conf = this.getConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path outlinkDb = new Path(webGraphDb, "outlinks/current");
        Path nodeDb = new Path(webGraphDb, "nodes");
        Path routes = new Path(webGraphDb, ROUTES_DIR);
        Path tempRoute = new Path(webGraphDb, "routes-" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
        NutchJob init = new NutchJob(conf);
        init.setJobName("Initializer: " + webGraphDb);
        FileInputFormat.addInputPath((JobConf)init, (Path)outlinkDb);
        FileInputFormat.addInputPath((JobConf)init, (Path)nodeDb);
        init.setInputFormat(SequenceFileInputFormat.class);
        init.setMapperClass(Initializer.class);
        init.setReducerClass(Initializer.class);
        init.setMapOutputKeyClass(Text.class);
        init.setMapOutputValueClass(ObjectWritable.class);
        init.setOutputKeyClass(Text.class);
        init.setOutputValueClass(Route.class);
        FileOutputFormat.setOutputPath((JobConf)init, (Path)tempRoute);
        init.setOutputFormat(SequenceFileOutputFormat.class);
        try {
            LOG.info("Loops: starting initializer");
            JobClient.runJob((JobConf)init);
            LOG.info("Loops: installing initializer " + routes);
            FSUtils.replace(fs, routes, tempRoute, true);
            LOG.info("Loops: finished initializer");
        }
        catch (IOException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        int depth = conf.getInt("link.loops.depth", 2);
        for (int i = 0; i < depth; ++i) {
            NutchJob looper = new NutchJob(conf);
            looper.setJobName("Looper: " + (i + 1) + " of " + depth);
            FileInputFormat.addInputPath((JobConf)looper, (Path)outlinkDb);
            FileInputFormat.addInputPath((JobConf)looper, (Path)routes);
            looper.setInputFormat(SequenceFileInputFormat.class);
            looper.setMapperClass(Looper.class);
            looper.setReducerClass(Looper.class);
            looper.setMapOutputKeyClass(Text.class);
            looper.setMapOutputValueClass(ObjectWritable.class);
            looper.setOutputKeyClass(Text.class);
            looper.setOutputValueClass(Route.class);
            FileOutputFormat.setOutputPath((JobConf)looper, (Path)tempRoute);
            looper.setOutputFormat(SequenceFileOutputFormat.class);
            looper.setBoolean("last", i == depth - 1);
            try {
                LOG.info("Loops: starting looper");
                JobClient.runJob((JobConf)looper);
                LOG.info("Loops: installing looper " + routes);
                FSUtils.replace(fs, routes, tempRoute, true);
                LOG.info("Loops: finished looper");
                continue;
            }
            catch (IOException e) {
                LOG.error(StringUtils.stringifyException((Throwable)e));
                throw e;
            }
        }
        NutchJob finalizer = new NutchJob(conf);
        finalizer.setJobName("Finalizer: " + webGraphDb);
        FileInputFormat.addInputPath((JobConf)finalizer, (Path)routes);
        finalizer.setInputFormat(SequenceFileInputFormat.class);
        finalizer.setMapperClass(Finalizer.class);
        finalizer.setReducerClass(Finalizer.class);
        finalizer.setMapOutputKeyClass(Text.class);
        finalizer.setMapOutputValueClass(Route.class);
        finalizer.setOutputKeyClass(Text.class);
        finalizer.setOutputValueClass(LoopSet.class);
        FileOutputFormat.setOutputPath((JobConf)finalizer, (Path)new Path(webGraphDb, LOOPS_DIR));
        finalizer.setOutputFormat(MapFileOutputFormat.class);
        try {
            LOG.info("Loops: starting finalizer");
            JobClient.runJob((JobConf)finalizer);
            LOG.info("Loops: finished finalizer");
        }
        catch (IOException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        long end = System.currentTimeMillis();
        LOG.info("Loops: finished at " + sdf.format(end) + ", elapsed: " + TimingUtil.elapsedTime(start, end));
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new Loops(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withArgName((String)"help");
        OptionBuilder.withDescription((String)"show this help message");
        Option helpOpts = OptionBuilder.create((String)"help");
        options.addOption(helpOpts);
        OptionBuilder.withArgName((String)"webgraphdb");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the web graph database to use");
        Option webGraphDbOpts = OptionBuilder.create((String)"webgraphdb");
        options.addOption(webGraphDbOpts);
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help") || !line.hasOption("webgraphdb")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("Loops", options);
                return -1;
            }
            String webGraphDb = line.getOptionValue("webgraphdb");
            this.findLoops(new Path(webGraphDb));
            return 0;
        }
        catch (Exception e) {
            LOG.error("Loops: " + StringUtils.stringifyException((Throwable)e));
            return -2;
        }
    }

    public static class Finalizer
    extends Configured
    implements Mapper<Text, Route, Text, Route>,
    Reducer<Text, Route, Text, LoopSet> {
        private JobConf conf;

        public Finalizer() {
        }

        public Finalizer(Configuration conf) {
            this.setConf(conf);
        }

        public void configure(JobConf conf) {
            this.conf = conf;
        }

        public void map(Text key, Route value, OutputCollector<Text, Route> output, Reporter reporter) throws IOException {
            if (value.isFound()) {
                String lookingFor = value.getLookingFor();
                output.collect((Object)new Text(lookingFor), (Object)value);
            }
        }

        public void reduce(Text key, Iterator<Route> values, OutputCollector<Text, LoopSet> output, Reporter reporter) throws IOException {
            LoopSet loops = new LoopSet();
            while (values.hasNext()) {
                Route route = values.next();
                loops.getLoopSet().add(route.getOutlinkUrl());
            }
            output.collect((Object)key, (Object)loops);
        }

        public void close() {
        }
    }

    public static class Looper
    extends Configured
    implements Mapper<Text, Writable, Text, ObjectWritable>,
    Reducer<Text, ObjectWritable, Text, Route> {
        private JobConf conf;
        private boolean last = false;

        public Looper() {
        }

        public Looper(Configuration conf) {
            this.setConf(conf);
        }

        public void configure(JobConf conf) {
            this.conf = conf;
            this.last = conf.getBoolean("last", false);
        }

        public void map(Text key, Writable value, OutputCollector<Text, ObjectWritable> output, Reporter reporter) throws IOException {
            ObjectWritable objWrite = new ObjectWritable();
            Object cloned = null;
            cloned = value instanceof LinkDatum ? new Text(((LinkDatum)value).getUrl()) : WritableUtils.clone((Writable)value, (Configuration)this.conf);
            objWrite.set(cloned);
            output.collect((Object)key, (Object)objWrite);
        }

        public void reduce(Text key, Iterator<ObjectWritable> values, OutputCollector<Text, Route> output, Reporter reporter) throws IOException {
            ArrayList<Writable> routeList = new ArrayList<Writable>();
            LinkedHashSet<String> outlinkUrls = new LinkedHashSet<String>();
            int numValues = 0;
            while (values.hasNext()) {
                String outlinkUrl;
                ObjectWritable next = values.next();
                Object value = next.get();
                if (value instanceof Route) {
                    routeList.add(WritableUtils.clone((Writable)((Route)value), (Configuration)this.conf));
                } else if (value instanceof Text && !outlinkUrls.contains(outlinkUrl = ((Text)value).toString())) {
                    outlinkUrls.add(outlinkUrl);
                }
                if (++numValues % 100 != 0) continue;
                reporter.progress();
            }
            ListIterator routeIt = routeList.listIterator();
            while (routeIt.hasNext()) {
                Route route = (Route)routeIt.next();
                routeIt.remove();
                if (route.isFound()) {
                    output.collect((Object)key, (Object)route);
                    continue;
                }
                String lookingFor = route.getLookingFor();
                if (outlinkUrls.contains(lookingFor)) {
                    route.setFound(true);
                    output.collect((Object)key, (Object)route);
                    continue;
                }
                if (this.last) continue;
                for (String outlink : outlinkUrls) {
                    output.collect((Object)new Text(outlink), (Object)route);
                }
            }
        }

        public void close() {
        }
    }

    public static class Initializer
    extends Configured
    implements Mapper<Text, Writable, Text, ObjectWritable>,
    Reducer<Text, ObjectWritable, Text, Route> {
        private JobConf conf;

        public Initializer() {
        }

        public Initializer(Configuration conf) {
            this.setConf(conf);
        }

        public void configure(JobConf conf) {
            this.conf = conf;
        }

        public void map(Text key, Writable value, OutputCollector<Text, ObjectWritable> output, Reporter reporter) throws IOException {
            ObjectWritable objWrite = new ObjectWritable();
            objWrite.set((Object)value);
            output.collect((Object)key, (Object)objWrite);
        }

        public void reduce(Text key, Iterator<ObjectWritable> values, OutputCollector<Text, Route> output, Reporter reporter) throws IOException {
            int numInlinks;
            String url = key.toString();
            Node node = null;
            ArrayList<LinkDatum> outlinkList = new ArrayList<LinkDatum>();
            while (values.hasNext()) {
                ObjectWritable objWrite = values.next();
                Object obj = objWrite.get();
                if (obj instanceof LinkDatum) {
                    outlinkList.add((LinkDatum)obj);
                    continue;
                }
                if (!(obj instanceof Node)) continue;
                node = (Node)obj;
            }
            if (node != null && (numInlinks = node.getNumInlinks()) > 0) {
                for (LinkDatum datum : outlinkList) {
                    String outlinkUrl = datum.getUrl();
                    Route route = new Route();
                    route.setFound(false);
                    route.setLookingFor(url);
                    route.setOutlinkUrl(outlinkUrl);
                    output.collect((Object)new Text(outlinkUrl), (Object)route);
                }
            }
        }

        public void close() {
        }
    }

    public static class LoopSet
    implements Writable {
        private Set<String> loopSet = new HashSet<String>();

        public Set<String> getLoopSet() {
            return this.loopSet;
        }

        public void setLoopSet(Set<String> loopSet) {
            this.loopSet = loopSet;
        }

        public void readFields(DataInput in) throws IOException {
            int numNodes = in.readInt();
            this.loopSet = new HashSet<String>();
            for (int i = 0; i < numNodes; ++i) {
                String url = Text.readString((DataInput)in);
                this.loopSet.add(url);
            }
        }

        public void write(DataOutput out) throws IOException {
            int numNodes = this.loopSet != null ? this.loopSet.size() : 0;
            out.writeInt(numNodes);
            for (String loop : this.loopSet) {
                Text.writeString((DataOutput)out, (String)loop);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (String loop : this.loopSet) {
                builder.append(loop + ",");
            }
            return builder.substring(0, builder.length() - 1);
        }
    }

    public static class Route
    implements Writable {
        private String outlinkUrl = null;
        private String lookingFor = null;
        private boolean found = false;

        public String getOutlinkUrl() {
            return this.outlinkUrl;
        }

        public void setOutlinkUrl(String outlinkUrl) {
            this.outlinkUrl = outlinkUrl;
        }

        public String getLookingFor() {
            return this.lookingFor;
        }

        public void setLookingFor(String lookingFor) {
            this.lookingFor = lookingFor;
        }

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean found) {
            this.found = found;
        }

        public void readFields(DataInput in) throws IOException {
            this.outlinkUrl = Text.readString((DataInput)in);
            this.lookingFor = Text.readString((DataInput)in);
            this.found = in.readBoolean();
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.outlinkUrl);
            Text.writeString((DataOutput)out, (String)this.lookingFor);
            out.writeBoolean(this.found);
        }
    }
}

