/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.webgraph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.metadata.Metadata;

public class Node
implements Writable {
    private int numInlinks = 0;
    private int numOutlinks = 0;
    private float inlinkScore = 1.0f;
    private Metadata metadata = new Metadata();

    public int getNumInlinks() {
        return this.numInlinks;
    }

    public void setNumInlinks(int numInlinks) {
        this.numInlinks = numInlinks;
    }

    public int getNumOutlinks() {
        return this.numOutlinks;
    }

    public void setNumOutlinks(int numOutlinks) {
        this.numOutlinks = numOutlinks;
    }

    public float getInlinkScore() {
        return this.inlinkScore;
    }

    public void setInlinkScore(float inlinkScore) {
        this.inlinkScore = inlinkScore;
    }

    public float getOutlinkScore() {
        return this.numOutlinks > 0 ? this.inlinkScore / (float)this.numOutlinks : this.inlinkScore;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void readFields(DataInput in) throws IOException {
        this.numInlinks = in.readInt();
        this.numOutlinks = in.readInt();
        this.inlinkScore = in.readFloat();
        this.metadata.clear();
        this.metadata.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.numInlinks);
        out.writeInt(this.numOutlinks);
        out.writeFloat(this.inlinkScore);
        this.metadata.write(out);
    }

    public String toString() {
        return "num inlinks: " + this.numInlinks + ", num outlinks: " + this.numOutlinks + ", inlink score: " + this.inlinkScore + ", outlink score: " + this.getOutlinkScore() + ", metadata: " + this.metadata.toString();
    }
}

