/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.webgraph;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.nutch.scoring.webgraph.Node;
import org.apache.nutch.util.FSUtils;
import org.apache.nutch.util.NutchConfiguration;

public class NodeReader
extends Configured {
    private FileSystem fs;
    private MapFile.Reader[] nodeReaders;

    public NodeReader() {
    }

    public NodeReader(Configuration conf) {
        super(conf);
    }

    public void dumpUrl(Path webGraphDb, String url) throws IOException {
        this.fs = FileSystem.get((Configuration)this.getConf());
        this.nodeReaders = MapFileOutputFormat.getReaders((FileSystem)this.fs, (Path)new Path(webGraphDb, "nodes"), (Configuration)this.getConf());
        Text key = new Text(url);
        Node node = new Node();
        MapFileOutputFormat.getEntry((MapFile.Reader[])this.nodeReaders, (Partitioner)new HashPartitioner(), (WritableComparable)key, (Writable)node);
        System.out.println(url + ":");
        System.out.println("  inlink score: " + node.getInlinkScore());
        System.out.println("  outlink score: " + node.getOutlinkScore());
        System.out.println("  num inlinks: " + node.getNumInlinks());
        System.out.println("  num outlinks: " + node.getNumOutlinks());
        FSUtils.closeReaders(this.nodeReaders);
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withArgName((String)"help");
        OptionBuilder.withDescription((String)"show this help message");
        Option helpOpts = OptionBuilder.create((String)"help");
        options.addOption(helpOpts);
        OptionBuilder.withArgName((String)"webgraphdb");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the webgraphdb to use");
        Option webGraphOpts = OptionBuilder.create((String)"webgraphdb");
        options.addOption(webGraphOpts);
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"the url to dump");
        Option urlOpts = OptionBuilder.create((String)"url");
        options.addOption(urlOpts);
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help") || !line.hasOption("webgraphdb") || !line.hasOption("url")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("WebGraphReader", options);
                return;
            }
            String webGraphDb = line.getOptionValue("webgraphdb");
            String url = line.getOptionValue("url");
            NodeReader reader = new NodeReader(NutchConfiguration.create());
            reader.dumpUrl(new Path(webGraphDb), url);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

