/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.segment;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileRecordReader;
import org.apache.nutch.protocol.Content;

public class ContentAsTextInputFormat
extends SequenceFileInputFormat<Text, Text> {
    public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new ContentAsTextRecordReader((Configuration)job, (FileSplit)split);
    }

    private static class ContentAsTextRecordReader
    implements RecordReader<Text, Text> {
        private final SequenceFileRecordReader<Text, Content> sequenceFileRecordReader;
        private Text innerKey;
        private Content innerValue;

        public ContentAsTextRecordReader(Configuration conf, FileSplit split) throws IOException {
            this.sequenceFileRecordReader = new SequenceFileRecordReader(conf, split);
            this.innerKey = (Text)this.sequenceFileRecordReader.createKey();
            this.innerValue = (Content)this.sequenceFileRecordReader.createValue();
        }

        public Text createKey() {
            return new Text();
        }

        public Text createValue() {
            return new Text();
        }

        public synchronized boolean next(Text key, Text value) throws IOException {
            Text tKey = key;
            Text tValue = value;
            if (!this.sequenceFileRecordReader.next((Object)this.innerKey, (Object)this.innerValue)) {
                return false;
            }
            tKey.set(this.innerKey.toString());
            String contentAsStr = new String(this.innerValue.getContent());
            contentAsStr = contentAsStr.replaceAll("\n", " ");
            value.set(contentAsStr);
            return true;
        }

        public float getProgress() throws IOException {
            return this.sequenceFileRecordReader.getProgress();
        }

        public synchronized long getPos() throws IOException {
            return this.sequenceFileRecordReader.getPos();
        }

        public synchronized void close() throws IOException {
            this.sequenceFileRecordReader.close();
        }
    }
}

