/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.segment;

import java.io.IOException;
import org.apache.hadoop.mapred.FileSplit;

public class SegmentPart {
    public String segmentName;
    public String partName;

    public SegmentPart() {
    }

    public SegmentPart(String segmentName, String partName) {
        this.segmentName = segmentName;
        this.partName = partName;
    }

    public String toString() {
        return this.segmentName + "/" + this.partName;
    }

    public static SegmentPart get(FileSplit split) throws IOException {
        return SegmentPart.get(split.getPath().toString());
    }

    public static SegmentPart get(String path) throws IOException {
        String dir = path.replace('\\', '/');
        int idx = dir.lastIndexOf("/part-");
        if (idx == -1) {
            throw new IOException("Cannot determine segment part: " + dir);
        }
        if ((idx = (dir = dir.substring(0, idx)).lastIndexOf(47)) == -1) {
            throw new IOException("Cannot determine segment part: " + dir);
        }
        String part = dir.substring(idx + 1);
        if ((idx = (dir = dir.substring(0, idx)).lastIndexOf(47)) == -1) {
            throw new IOException("Cannot determine segment name: " + dir);
        }
        String segment = dir.substring(idx + 1);
        return new SegmentPart(segment, part);
    }

    public static SegmentPart parse(String string) throws IOException {
        int idx = string.indexOf(47);
        if (idx == -1) {
            throw new IOException("Invalid SegmentPart: '" + string + "'");
        }
        String segment = string.substring(0, idx);
        String part = string.substring(idx + 1);
        return new SegmentPart(segment, part);
    }
}

