/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools.proxy;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.metadata.Nutch;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.ProtocolStatus;
import org.apache.nutch.tools.proxy.AbstractTestbedHandler;
import org.mortbay.jetty.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentHandler
extends AbstractTestbedHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentHandler.class);
    private Segment seg;
    private static HashMap<Integer, Integer> protoCodes = new HashMap();

    public SegmentHandler(Configuration conf, Path name) throws Exception {
        this.seg = new Segment(FileSystem.get((Configuration)conf), name, conf);
    }

    @Override
    public void handle(Request req, HttpServletResponse res, String target, int dispatch) throws IOException, ServletException {
        try {
            String uri = req.getUri().toString();
            LOG.info("URI: " + uri);
            this.addMyHeader(res, "URI", uri);
            Text url = new Text(uri.toString());
            CrawlDatum cd = this.seg.getCrawlDatum(url);
            if (cd != null) {
                this.addMyHeader(res, "Res", "found");
                LOG.info("-got " + cd.toString());
                ProtocolStatus ps = (ProtocolStatus)cd.getMetaData().get((Object)Nutch.WRITABLE_PROTO_STATUS_KEY);
                if (ps != null) {
                    Integer TrCode = protoCodes.get(ps.getCode());
                    if (TrCode != null) {
                        res.setStatus(TrCode.intValue());
                    } else {
                        res.setStatus(200);
                    }
                    this.addMyHeader(res, "ProtocolStatus", ps.toString());
                } else {
                    res.setStatus(200);
                }
                Content c = this.seg.getContent(url);
                if (c == null) {
                    req.setHandled(true);
                    res.addHeader("X-Handled-By", ((Object)((Object)this)).getClass().getSimpleName());
                    return;
                }
                byte[] data = c.getContent();
                LOG.debug("-data len=" + data.length);
                Metadata meta = c.getMetadata();
                String[] names = meta.names();
                LOG.debug("- " + names.length + " meta");
                for (int i = 0; i < names.length; ++i) {
                    boolean my = true;
                    char ch = names[i].charAt(0);
                    if (Character.isLetter(ch) && Character.isUpperCase(ch)) {
                        my = false;
                    }
                    String[] values = meta.getValues(names[i]);
                    for (int k = 0; k < values.length; ++k) {
                        if (my) {
                            this.addMyHeader(res, names[i], values[k]);
                            continue;
                        }
                        res.addHeader(names[i], values[k]);
                    }
                }
                req.setHandled(true);
                res.addHeader("X-Handled-By", ((Object)((Object)this)).getClass().getSimpleName());
                res.setContentType(meta.get("Content-Type"));
                res.setContentLength(data.length);
                ServletOutputStream os = res.getOutputStream();
                os.write(data, 0, data.length);
                res.flushBuffer();
            } else {
                this.addMyHeader(res, "Res", "not found");
                LOG.info(" -not found " + url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.warn(StringUtils.stringifyException((Throwable)e));
            this.addMyHeader(res, "Res", "Exception: " + StringUtils.stringifyException((Throwable)e));
        }
    }

    static {
        protoCodes.put(17, 401);
        protoCodes.put(23, 503);
        protoCodes.put(16, 500);
        protoCodes.put(2, 400);
        protoCodes.put(11, 410);
        protoCodes.put(12, 301);
        protoCodes.put(20, 400);
        protoCodes.put(14, 404);
        protoCodes.put(21, 304);
        protoCodes.put(10, 400);
        protoCodes.put(19, 400);
        protoCodes.put(15, 400);
        protoCodes.put(18, 403);
        protoCodes.put(1, 200);
        protoCodes.put(13, 302);
        protoCodes.put(22, 400);
    }

    private static class Segment
    implements Closeable {
        private static final Partitioner<Text, Writable> PARTITIONER = new HashPartitioner();
        private Path segmentDir;
        private Object cLock = new Object();
        private Object crawlLock = new Object();
        private MapFile.Reader[] content;
        private MapFile.Reader[] parseText;
        private MapFile.Reader[] parseData;
        private MapFile.Reader[] crawl;
        private Configuration conf;

        public Segment(FileSystem fs, Path segmentDir, Configuration conf) throws IOException {
            this.segmentDir = segmentDir;
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CrawlDatum getCrawlDatum(Text url) throws IOException {
            Object object = this.crawlLock;
            synchronized (object) {
                if (this.crawl == null) {
                    this.crawl = this.getReaders("crawl_fetch");
                }
            }
            return (CrawlDatum)this.getEntry(this.crawl, url, (Writable)new CrawlDatum());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Content getContent(Text url) throws IOException {
            Object object = this.cLock;
            synchronized (object) {
                if (this.content == null) {
                    this.content = this.getReaders("content");
                }
            }
            return (Content)this.getEntry(this.content, url, new Content());
        }

        private MapFile.Reader[] getReaders(String subDir) throws IOException {
            Path dir = new Path(this.segmentDir, subDir);
            FileSystem fs = dir.getFileSystem(this.conf);
            Object[] names = FileUtil.stat2Paths((FileStatus[])fs.listStatus(dir, (PathFilter)SegmentPathFilter.INSTANCE));
            Arrays.sort(names);
            MapFile.Reader[] parts = new MapFile.Reader[names.length];
            for (int i = 0; i < names.length; ++i) {
                parts[i] = new MapFile.Reader(fs, names[i].toString(), this.conf);
            }
            return parts;
        }

        private Writable getEntry(MapFile.Reader[] readers, Text url, Writable entry) throws IOException {
            return MapFileOutputFormat.getEntry((MapFile.Reader[])readers, PARTITIONER, (WritableComparable)url, (Writable)entry);
        }

        @Override
        public void close() throws IOException {
            if (this.content != null) {
                this.closeReaders(this.content);
            }
            if (this.parseText != null) {
                this.closeReaders(this.parseText);
            }
            if (this.parseData != null) {
                this.closeReaders(this.parseData);
            }
            if (this.crawl != null) {
                this.closeReaders(this.crawl);
            }
        }

        private void closeReaders(MapFile.Reader[] readers) throws IOException {
            for (int i = 0; i < readers.length; ++i) {
                readers[i].close();
            }
        }
    }

    private static class SegmentPathFilter
    implements PathFilter {
        public static final SegmentPathFilter INSTANCE = new SegmentPathFilter();

        private SegmentPathFilter() {
        }

        public boolean accept(Path p) {
            return p.getName().startsWith("part-");
        }
    }
}

