/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools.proxy;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.tools.proxy.DelayHandler;
import org.apache.nutch.tools.proxy.FakeHandler;
import org.apache.nutch.tools.proxy.LogDebugHandler;
import org.apache.nutch.tools.proxy.NotFoundHandler;
import org.apache.nutch.tools.proxy.SegmentHandler;
import org.apache.nutch.util.HadoopFSUtil;
import org.apache.nutch.util.NutchConfiguration;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.proxy.AsyncProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedProxy {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedProxy.class);

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("TestbedProxy [-seg <segment_name> | -segdir <segments>] [-port <nnn>] [-forward] [-fake] [-delay nnn] [-debug]");
            System.err.println("-seg <segment_name>\tpath to a single segment (can be specified multiple times)");
            System.err.println("-segdir <segments>\tpath to a parent directory of multiple segments (as above)");
            System.err.println("-port <nnn>\trun the proxy on port <nnn> (special permissions may be needed for ports < 1024)");
            System.err.println("-forward\tif specified, requests to all unknown urls will be passed to");
            System.err.println("\t\toriginal servers. If false (default) unknown urls generate 404 Not Found.");
            System.err.println("-delay\tdelay every response by nnn seconds. If delay is negative use a random value up to nnn");
            System.err.println("-fake\tif specified, requests to all unknown urls will succeed with fake content");
            System.exit(-1);
        }
        Configuration conf = NutchConfiguration.create();
        int port = conf.getInt("segment.proxy.port", 8181);
        boolean forward = false;
        boolean fake = false;
        boolean delay = false;
        boolean debug = false;
        int delayVal = 0;
        HashSet<Path> segs = new HashSet<Path>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-segdir")) {
                FileSystem fs = FileSystem.get((Configuration)conf);
                FileStatus[] fstats = fs.listStatus(new Path(args[++i]));
                Path[] paths = HadoopFSUtil.getPaths(fstats);
                segs.addAll(Arrays.asList(paths));
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-forward")) {
                forward = true;
                continue;
            }
            if (args[i].equals("-delay")) {
                delay = true;
                delayVal = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-fake")) {
                fake = true;
                continue;
            }
            if (args[i].equals("-debug")) {
                debug = true;
                continue;
            }
            if (args[i].equals("-seg")) {
                segs.add(new Path(args[++i]));
                continue;
            }
            LOG.error("Unknown argument: " + args[i]);
            System.exit(-1);
        }
        Server server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setPort(port);
        connector.setResolveNames(false);
        server.addConnector((Connector)connector);
        HandlerList list = new HandlerList();
        server.addHandler((Handler)list);
        if (debug) {
            LOG.info("* Added debug handler.");
            list.addHandler((Handler)new LogDebugHandler());
        }
        if (delay) {
            LOG.info("* Added delay handler: " + (delayVal < 0 ? "random delay up to " + -delayVal : "constant delay of " + delayVal));
            list.addHandler((Handler)new DelayHandler(delayVal));
        }
        for (Path p : segs) {
            try {
                SegmentHandler segment = new SegmentHandler(conf, p);
                list.addHandler((Handler)segment);
                LOG.info("* Added segment handler for: " + p);
            }
            catch (Exception e) {
                LOG.warn("Skipping segment '" + p + "': " + StringUtils.stringifyException((Throwable)e));
            }
        }
        if (forward) {
            LOG.info("* Adding forwarding proxy for all unknown urls ...");
            ServletHandler servlets = new ServletHandler();
            servlets.addServletWithMapping(AsyncProxyServlet.class, "/*");
            servlets.addFilterWithMapping(LogDebugHandler.class, "/*", 15);
            list.addHandler((Handler)servlets);
        }
        if (fake) {
            LOG.info("* Added fake handler for remaining URLs.");
            list.addHandler((Handler)new FakeHandler());
        }
        list.addHandler((Handler)new NotFoundHandler());
        server.start();
        server.join();
    }
}

