/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;

public class FSUtils {
    public static void replace(FileSystem fs, Path current, Path replacement, boolean removeOld) throws IOException {
        Path old = new Path(current + ".old");
        if (fs.exists(current)) {
            fs.rename(current, old);
        }
        fs.rename(replacement, current);
        if (fs.exists(old) && removeOld) {
            fs.delete(old, true);
        }
    }

    public static void closeReaders(SequenceFile.Reader[] readers) throws IOException {
        if (readers != null) {
            for (int i = 0; i < readers.length; ++i) {
                SequenceFile.Reader reader = readers[i];
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    public static void closeReaders(MapFile.Reader[] readers) throws IOException {
        if (readers != null) {
            for (int i = 0; i < readers.length; ++i) {
                MapFile.Reader reader = readers[i];
                if (reader == null) continue;
                reader.close();
            }
        }
    }
}

