/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.File;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.util.ObjectCache;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeUtil {
    private static final String SEPARATOR = ";";
    private MimeTypes mimeTypes;
    private Tika tika = new Tika();
    private boolean mimeMagic;
    private static final Logger LOG = LoggerFactory.getLogger((String)MimeUtil.class.getName());

    public MimeUtil(Configuration conf) {
        ObjectCache objectCache = ObjectCache.get(conf);
        MimeTypes mimeTypez = (MimeTypes)objectCache.getObject(MimeTypes.class.getName());
        if (mimeTypez == null) {
            try {
                String customMimeTypeFile = conf.get("mime.types.file");
                if (customMimeTypeFile != null && !customMimeTypeFile.equals("")) {
                    try {
                        mimeTypez = MimeTypesFactory.create((InputStream)conf.getConfResourceAsInputStream(customMimeTypeFile));
                    }
                    catch (Exception e) {
                        LOG.error("Can't load mime.types.file : " + customMimeTypeFile + " using Tika's default");
                    }
                }
                if (mimeTypez == null) {
                    mimeTypez = MimeTypes.getDefaultMimeTypes();
                }
            }
            catch (Exception e) {
                LOG.error("Exception in MimeUtil " + e.getMessage());
                throw new RuntimeException(e);
            }
            objectCache.setObject(MimeTypes.class.getName(), mimeTypez);
        }
        this.mimeTypes = mimeTypez;
        this.mimeMagic = conf.getBoolean("mime.type.magic", true);
    }

    public static String cleanMimeType(String origType) {
        if (origType == null) {
            return null;
        }
        String[] tokenizedMimeType = origType.split(SEPARATOR);
        if (tokenizedMimeType.length > 1) {
            return tokenizedMimeType[0];
        }
        return origType;
    }

    public String autoResolveContentType(String typeName, String url, byte[] data) {
        String retType = null;
        String magicType = null;
        MimeType type = null;
        String cleanedMimeType = null;
        try {
            cleanedMimeType = MimeUtil.cleanMimeType(typeName) != null ? this.mimeTypes.forName(MimeUtil.cleanMimeType(typeName)).getName() : null;
        }
        catch (MimeTypeException mte) {
            // empty catch block
        }
        try {
            type = cleanedMimeType != null ? this.mimeTypes.forName(cleanedMimeType) : null;
        }
        catch (MimeTypeException e) {
            type = null;
        }
        if (type == null || type != null && type.getName().equals("application/octet-stream")) {
            try {
                TikaConfig tikaConfig = TikaConfig.getDefaultConfig();
                Tika tika = new Tika(tikaConfig);
                retType = tika.detect(url) != null ? tika.detect(url) : null;
            }
            catch (Exception e) {
                String message = "Problem loading default Tika configuration";
                LOG.error(message, (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            retType = type.getName();
        }
        if (this.mimeMagic) {
            magicType = this.tika.detect(data);
            if (!(magicType == null || magicType.equals("application/octet-stream") || magicType.equals("text/plain") || retType == null || retType.equals(magicType))) {
                retType = magicType;
            }
            if (retType == null) {
                try {
                    retType = "application/octet-stream";
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
        return retType;
    }

    public String getMimeType(String url) {
        return this.tika.detect(url);
    }

    public String forName(String name) {
        try {
            return this.mimeTypes.forName(name).toString();
        }
        catch (MimeTypeException e) {
            LOG.error("Exception getting mime type by name: [" + name + "]: Message: " + e.getMessage());
            return null;
        }
    }

    public String getMimeType(File f) {
        try {
            return this.tika.detect(f);
        }
        catch (Exception e) {
            LOG.error("Exception getting mime type for file: [" + f.getPath() + "]: Message: " + e.getMessage());
            return null;
        }
    }
}

