/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectCache {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectCache.class);
    private static final WeakHashMap<Configuration, ObjectCache> CACHE = new WeakHashMap();
    private final HashMap<String, Object> objectMap = new HashMap();

    private ObjectCache() {
    }

    public static synchronized ObjectCache get(Configuration conf) {
        ObjectCache objectCache = CACHE.get(conf);
        if (objectCache == null) {
            LOG.debug("No object cache found for conf=" + conf + ", instantiating a new object cache");
            objectCache = new ObjectCache();
            CACHE.put(conf, objectCache);
        }
        return objectCache;
    }

    public synchronized Object getObject(String key) {
        return this.objectMap.get(key);
    }

    public synchronized void setObject(String key, Object value) {
        this.objectMap.put(key, value);
    }
}

