/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import org.apache.nutch.util.EncodingDetector;

public class StringUtil {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String rightPad(String s, int length) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = length - s.length(); i > 0; --i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String leftPad(String s, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = length - s.length(); i > 0; --i) {
            sb.append(" ");
        }
        sb.append(s);
        return sb.toString();
    }

    public static String toHexString(byte[] buf) {
        return StringUtil.toHexString(buf, null, Integer.MAX_VALUE);
    }

    public static String toHexString(byte[] buf, String sep, int lineLen) {
        if (buf == null) {
            return null;
        }
        if (lineLen <= 0) {
            lineLen = Integer.MAX_VALUE;
        }
        StringBuffer res = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            res.append(HEX_DIGITS[b >> 4 & 0xF]);
            res.append(HEX_DIGITS[b & 0xF]);
            if (i > 0 && i % lineLen == 0) {
                res.append('\n');
                continue;
            }
            if (sep == null || i >= lineLen - 1) continue;
            res.append(sep);
        }
        return res.toString();
    }

    public static byte[] fromHexString(String text) {
        if ((text = text.trim()).length() % 2 != 0) {
            text = "0" + text;
        }
        int resLen = text.length() / 2;
        byte[] res = new byte[resLen];
        for (int i = 0; i < resLen; ++i) {
            int j = i << 1;
            int hiNibble = StringUtil.charToNibble(text.charAt(j));
            int loNibble = StringUtil.charToNibble(text.charAt(j + 1));
            if (loNibble == -1 || hiNibble == -1) {
                return null;
            }
            res[i] = (byte)(hiNibble << 4 | loNibble);
        }
        return res;
    }

    private static final int charToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        return -1;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    public static String cleanField(String value) {
        return value.replaceAll("\ufffd", "");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: StringUtil <encoding name>");
        } else {
            System.out.println(args[0] + " is resolved to " + EncodingDetector.resolveEncodingAlias(args[0]));
        }
    }
}

