/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.nutch.util.domain.DomainSuffix;
import org.apache.nutch.util.domain.DomainSuffixes;

public class URLUtil {
    private static Pattern IP_PATTERN = Pattern.compile("(\\d{1,3}\\.){3}(\\d{1,3})");

    public static URL resolveURL(URL base, String target) throws MalformedURLException {
        if ((target = target.trim()).startsWith("?")) {
            return URLUtil.fixPureQueryTargets(base, target);
        }
        return new URL(base, target);
    }

    static URL fixPureQueryTargets(URL base, String target) throws MalformedURLException {
        if (!target.startsWith("?")) {
            return new URL(base, target);
        }
        String basePath = base.getPath();
        String baseRightMost = "";
        int baseRightMostIdx = basePath.lastIndexOf("/");
        if (baseRightMostIdx != -1) {
            baseRightMost = basePath.substring(baseRightMostIdx + 1);
        }
        if (target.startsWith("?")) {
            target = baseRightMost + target;
        }
        return new URL(base, target);
    }

    private static URL fixEmbeddedParams(URL base, String target) throws MalformedURLException {
        if (target.indexOf(59) >= 0 || base.toString().indexOf(59) == -1) {
            return new URL(base, target);
        }
        String baseURL = base.toString();
        int startParams = baseURL.indexOf(59);
        String params = baseURL.substring(startParams);
        int startQS = target.indexOf(63);
        target = startQS >= 0 ? target.substring(0, startQS) + params + target.substring(startQS) : target + params;
        return new URL(base, target);
    }

    public static String getDomainName(URL url) {
        DomainSuffixes tlds = DomainSuffixes.getInstance();
        String host = url.getHost();
        if (host.endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        if (IP_PATTERN.matcher(host).matches()) {
            return host;
        }
        int index = 0;
        String candidate = host;
        while (index >= 0) {
            index = candidate.indexOf(46);
            String subCandidate = candidate.substring(index + 1);
            if (tlds.isDomainSuffix(subCandidate)) {
                return candidate;
            }
            candidate = subCandidate;
        }
        return candidate;
    }

    public static String getDomainName(String url) throws MalformedURLException {
        return URLUtil.getDomainName(new URL(url));
    }

    public static String getTopLevelDomainName(URL url) throws MalformedURLException {
        String suffix = URLUtil.getDomainSuffix(url).toString();
        int idx = suffix.lastIndexOf(".");
        if (idx != -1) {
            return suffix.substring(idx + 1);
        }
        return suffix;
    }

    public static String getTopLevelDomainName(String url) throws MalformedURLException {
        return URLUtil.getTopLevelDomainName(new URL(url));
    }

    public static boolean isSameDomainName(URL url1, URL url2) {
        return URLUtil.getDomainName(url1).equalsIgnoreCase(URLUtil.getDomainName(url2));
    }

    public static boolean isSameDomainName(String url1, String url2) throws MalformedURLException {
        return URLUtil.isSameDomainName(new URL(url1), new URL(url2));
    }

    public static DomainSuffix getDomainSuffix(URL url) {
        DomainSuffixes tlds = DomainSuffixes.getInstance();
        String host = url.getHost();
        if (IP_PATTERN.matcher(host).matches()) {
            return null;
        }
        int index = 0;
        String candidate = host;
        while (index >= 0) {
            index = candidate.indexOf(46);
            String subCandidate = candidate.substring(index + 1);
            DomainSuffix d = tlds.get(subCandidate);
            if (d != null) {
                return d;
            }
            candidate = subCandidate;
        }
        return null;
    }

    public static DomainSuffix getDomainSuffix(String url) throws MalformedURLException {
        return URLUtil.getDomainSuffix(new URL(url));
    }

    public static String[] getHostSegments(URL url) {
        String host = url.getHost();
        if (IP_PATTERN.matcher(host).matches()) {
            return new String[]{host};
        }
        return host.split("\\.");
    }

    public static String[] getHostSegments(String url) throws MalformedURLException {
        return URLUtil.getHostSegments(new URL(url));
    }

    public static String chooseRepr(String src, String dst, boolean temp) {
        boolean destRoot;
        URL dstUrl;
        URL srcUrl;
        try {
            srcUrl = new URL(src);
            dstUrl = new URL(dst);
        }
        catch (MalformedURLException e) {
            return dst;
        }
        String srcDomain = URLUtil.getDomainName(srcUrl);
        String dstDomain = URLUtil.getDomainName(dstUrl);
        String srcHost = srcUrl.getHost();
        String dstHost = dstUrl.getHost();
        String srcFile = srcUrl.getFile();
        String dstFile = dstUrl.getFile();
        boolean srcRoot = srcFile.equals("/") || srcFile.length() == 0;
        boolean bl = destRoot = dstFile.equals("/") || dstFile.length() == 0;
        if (!srcDomain.equals(dstDomain)) {
            return dst;
        }
        if (!temp) {
            if (srcRoot) {
                return src;
            }
            return dst;
        }
        if (srcRoot && !destRoot) {
            return src;
        }
        if (!srcRoot && destRoot) {
            return dst;
        }
        if (!srcRoot && !destRoot && srcHost.equals(dstHost)) {
            int numDstPaths;
            int numSrcPaths = srcFile.split("/").length;
            if (numSrcPaths != (numDstPaths = dstFile.split("/").length)) {
                return numDstPaths < numSrcPaths ? dst : src;
            }
            int srcPathLength = srcFile.length();
            int dstPathLength = dstFile.length();
            return dstPathLength < srcPathLength ? dst : src;
        }
        int numSrcSubs = srcHost.split("\\.").length;
        int numDstSubs = dstHost.split("\\.").length;
        return numDstSubs < numSrcSubs ? dst : src;
    }

    public static String getHost(String url) {
        try {
            return new URL(url).getHost().toLowerCase();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getPage(String url) {
        try {
            url = url.toLowerCase();
            String queryStr = new URL(url).getQuery();
            return queryStr != null ? url.replace("?" + queryStr, "") : url;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getProtocol(String url) {
        try {
            return URLUtil.getProtocol(new URL(url));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getProtocol(URL url) {
        return url.getProtocol();
    }

    public static String toASCII(String url) {
        try {
            URL u = new URL(url);
            URI p = new URI(u.getProtocol(), u.getUserInfo(), IDN.toASCII(u.getHost()), u.getPort(), u.getPath(), u.getQuery(), u.getRef());
            return p.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toUNICODE(String url) {
        try {
            URL u = new URL(url);
            StringBuilder sb = new StringBuilder();
            sb.append(u.getProtocol());
            sb.append("://");
            if (u.getUserInfo() != null) {
                sb.append(u.getUserInfo());
                sb.append('@');
            }
            sb.append(IDN.toUnicode(u.getHost()));
            if (u.getPort() != -1) {
                sb.append(':');
                sb.append(u.getPort());
            }
            sb.append(u.getFile());
            if (u.getRef() != null) {
                sb.append('#');
                sb.append(u.getRef());
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage : URLUtil <url>");
            return;
        }
        String url = args[0];
        try {
            System.out.println(URLUtil.getDomainName(new URL(url)));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }
}

