/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util.domain;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.TimingUtil;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainStatistics
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(DomainStatistics.class);
    private static final Text FETCHED_TEXT = new Text("FETCHED");
    private static final Text NOT_FETCHED_TEXT = new Text("NOT_FETCHED");
    private static final int MODE_HOST = 1;
    private static final int MODE_DOMAIN = 2;
    private static final int MODE_SUFFIX = 3;
    private static final int MODE_TLD = 4;
    private int mode = 0;

    public int run(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("usage: DomainStatistics inputDirs outDir host|domain|suffix|tld [numOfReducer]");
            return 1;
        }
        String inputDir = args[0];
        String outputDir = args[1];
        int numOfReducers = 1;
        if (args.length > 3) {
            numOfReducers = Integer.parseInt(args[3]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long start = System.currentTimeMillis();
        LOG.info("DomainStatistics: starting at " + sdf.format(start));
        int mode = 0;
        String jobName = "DomainStatistics";
        if (args[2].equals("host")) {
            jobName = "Host statistics";
            mode = 1;
        } else if (args[2].equals("domain")) {
            jobName = "Domain statistics";
            mode = 2;
        } else if (args[2].equals("suffix")) {
            jobName = "Suffix statistics";
            mode = 3;
        } else if (args[2].equals("tld")) {
            jobName = "TLD statistics";
            mode = 4;
        }
        Configuration conf = this.getConf();
        conf.setInt("domain.statistics.mode", mode);
        conf.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
        Job job = new Job(conf, jobName);
        job.setJarByClass(DomainStatistics.class);
        String[] inputDirsSpecs = inputDir.split(",");
        for (int i = 0; i < inputDirsSpecs.length; ++i) {
            FileInputFormat.addInputPath((Job)job, (Path)new Path(inputDirsSpecs[i]));
        }
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputDir));
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(DomainStatisticsMapper.class);
        job.setReducerClass(DomainStatisticsReducer.class);
        job.setCombinerClass(DomainStatisticsCombiner.class);
        job.setNumReduceTasks(numOfReducers);
        job.waitForCompletion(true);
        long end = System.currentTimeMillis();
        LOG.info("DomainStatistics: finished at " + sdf.format(end) + ", elapsed: " + TimingUtil.elapsedTime(start, end));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new DomainStatistics(), (String[])args);
    }

    public static class DomainStatisticsCombiner
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long total = 0L;
            for (LongWritable val : values) {
                total += val.get();
            }
            context.write((Object)key, (Object)new LongWritable(total));
        }
    }

    static class DomainStatisticsReducer
    extends Reducer<Text, LongWritable, LongWritable, Text> {
        DomainStatisticsReducer() {
        }

        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long total = 0L;
            for (LongWritable val : values) {
                total += val.get();
            }
            context.write((Object)new LongWritable(total), (Object)key);
        }
    }

    static class DomainStatisticsMapper
    extends Mapper<Text, CrawlDatum, Text, LongWritable> {
        int mode = 0;

        DomainStatisticsMapper() {
        }

        public void setup(Mapper.Context context) {
            this.mode = context.getConfiguration().getInt("domain.statistics.mode", 2);
        }

        public void map(Text urlText, CrawlDatum datum, Mapper.Context context) throws IOException, InterruptedException {
            if (datum.getStatus() == 2 || datum.getStatus() == 6) {
                try {
                    URL url = new URL(urlText.toString());
                    String out = null;
                    switch (this.mode) {
                        case 1: {
                            out = url.getHost();
                            break;
                        }
                        case 2: {
                            out = URLUtil.getDomainName(url);
                            break;
                        }
                        case 3: {
                            out = URLUtil.getDomainSuffix(url).getDomain();
                            break;
                        }
                        case 4: {
                            out = URLUtil.getTopLevelDomainName(url);
                        }
                    }
                    if (out.trim().equals("")) {
                        LOG.info("url : " + url);
                        context.getCounter((Enum)MyCounter.EMPTY_RESULT).increment(1L);
                    }
                    context.write((Object)new Text(out), (Object)new LongWritable(1L));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                context.getCounter((Enum)MyCounter.FETCHED).increment(1L);
                context.write((Object)FETCHED_TEXT, (Object)new LongWritable(1L));
            } else {
                context.getCounter((Enum)MyCounter.NOT_FETCHED).increment(1L);
                context.write((Object)NOT_FETCHED_TEXT, (Object)new LongWritable(1L));
            }
        }
    }

    public static enum MyCounter {
        FETCHED,
        NOT_FETCHED,
        EMPTY_RESULT;

    }
}

