/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util.domain;

import java.io.InputStream;
import java.util.HashMap;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.util.domain.DomainSuffix;
import org.apache.nutch.util.domain.DomainSuffixesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainSuffixes {
    private static final Logger LOG = LoggerFactory.getLogger(DomainSuffixes.class);
    private HashMap<String, DomainSuffix> domains = new HashMap();
    private static DomainSuffixes instance;

    private DomainSuffixes() {
        String file = "domain-suffixes.xml";
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(file);
        try {
            new DomainSuffixesReader().read(this, input);
        }
        catch (Exception ex) {
            LOG.warn(StringUtils.stringifyException((Throwable)ex));
        }
    }

    public static DomainSuffixes getInstance() {
        if (instance == null) {
            instance = new DomainSuffixes();
        }
        return instance;
    }

    void addDomainSuffix(DomainSuffix tld) {
        this.domains.put(tld.getDomain(), tld);
    }

    public boolean isDomainSuffix(String extension) {
        return this.domains.containsKey(extension);
    }

    public DomainSuffix get(String extension) {
        return this.domains.get(extension);
    }
}

