/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse.zip;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.parse.Outlink;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.parse.ParseImpl;
import org.apache.nutch.parse.ParseResult;
import org.apache.nutch.parse.ParseStatus;
import org.apache.nutch.parse.Parser;
import org.apache.nutch.parse.zip.ZipTextExtractor;
import org.apache.nutch.protocol.Content;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipParser
implements Parser {
    private static final Logger LOG = LoggerFactory.getLogger(ZipParser.class);
    private Configuration conf;

    public ParseResult getParse(Content content) {
        String resultText = null;
        String resultTitle = null;
        Outlink[] outlinks = null;
        ArrayList<Outlink> outLinksList = new ArrayList<Outlink>();
        try {
            String contentLen = content.getMetadata().get("Content-Length");
            int len = Integer.parseInt(contentLen);
            if (LOG.isDebugEnabled()) {
                LOG.debug("ziplen: " + len);
            }
            byte[] contentInBytes = content.getContent();
            if (contentLen != null && contentInBytes.length != len) {
                return new ParseStatus(2, 202, "Content truncated at " + contentInBytes.length + " bytes. Parser can't handle incomplete pdf file.").getEmptyParseResult(content.getUrl(), this.getConf());
            }
            ZipTextExtractor extractor = new ZipTextExtractor(this.getConf());
            resultText = extractor.extractText(new ByteArrayInputStream(contentInBytes), content.getUrl(), outLinksList);
        }
        catch (Exception e) {
            return new ParseStatus(2, "Can't be handled as Zip document. " + e).getEmptyParseResult(content.getUrl(), this.getConf());
        }
        if (resultText == null) {
            resultText = "";
        }
        if (resultTitle == null) {
            resultTitle = "";
        }
        outlinks = outLinksList.toArray(new Outlink[0]);
        ParseData parseData = new ParseData(ParseStatus.STATUS_SUCCESS, resultTitle, outlinks, content.getMetadata());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Zip file parsed sucessfully !!");
        }
        return ParseResult.createParseResult((String)content.getUrl(), (Parse)new ParseImpl(resultText, parseData));
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

