/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.urlfilter.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLFilter;
import org.apache.nutch.urlfilter.api.RegexRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RegexURLFilterBase
implements URLFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RegexURLFilterBase.class);
    private List<RegexRule> rules;
    private Configuration conf;

    public RegexURLFilterBase() {
    }

    public RegexURLFilterBase(File filename) throws IOException, IllegalArgumentException {
        this(new FileReader(filename));
    }

    public RegexURLFilterBase(String rules) throws IOException, IllegalArgumentException {
        this(new StringReader(rules));
    }

    protected RegexURLFilterBase(Reader reader) throws IOException, IllegalArgumentException {
        this.rules = this.readRules(reader);
    }

    protected abstract RegexRule createRule(boolean var1, String var2);

    protected abstract Reader getRulesReader(Configuration var1) throws IOException;

    public String filter(String url) {
        for (RegexRule rule : this.rules) {
            if (!rule.match(url)) continue;
            return rule.accept() ? url : null;
        }
        return null;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        Reader reader = null;
        try {
            reader = this.getRulesReader(conf);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.getMessage());
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            this.rules = this.readRules(reader);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.getMessage());
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    private List<RegexRule> readRules(Reader reader) throws IOException, IllegalArgumentException {
        String line;
        BufferedReader in = new BufferedReader(reader);
        ArrayList<RegexRule> rules = new ArrayList<RegexRule>();
        block5: while ((line = in.readLine()) != null) {
            if (line.length() == 0) continue;
            char first = line.charAt(0);
            boolean sign = false;
            switch (first) {
                case '+': {
                    sign = true;
                    break;
                }
                case '-': {
                    sign = false;
                    break;
                }
                case '\n': 
                case ' ': 
                case '#': {
                    continue block5;
                }
                default: {
                    throw new IOException("Invalid first character: " + line);
                }
            }
            String regex = line.substring(1);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Adding rule [" + regex + "]");
            }
            RegexRule rule = this.createRule(sign, regex);
            rules.add(rule);
        }
        return rules;
    }

    public static void main(RegexURLFilterBase filter, String[] args) throws IOException, IllegalArgumentException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null) {
            String out = filter.filter(line);
            if (out != null) {
                System.out.print("+");
                System.out.println(out);
                continue;
            }
            System.out.print("-");
            System.out.println(line);
        }
    }
}

