/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd.models;

import java.util.HashMap;
import org.apache.xerces.impl.dtd.models.CMAny;
import org.apache.xerces.impl.dtd.models.CMBinOp;
import org.apache.xerces.impl.dtd.models.CMLeaf;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.impl.dtd.models.CMUniOp;
import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.xni.QName;

public class DFAContentModel
implements ContentModelValidator {
    private static String fEpsilonString = "<<CMNODE_EPSILON>>";
    private static String fEOCString = "<<CMNODE_EOC>>";
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private QName[] fElemMap = null;
    private int[] fElemMapType = null;
    private int fElemMapSize = 0;
    private boolean fMixed;
    private int fEOCPos = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private CMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;
    private final QName fQName = new QName();

    static {
        fEpsilonString = fEpsilonString.intern();
        fEOCString = fEOCString.intern();
    }

    public DFAContentModel(CMNode cMNode, int n, boolean bl) {
        this.fLeafCount = n;
        this.fMixed = bl;
        this.buildDFA(cMNode);
    }

    public int validate(QName[] qNameArray, int n, int n2) {
        if (n2 == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            QName qName = qNameArray[n + n4];
            if (!this.fMixed || qName.localpart != null) {
                int n5 = 0;
                while (n5 < this.fElemMapSize) {
                    String string;
                    int n6 = this.fElemMapType[n5] & 0xF;
                    if (n6 == 0 ? this.fElemMap[n5].rawname == qName.rawname : (n6 == 6 ? (string = this.fElemMap[n5].uri) == null || string == qName.uri : (n6 == 8 ? qName.uri == null : n6 == 7 && this.fElemMap[n5].uri != qName.uri))) break;
                    ++n5;
                }
                if (n5 == this.fElemMapSize) {
                    return n4;
                }
                if ((n3 = this.fTransTable[n3][n5]) == -1) {
                    return n4;
                }
            }
            ++n4;
        }
        if (!this.fFinalStateFlags[n3]) {
            return n2;
        }
        return -1;
    }

    private void buildDFA(CMNode cMNode) {
        Object object;
        int n;
        this.fQName.setValues(null, fEOCString, fEOCString, null);
        CMLeaf cMLeaf = new CMLeaf(this.fQName);
        this.fHeadNode = new CMBinOp(5, cMNode, cMLeaf);
        this.fEOCPos = this.fLeafCount;
        cMLeaf.setPosition(this.fLeafCount++);
        this.fLeafList = new CMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int n2 = 0;
        while (n2 < this.fLeafCount) {
            this.fFollowList[n2] = new CMStateSet(this.fLeafCount);
            ++n2;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new QName[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        n2 = 0;
        while (n2 < this.fLeafCount) {
            this.fElemMap[n2] = new QName();
            QName qName = this.fLeafList[n2].getElement();
            n = 0;
            while (n < this.fElemMapSize) {
                if (this.fElemMap[n].rawname == qName.rawname) break;
                ++n;
            }
            if (n == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize].setValues(qName);
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[n2];
                ++this.fElemMapSize;
            }
            ++n2;
        }
        int[] nArray = new int[this.fLeafCount + this.fElemMapSize];
        int n3 = 0;
        n = 0;
        while (n < this.fElemMapSize) {
            int n4 = 0;
            while (n4 < this.fLeafCount) {
                object = this.fLeafList[n4].getElement();
                QName qName = this.fElemMap[n];
                if (((QName)object).rawname == qName.rawname) {
                    nArray[n3++] = n4;
                }
                ++n4;
            }
            nArray[n3++] = -1;
            ++n;
        }
        n = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n];
        this.fFinalStateFlags = new boolean[n];
        this.fTransTable = new int[n][];
        object = this.fHeadNode.firstPos();
        int n5 = 0;
        int n6 = 0;
        this.fTransTable[n6] = this.makeDefStateList();
        cMStateSetArray[n6] = object;
        ++n6;
        HashMap<CMStateSet, Integer> hashMap = new HashMap<CMStateSet, Integer>();
        while (n5 < n6) {
            object = cMStateSetArray[n5];
            int[] nArray2 = this.fTransTable[n5];
            this.fFinalStateFlags[n5] = ((CMStateSet)object).getBit(this.fEOCPos);
            ++n5;
            CMStateSet cMStateSet = null;
            int n7 = 0;
            int n8 = 0;
            while (n8 < this.fElemMapSize) {
                if (cMStateSet == null) {
                    cMStateSet = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet.zeroBits();
                }
                int n9 = nArray[n7++];
                while (n9 != -1) {
                    if (((CMStateSet)object).getBit(n9)) {
                        cMStateSet.union(this.fFollowList[n9]);
                    }
                    n9 = nArray[n7++];
                }
                if (!cMStateSet.isEmpty()) {
                    int n10;
                    Integer n11 = (Integer)hashMap.get(cMStateSet);
                    int n12 = n10 = n11 == null ? n6 : n11;
                    if (n10 == n6) {
                        cMStateSetArray[n6] = cMStateSet;
                        this.fTransTable[n6] = this.makeDefStateList();
                        hashMap.put(cMStateSet, new Integer(n6));
                        ++n6;
                        cMStateSet = null;
                    }
                    nArray2[n8] = n10;
                    if (n6 == n) {
                        int n13 = (int)((double)n * 1.5);
                        CMStateSet[] cMStateSetArray2 = new CMStateSet[n13];
                        boolean[] blArray = new boolean[n13];
                        int[][] nArrayArray = new int[n13][];
                        System.arraycopy(cMStateSetArray, 0, cMStateSetArray2, 0, n);
                        System.arraycopy(this.fFinalStateFlags, 0, blArray, 0, n);
                        System.arraycopy(this.fTransTable, 0, nArrayArray, 0, n);
                        n = n13;
                        cMStateSetArray = cMStateSetArray2;
                        this.fFinalStateFlags = blArray;
                        this.fTransTable = nArrayArray;
                    }
                }
                ++n8;
            }
        }
        this.fEmptyContentIsValid = ((CMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private void calcFollowList(CMNode cMNode) {
        if (cMNode.type() == 4) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((CMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((CMBinOp)cMNode).getRight().firstPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet2);
                }
                ++n;
            }
        } else if (cMNode.type() == 2 || cMNode.type() == 3) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet3.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet);
                }
                ++n;
            }
        } else if (cMNode.type() == 1) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
        }
    }

    private void dumpTree(CMNode cMNode, int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("   ");
            ++n2;
        }
        n2 = cMNode.type();
        if (n2 == 4 || n2 == 5) {
            if (n2 == 4) {
                System.out.print("Choice Node ");
            } else {
                System.out.print("Seq Node ");
            }
            if (cMNode.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
            this.dumpTree(((CMBinOp)cMNode).getLeft(), n + 1);
            this.dumpTree(((CMBinOp)cMNode).getRight(), n + 1);
        } else if (cMNode.type() == 2) {
            System.out.print("Rep Node ");
            if (cMNode.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
            this.dumpTree(((CMUniOp)cMNode).getChild(), n + 1);
        } else if (cMNode.type() == 0) {
            System.out.print("Leaf: (pos=" + ((CMLeaf)cMNode).getPosition() + "), " + ((CMLeaf)cMNode).getElement() + "(elemIndex=" + ((CMLeaf)cMNode).getElement() + ") ");
            if (cMNode.isNullable()) {
                System.out.print(" Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        int n = 0;
        while (n < this.fElemMapSize) {
            nArray[n] = -1;
            ++n;
        }
        return nArray;
    }

    private int postTreeBuildInit(CMNode cMNode, int n) {
        cMNode.setMaxStates(this.fLeafCount);
        if ((cMNode.type() & 0xF) == 6 || (cMNode.type() & 0xF) == 8 || (cMNode.type() & 0xF) == 7) {
            QName qName = new QName(null, null, null, ((CMAny)cMNode).getURI());
            this.fLeafList[n] = new CMLeaf(qName, ((CMAny)cMNode).getPosition());
            this.fLeafListType[n] = cMNode.type();
            ++n;
        } else if (cMNode.type() == 4 || cMNode.type() == 5) {
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getLeft(), n);
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getRight(), n);
        } else if (cMNode.type() == 2 || cMNode.type() == 3 || cMNode.type() == 1) {
            n = this.postTreeBuildInit(((CMUniOp)cMNode).getChild(), n);
        } else if (cMNode.type() == 0) {
            QName qName = ((CMLeaf)cMNode).getElement();
            if (qName.localpart != fEpsilonString) {
                this.fLeafList[n] = (CMLeaf)cMNode;
                this.fLeafListType[n] = 0;
                ++n;
            }
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM: type=" + cMNode.type());
        }
        return n;
    }
}

