/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.staticfield;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;

public class StaticFieldIndexer
implements IndexingFilter {
    private Configuration conf;
    private HashMap<String, String[]> fields;
    private boolean addStaticFields = false;

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        if (this.addStaticFields) {
            for (Map.Entry<String, String[]> entry : this.fields.entrySet()) {
                for (String val : entry.getValue()) {
                    doc.add(entry.getKey(), (Object)val);
                }
            }
        }
        return doc;
    }

    private HashMap<String, String[]> parseFields(String fieldsString) {
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        for (String field : fieldsString.split(",")) {
            String[] entry = field.split(":");
            if (entry.length != 2) continue;
            fields.put(entry[0].trim(), entry[1].trim().split(" "));
        }
        return fields;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String fieldsString = conf.get("index.static", null);
        if (fieldsString != null) {
            this.addStaticFields = true;
            this.fields = this.parseFields(fieldsString);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }
}

