/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.dummy;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.nutch.indexer.IndexWriter;
import org.apache.nutch.indexer.NutchDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyIndexWriter
implements IndexWriter {
    public static final Logger LOG = LoggerFactory.getLogger(DummyIndexWriter.class);
    private Configuration config;
    private Writer writer;
    private boolean delete = false;

    public void open(JobConf job, String name) throws IOException {
        this.delete = job.getBoolean("indexer.delete", false);
    }

    public void delete(String key) throws IOException {
        if (this.delete) {
            this.writer.write("delete\t" + key + "\n");
        }
    }

    public void update(NutchDocument doc) throws IOException {
        this.writer.write("update\t" + doc.getFieldValue("url") + "\n");
    }

    public void write(NutchDocument doc) throws IOException {
        this.writer.write("add\t" + doc.getFieldValue("url") + "\n");
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public void commit() throws IOException {
        this.writer.write("commit\n");
    }

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
        String path = conf.get("dummy.path");
        if (path == null) {
            String message = "Missing path. Should be set via -Ddummy.path";
            message = message + "\n" + this.describe();
            LOG.error(message);
            throw new RuntimeException(message);
        }
        try {
            this.writer = new BufferedWriter(new FileWriter(conf.get("dummy.path")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String describe() {
        StringBuffer sb = new StringBuffer("DummyIndexWriter\n");
        sb.append("\t").append("dummy.path : Path of the file to write to (mandatory)\n");
        return sb.toString();
    }
}

